/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search.type;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.ReduceSearchPhaseException;
import org.elasticsearch.action.search.SearchOperationThreading;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.action.search.type.TransportSearchCache;
import org.elasticsearch.action.search.type.TransportSearchHelper;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.trove.ExtTIntArrayList;
import org.elasticsearch.common.util.concurrent.jsr166y.LinkedTransferQueue;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.search.action.SearchServiceListener;
import org.elasticsearch.search.action.SearchServiceTransportAction;
import org.elasticsearch.search.controller.SearchPhaseController;
import org.elasticsearch.search.controller.ShardDoc;
import org.elasticsearch.search.internal.InternalSearchRequest;
import org.elasticsearch.search.query.QuerySearchResultProvider;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class TransportSearchTypeAction
extends TransportAction<SearchRequest, SearchResponse> {
    protected final ClusterService clusterService;
    protected final SearchServiceTransportAction searchService;
    protected final SearchPhaseController searchPhaseController;
    protected final TransportSearchCache searchCache;

    public TransportSearchTypeAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportSearchCache searchCache, SearchServiceTransportAction searchService, SearchPhaseController searchPhaseController) {
        super(settings, threadPool);
        this.clusterService = clusterService;
        this.searchCache = searchCache;
        this.searchService = searchService;
        this.searchPhaseController = searchPhaseController;
    }

    protected abstract class BaseAsyncAction<FirstResult extends SearchPhaseResult> {
        protected final ActionListener<SearchResponse> listener;
        private final GroupShardsIterator shardsIts;
        protected final SearchRequest request;
        protected final ClusterState clusterState;
        protected final DiscoveryNodes nodes;
        protected final int expectedSuccessfulOps;
        private final int expectedTotalOps;
        protected final AtomicInteger successulOps = new AtomicInteger();
        private final AtomicInteger totalOps = new AtomicInteger();
        private volatile LinkedTransferQueue<ShardSearchFailure> shardFailures;
        protected volatile ShardDoc[] sortedShardList;
        protected final long startTime = System.currentTimeMillis();

        protected BaseAsyncAction(SearchRequest request, ActionListener<SearchResponse> listener) {
            String[] concreteIndices;
            this.request = request;
            this.listener = listener;
            this.clusterState = TransportSearchTypeAction.this.clusterService.state();
            this.nodes = this.clusterState.nodes();
            this.clusterState.blocks().globalBlockedRaiseException(ClusterBlockLevel.READ);
            for (String index : concreteIndices = this.clusterState.metaData().concreteIndices(request.indices(), false, true)) {
                this.clusterState.blocks().indexBlockedRaiseException(ClusterBlockLevel.READ, index);
            }
            Map<String, Set<String>> routingMap = this.clusterState.metaData().resolveSearchRouting(request.routing(), request.indices());
            this.shardsIts = TransportSearchTypeAction.this.clusterService.operationRouting().searchShards(this.clusterState, request.indices(), concreteIndices, request.queryHint(), routingMap, request.preference());
            this.expectedSuccessfulOps = this.shardsIts.size();
            this.expectedTotalOps = this.shardsIts.totalSizeWith1ForEmpty();
            if (this.expectedSuccessfulOps == 0) {
                throw new SearchPhaseExecutionException("initial", "No indices / shards to search on, requested indices are " + Arrays.toString(request.indices()), this.buildShardFailures());
            }
        }

        public void start() {
            this.request.beforeStart();
            int localOperations = 0;
            for (ShardIterator shardIt : this.shardsIts) {
                ShardRouting shard = shardIt.firstOrNull();
                if (shard != null) {
                    if (shard.currentNodeId().equals(this.nodes.localNodeId())) {
                        ++localOperations;
                        continue;
                    }
                    this.performFirstPhase(shardIt);
                    continue;
                }
                this.onFirstPhaseResult((ShardRouting)null, shardIt, (Throwable)null);
            }
            if (localOperations > 0) {
                if (this.request.operationThreading() == SearchOperationThreading.SINGLE_THREAD) {
                    this.request.beforeLocalFork();
                    TransportSearchTypeAction.this.threadPool.executor("search").execute(new Runnable(){

                        @Override
                        public void run() {
                            for (ShardIterator shardIt : BaseAsyncAction.this.shardsIts) {
                                ShardRouting shard = shardIt.firstOrNull();
                                if (shard == null || !shard.currentNodeId().equals(BaseAsyncAction.this.nodes.localNodeId())) continue;
                                BaseAsyncAction.this.performFirstPhase(shardIt);
                            }
                        }
                    });
                } else {
                    boolean localAsync;
                    boolean bl = localAsync = this.request.operationThreading() == SearchOperationThreading.THREAD_PER_SHARD;
                    if (localAsync) {
                        this.request.beforeLocalFork();
                    }
                    for (final ShardIterator shardIt : this.shardsIts) {
                        ShardRouting shard = shardIt.firstOrNull();
                        if (shard == null || !shard.currentNodeId().equals(this.nodes.localNodeId())) continue;
                        if (localAsync) {
                            TransportSearchTypeAction.this.threadPool.executor("search").execute(new Runnable(){

                                @Override
                                public void run() {
                                    BaseAsyncAction.this.performFirstPhase(shardIt);
                                }
                            });
                            continue;
                        }
                        this.performFirstPhase(shardIt);
                    }
                }
            }
        }

        void performFirstPhase(ShardIterator shardIt) {
            this.performFirstPhase(shardIt, shardIt.nextOrNull());
        }

        void performFirstPhase(final ShardIterator shardIt, final ShardRouting shard) {
            if (shard == null) {
                this.onFirstPhaseResult((ShardRouting)null, shardIt, (Throwable)null);
            } else {
                DiscoveryNode node = this.nodes.get(shard.currentNodeId());
                if (node == null) {
                    this.onFirstPhaseResult(shard, shardIt, (Throwable)null);
                } else {
                    String[] filteringAliases = this.clusterState.metaData().filteringAliases(shard.index(), this.request.indices());
                    this.sendExecuteFirstPhase(node, TransportSearchHelper.internalSearchRequest(shard, this.shardsIts.size(), this.request, filteringAliases, this.startTime), new SearchServiceListener<FirstResult>(){

                        @Override
                        public void onResult(FirstResult result) {
                            BaseAsyncAction.this.onFirstPhaseResult(shard, result, shardIt);
                        }

                        @Override
                        public void onFailure(Throwable t) {
                            BaseAsyncAction.this.onFirstPhaseResult(shard, shardIt, t);
                        }
                    });
                }
            }
        }

        void onFirstPhaseResult(ShardRouting shard, FirstResult result, ShardIterator shardIt) {
            result.shardTarget(new SearchShardTarget(shard.currentNodeId(), shard.index(), shard.id()));
            this.processFirstPhaseResult(shard, result);
            int xTotalOps = this.totalOps.addAndGet(shardIt.remaining() + 1);
            this.successulOps.incrementAndGet();
            if (xTotalOps == this.expectedTotalOps) {
                try {
                    this.moveToSecondPhase();
                }
                catch (Exception e) {
                    if (TransportSearchTypeAction.this.logger.isDebugEnabled()) {
                        TransportSearchTypeAction.this.logger.debug(shardIt.shardId() + ": Failed to execute [" + this.request + "] while moving to second phase", e, new Object[0]);
                    }
                    this.listener.onFailure(new ReduceSearchPhaseException(this.firstPhaseName(), "", e, this.buildShardFailures()));
                }
            }
        }

        void onFirstPhaseResult(@Nullable ShardRouting shard, ShardIterator shardIt, Throwable t) {
            if (this.totalOps.incrementAndGet() == this.expectedTotalOps) {
                if (TransportSearchTypeAction.this.logger.isDebugEnabled() && t != null) {
                    if (shard != null) {
                        TransportSearchTypeAction.this.logger.debug(shard.shortSummary() + ": Failed to execute [" + this.request + "]", t, new Object[0]);
                    } else {
                        TransportSearchTypeAction.this.logger.debug(shardIt.shardId() + ": Failed to execute [" + this.request + "]", t, new Object[0]);
                    }
                }
                if (t == null) {
                    this.addShardFailure(new ShardSearchFailure("No active shards", new SearchShardTarget(null, shardIt.shardId().index().name(), shardIt.shardId().id())));
                } else {
                    this.addShardFailure(new ShardSearchFailure(t));
                }
                if (this.successulOps.get() == 0) {
                    this.listener.onFailure(new SearchPhaseExecutionException(this.firstPhaseName(), "total failure", this.buildShardFailures()));
                } else {
                    try {
                        this.moveToSecondPhase();
                    }
                    catch (Exception e) {
                        this.listener.onFailure(new ReduceSearchPhaseException(this.firstPhaseName(), "", e, this.buildShardFailures()));
                    }
                }
            } else {
                ShardRouting nextShard = shardIt.nextOrNull();
                if (nextShard != null) {
                    if (TransportSearchTypeAction.this.logger.isTraceEnabled() && t != null) {
                        if (shard != null) {
                            TransportSearchTypeAction.this.logger.trace(shard.shortSummary() + ": Failed to execute [" + this.request + "]", t, new Object[0]);
                        } else {
                            TransportSearchTypeAction.this.logger.trace(shardIt.shardId() + ": Failed to execute [" + this.request + "]", t, new Object[0]);
                        }
                    }
                    this.performFirstPhase(shardIt, nextShard);
                } else {
                    if (TransportSearchTypeAction.this.logger.isDebugEnabled() && t != null) {
                        if (shard != null) {
                            TransportSearchTypeAction.this.logger.debug(shard.shortSummary() + ": Failed to execute [" + this.request + "]", t, new Object[0]);
                        } else {
                            TransportSearchTypeAction.this.logger.debug(shardIt.shardId() + ": Failed to execute [" + this.request + "]", t, new Object[0]);
                        }
                    }
                    if (t == null) {
                        this.addShardFailure(new ShardSearchFailure("No active shards", new SearchShardTarget(null, shardIt.shardId().index().name(), shardIt.shardId().id())));
                    } else {
                        this.addShardFailure(new ShardSearchFailure(t));
                    }
                }
            }
        }

        protected final long buildTookInMillis() {
            return System.currentTimeMillis() - this.startTime;
        }

        protected final ShardSearchFailure[] buildShardFailures() {
            LinkedTransferQueue<ShardSearchFailure> localFailures = this.shardFailures;
            if (localFailures == null) {
                return ShardSearchFailure.EMPTY_ARRAY;
            }
            return localFailures.toArray(ShardSearchFailure.EMPTY_ARRAY);
        }

        protected final void addShardFailure(ShardSearchFailure failure) {
            if (this.shardFailures == null) {
                this.shardFailures = new LinkedTransferQueue();
            }
            this.shardFailures.add(failure);
        }

        protected void releaseIrrelevantSearchContexts(Map<SearchShardTarget, QuerySearchResultProvider> queryResults, Map<SearchShardTarget, ExtTIntArrayList> docIdsToLoad) {
            if (docIdsToLoad == null) {
                return;
            }
            if (this.request.scroll() == null) {
                for (Map.Entry<SearchShardTarget, QuerySearchResultProvider> entry : queryResults.entrySet()) {
                    DiscoveryNode node;
                    if (docIdsToLoad.containsKey(entry.getKey()) || (node = this.nodes.get(entry.getKey().nodeId())) == null) continue;
                    TransportSearchTypeAction.this.searchService.sendFreeContext(node, entry.getValue().id());
                }
            }
        }

        protected abstract void sendExecuteFirstPhase(DiscoveryNode var1, InternalSearchRequest var2, SearchServiceListener<FirstResult> var3);

        protected abstract void processFirstPhaseResult(ShardRouting var1, FirstResult var2);

        protected abstract void moveToSecondPhase() throws Exception;

        protected abstract String firstPhaseName();
    }
}

