/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.get;

import java.io.IOException;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.single.shard.SingleShardOperationRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Required;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class GetRequest
extends SingleShardOperationRequest {
    protected String type;
    protected String id;
    protected String routing;
    protected String preference;
    private String[] fields;
    private boolean refresh = false;
    Boolean realtime;

    GetRequest() {
        this.type = "_all";
    }

    public GetRequest(String index) {
        super(index);
        this.type = "_all";
    }

    public GetRequest(String index, String type, String id) {
        super(index);
        this.type = type;
        this.id = id;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.type == null) {
            validationException = ValidateActions.addValidationError("type is missing", validationException);
        }
        if (this.id == null) {
            validationException = ValidateActions.addValidationError("id is missing", validationException);
        }
        return validationException;
    }

    @Required
    public GetRequest index(String index) {
        this.index = index;
        return this;
    }

    public GetRequest type(@Nullable String type) {
        if (type == null) {
            type = "_all";
        }
        this.type = type;
        return this;
    }

    @Required
    public GetRequest id(String id) {
        this.id = id;
        return this;
    }

    public GetRequest parent(String parent) {
        if (this.routing == null) {
            this.routing = parent;
        }
        return this;
    }

    public GetRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public GetRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String type() {
        return this.type;
    }

    public String id() {
        return this.id;
    }

    public String routing() {
        return this.routing;
    }

    public String preference() {
        return this.preference;
    }

    public GetRequest fields(String ... fields) {
        this.fields = fields;
        return this;
    }

    public String[] fields() {
        return this.fields;
    }

    public GetRequest refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public boolean refresh() {
        return this.refresh;
    }

    public boolean realtime() {
        return this.realtime == null ? true : this.realtime;
    }

    public GetRequest realtime(Boolean realtime) {
        this.realtime = realtime;
        return this;
    }

    @Override
    public GetRequest listenerThreaded(boolean threadedListener) {
        super.listenerThreaded(threadedListener);
        return this;
    }

    @Override
    public GetRequest operationThreaded(boolean threadedOperation) {
        super.operationThreaded(threadedOperation);
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        byte realtime;
        super.readFrom(in);
        this.type = in.readUTF();
        this.id = in.readUTF();
        if (in.readBoolean()) {
            this.routing = in.readUTF();
        }
        if (in.readBoolean()) {
            this.preference = in.readUTF();
        }
        this.refresh = in.readBoolean();
        int size = in.readInt();
        if (size >= 0) {
            this.fields = new String[size];
            for (int i = 0; i < size; ++i) {
                this.fields[i] = in.readUTF();
            }
        }
        if ((realtime = in.readByte()) == 0) {
            this.realtime = false;
        } else if (realtime == 1) {
            this.realtime = true;
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeUTF(this.type);
        out.writeUTF(this.id);
        if (this.routing == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.routing);
        }
        if (this.preference == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.preference);
        }
        out.writeBoolean(this.refresh);
        if (this.fields == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(this.fields.length);
            for (String field : this.fields) {
                out.writeUTF(field);
            }
        }
        if (this.realtime == null) {
            out.writeByte((byte)-1);
        } else if (!this.realtime.booleanValue()) {
            out.writeByte((byte)0);
        } else {
            out.writeByte((byte)1);
        }
    }

    public String toString() {
        return "[" + this.index + "][" + this.type + "][" + this.id + "]: routing [" + this.routing + "]";
    }
}

