/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.status;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.status.DocsStatus;
import org.elasticsearch.action.admin.indices.status.IndexShardStatus;
import org.elasticsearch.action.admin.indices.status.ShardStatus;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.index.flush.FlushStats;
import org.elasticsearch.index.merge.MergeStats;
import org.elasticsearch.index.refresh.RefreshStats;

public class IndexStatus
implements Iterable<IndexShardStatus> {
    private final String index;
    private final Map<Integer, IndexShardStatus> indexShards;
    private transient DocsStatus docs;

    IndexStatus(String index, ShardStatus[] shards) {
        this.index = index;
        HashMap tmpIndexShards = Maps.newHashMap();
        for (ShardStatus shard : shards) {
            ArrayList<ShardStatus> lst = (ArrayList<ShardStatus>)tmpIndexShards.get(shard.shardRouting().id());
            if (lst == null) {
                lst = Lists.newArrayList();
                tmpIndexShards.put(shard.shardRouting().id(), lst);
            }
            lst.add(shard);
        }
        this.indexShards = Maps.newHashMap();
        for (Map.Entry entry : tmpIndexShards.entrySet()) {
            this.indexShards.put((Integer)entry.getKey(), new IndexShardStatus(((ShardStatus)((List)entry.getValue()).get(0)).shardRouting().shardId(), ((List)entry.getValue()).toArray(new ShardStatus[((List)entry.getValue()).size()])));
        }
    }

    public String index() {
        return this.index;
    }

    public String getIndex() {
        return this.index();
    }

    public Map<Integer, IndexShardStatus> shards() {
        return this.indexShards;
    }

    public Map<Integer, IndexShardStatus> getShards() {
        return this.shards();
    }

    public ByteSizeValue primaryStoreSize() {
        long bytes = -1L;
        for (IndexShardStatus shard : this) {
            if (shard.primaryStoreSize() == null) continue;
            if (bytes == -1L) {
                bytes = 0L;
            }
            bytes += shard.primaryStoreSize().bytes();
        }
        if (bytes == -1L) {
            return null;
        }
        return new ByteSizeValue(bytes);
    }

    public ByteSizeValue getPrimaryStoreSize() {
        return this.primaryStoreSize();
    }

    public ByteSizeValue storeSize() {
        long bytes = -1L;
        for (IndexShardStatus shard : this) {
            if (shard.storeSize() == null) continue;
            if (bytes == -1L) {
                bytes = 0L;
            }
            bytes += shard.storeSize().bytes();
        }
        if (bytes == -1L) {
            return null;
        }
        return new ByteSizeValue(bytes);
    }

    public ByteSizeValue getStoreSize() {
        return this.storeSize();
    }

    public long translogOperations() {
        long translogOperations = -1L;
        for (IndexShardStatus shard : this) {
            if (shard.translogOperations() == -1L) continue;
            if (translogOperations == -1L) {
                translogOperations = 0L;
            }
            translogOperations += shard.translogOperations();
        }
        return translogOperations;
    }

    public long getTranslogOperations() {
        return this.translogOperations();
    }

    public DocsStatus docs() {
        if (this.docs != null) {
            return this.docs;
        }
        DocsStatus docs = null;
        for (IndexShardStatus shard : this) {
            if (shard.docs() == null) continue;
            if (docs == null) {
                docs = new DocsStatus();
            }
            docs.numDocs += shard.docs().numDocs();
            docs.maxDoc += shard.docs().maxDoc();
            docs.deletedDocs += shard.docs().deletedDocs();
        }
        this.docs = docs;
        return docs;
    }

    public DocsStatus getDocs() {
        return this.docs();
    }

    public MergeStats mergeStats() {
        MergeStats mergeStats = new MergeStats();
        for (IndexShardStatus shard : this) {
            mergeStats.add(shard.mergeStats());
        }
        return mergeStats;
    }

    public MergeStats getMergeStats() {
        return this.mergeStats();
    }

    public RefreshStats refreshStats() {
        RefreshStats refreshStats = new RefreshStats();
        for (IndexShardStatus shard : this) {
            refreshStats.add(shard.refreshStats());
        }
        return refreshStats;
    }

    public RefreshStats getRefreshStats() {
        return this.refreshStats();
    }

    public FlushStats flushStats() {
        FlushStats flushStats = new FlushStats();
        for (IndexShardStatus shard : this) {
            flushStats.add(shard.flushStats());
        }
        return flushStats;
    }

    public FlushStats getFlushStats() {
        return this.flushStats();
    }

    @Override
    public Iterator<IndexShardStatus> iterator() {
        return this.indexShards.values().iterator();
    }
}

