/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.cache.clear;

import java.io.IOException;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.support.broadcast.BroadcastShardOperationRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

class ShardClearIndicesCacheRequest
extends BroadcastShardOperationRequest {
    private boolean filterCache = false;
    private boolean fieldDataCache = false;
    private boolean idCache = false;
    private boolean bloomCache = false;
    private String[] fields = null;

    ShardClearIndicesCacheRequest() {
    }

    public ShardClearIndicesCacheRequest(String index, int shardId, ClearIndicesCacheRequest request) {
        super(index, shardId);
        this.filterCache = request.filterCache();
        this.fieldDataCache = request.fieldDataCache();
        this.idCache = request.idCache();
        this.bloomCache = request.bloomCache();
        this.fields = request.fields();
    }

    public boolean filterCache() {
        return this.filterCache;
    }

    public boolean fieldDataCache() {
        return this.fieldDataCache;
    }

    public boolean idCache() {
        return this.idCache;
    }

    public boolean bloomCache() {
        return this.bloomCache;
    }

    public String[] fields() {
        return this.fields;
    }

    public ShardClearIndicesCacheRequest waitForOperations(boolean waitForOperations) {
        this.filterCache = waitForOperations;
        return this;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.filterCache = in.readBoolean();
        this.fieldDataCache = in.readBoolean();
        this.idCache = in.readBoolean();
        this.bloomCache = in.readBoolean();
        int size = in.readVInt();
        if (size > 0) {
            this.fields = new String[size];
            for (int i = 0; i < size; ++i) {
                this.fields[i] = in.readUTF();
            }
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeBoolean(this.filterCache);
        out.writeBoolean(this.fieldDataCache);
        out.writeBoolean(this.idCache);
        out.writeBoolean(this.bloomCache);
        if (this.fields == null) {
            out.writeVInt(0);
        } else {
            out.writeVInt(this.fields.length);
            for (String field : this.fields) {
                out.writeUTF(field);
            }
        }
    }
}

