/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import java.io.Serializable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.monitor.jvm.JvmInfo;

public class Version
implements Serializable {
    public static final int V_0_18_0_ID = 180099;
    public static final Version V_0_18_0 = new Version(180099, false);
    public static final int V_0_18_1_ID = 180199;
    public static final Version V_0_18_1 = new Version(180199, false);
    public static final int V_0_18_2_ID = 180299;
    public static final Version V_0_18_2 = new Version(180299, false);
    public static final int V_0_18_3_ID = 180399;
    public static final Version V_0_18_3 = new Version(180399, false);
    public static final int V_0_18_4_ID = 180499;
    public static final Version V_0_18_4 = new Version(180499, false);
    public static final int V_0_18_5_ID = 180599;
    public static final Version V_0_18_5 = new Version(180599, false);
    public static final int V_0_18_6_ID = 180699;
    public static final Version V_0_18_6 = new Version(180699, false);
    public static final int V_0_18_7_ID = 180799;
    public static final Version V_0_18_7 = new Version(180799, false);
    public static final int V_0_18_8_ID = 180899;
    public static final Version V_0_18_8 = new Version(180899, false);
    public static final int V_0_19_0_RC1_ID = 190051;
    public static final Version V_0_19_0_RC1 = new Version(190051, false);
    public static final int V_0_19_0_RC2_ID = 190052;
    public static final Version V_0_19_0_RC2 = new Version(190052, false);
    public static final int V_0_19_0_RC3_ID = 190053;
    public static final Version V_0_19_0_RC3 = new Version(190053, false);
    public static final int V_0_19_0_ID = 190099;
    public static final Version V_0_19_0 = new Version(190099, false);
    public static final int V_0_19_1_ID = 190199;
    public static final Version V_0_19_1 = new Version(190199, false);
    public static final int V_0_19_2_ID = 190299;
    public static final Version V_0_19_2 = new Version(190299, false);
    public static final int V_0_19_3_ID = 190399;
    public static final Version V_0_19_3 = new Version(190399, false);
    public static final int V_0_19_4_ID = 190499;
    public static final Version V_0_19_4 = new Version(190499, false);
    public static final int V_0_19_5_ID = 190599;
    public static final Version V_0_19_5 = new Version(190599, false);
    public static final int V_0_19_6_ID = 190699;
    public static final Version V_0_19_6 = new Version(190699, false);
    public static final int V_0_19_7_ID = 190799;
    public static final Version V_0_19_7 = new Version(190799, false);
    public static final int V_0_19_8_ID = 190899;
    public static final Version V_0_19_8;
    public static final Version CURRENT;
    public final int id;
    public final byte major;
    public final byte minor;
    public final byte revision;
    public final byte build;
    public final Boolean snapshot;

    public static Version readVersion(StreamInput in) throws IOException {
        return Version.fromId(in.readVInt());
    }

    public static Version fromId(int id) {
        switch (id) {
            case 180099: {
                return V_0_18_0;
            }
            case 180199: {
                return V_0_18_1;
            }
            case 180299: {
                return V_0_18_2;
            }
            case 180399: {
                return V_0_18_3;
            }
            case 180499: {
                return V_0_18_4;
            }
            case 180599: {
                return V_0_18_5;
            }
            case 180699: {
                return V_0_18_6;
            }
            case 180799: {
                return V_0_18_7;
            }
            case 180899: {
                return V_0_18_8;
            }
            case 190051: {
                return V_0_19_0_RC1;
            }
            case 190052: {
                return V_0_19_0_RC2;
            }
            case 190053: {
                return V_0_19_0_RC3;
            }
            case 190099: {
                return V_0_19_0;
            }
            case 190199: {
                return V_0_19_1;
            }
            case 190299: {
                return V_0_19_2;
            }
            case 190399: {
                return V_0_19_3;
            }
            case 190499: {
                return V_0_19_4;
            }
            case 190599: {
                return V_0_19_5;
            }
            case 190699: {
                return V_0_19_6;
            }
            case 190799: {
                return V_0_19_7;
            }
            case 190899: {
                return V_0_19_8;
            }
        }
        return new Version(id, null);
    }

    public static void writeVersion(Version version, StreamOutput out) throws IOException {
        out.writeVInt(version.id);
    }

    Version(int id, @Nullable Boolean snapshot) {
        this.id = id;
        this.major = (byte)(id / 1000000 % 100);
        this.minor = (byte)(id / 10000 % 100);
        this.revision = (byte)(id / 100 % 100);
        this.build = (byte)(id % 100);
        this.snapshot = snapshot;
    }

    public boolean snapshot() {
        return this.snapshot != null && this.snapshot != false;
    }

    public boolean after(Version version) {
        return version.id > this.id;
    }

    public boolean onOrAfter(Version version) {
        return version.id >= this.id;
    }

    public String number() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.revision);
        if (this.build < 50) {
            sb.append(".Beta").append(this.build);
        } else if (this.build < 99) {
            sb.append(".RC").append(this.build - 50);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println("ElasticSearch Version: " + CURRENT + ", JVM: " + JvmInfo.jvmInfo().vmVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.number());
        if (this.snapshot()) {
            sb.append("-SNAPSHOT");
        }
        return sb.toString();
    }

    static {
        CURRENT = V_0_19_8 = new Version(190899, false);
    }
}

