/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.vectorhighlight;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.vectorhighlight.BaseFragmentsBuilder;
import org.apache.lucene.search.vectorhighlight.BoundaryScanner;
import org.apache.lucene.search.vectorhighlight.FieldFragList;
import org.apache.lucene.search.vectorhighlight.FieldPhraseList;

public abstract class AbstractFragmentsBuilder
extends BaseFragmentsBuilder {
    private boolean discreteMultiValueHighlighting = true;

    protected AbstractFragmentsBuilder() {
    }

    protected AbstractFragmentsBuilder(BoundaryScanner boundaryScanner) {
        super(boundaryScanner);
    }

    protected AbstractFragmentsBuilder(String[] preTags, String[] postTags) {
        super(preTags, postTags);
    }

    public AbstractFragmentsBuilder(String[] preTags, String[] postTags, BoundaryScanner bs) {
        super(preTags, postTags, bs);
    }

    public void setDiscreteMultiValueHighlighting(boolean discreteMultiValueHighlighting) {
        this.discreteMultiValueHighlighting = discreteMultiValueHighlighting;
    }

    public String[] createFragments(IndexReader reader, int docId, String fieldName, FieldFragList fieldFragList, int maxNumFragments, String[] preTags, String[] postTags, Encoder encoder) throws IOException {
        if (maxNumFragments < 0) {
            throw new IllegalArgumentException("maxNumFragments(" + maxNumFragments + ") must be positive number.");
        }
        ArrayList<String> fragments = new ArrayList<String>(maxNumFragments);
        List<FieldFragList.WeightedFragInfo> fragInfos = fieldFragList.getFragInfos();
        Field[] values = this.getFields(reader, docId, fieldName);
        if (values.length == 0) {
            return null;
        }
        if (this.discreteMultiValueHighlighting && values.length > 1) {
            fragInfos = this.discreteMultiValueHighlighting(fragInfos, values);
        }
        fragInfos = this.getWeightedFragInfoList(fragInfos);
        StringBuilder buffer = new StringBuilder();
        int[] nextValueIndex = new int[]{0};
        for (int n = 0; n < maxNumFragments && n < fragInfos.size(); ++n) {
            FieldFragList.WeightedFragInfo fragInfo = fragInfos.get(n);
            fragments.add(this.makeFragment(buffer, nextValueIndex, values, fragInfo, preTags, postTags, encoder));
        }
        return fragments.toArray(new String[fragments.size()]);
    }

    protected List<FieldFragList.WeightedFragInfo> discreteMultiValueHighlighting(List<FieldFragList.WeightedFragInfo> fragInfos, Field[] fields) {
        HashMap fieldNameToFragInfos = new HashMap();
        for (Field field : fields) {
            fieldNameToFragInfos.put(field.name(), new ArrayList());
        }
        block1: for (FieldFragList.WeightedFragInfo fragInfo : fragInfos) {
            int fieldEnd = 0;
            for (Field field : fields) {
                if (field.stringValue().isEmpty()) {
                    ++fieldEnd;
                    continue;
                }
                int fieldStart = fieldEnd;
                if (fragInfo.getStartOffset() >= fieldStart && fragInfo.getEndOffset() >= fieldStart && fragInfo.getStartOffset() <= (fieldEnd += field.stringValue().length() + 1) && fragInfo.getEndOffset() <= fieldEnd) {
                    ((List)fieldNameToFragInfos.get(field.name())).add(fragInfo);
                    continue block1;
                }
                if (fragInfo.getSubInfos().isEmpty()) continue block1;
                FieldPhraseList.WeightedPhraseInfo.Toffs firstToffs = (FieldPhraseList.WeightedPhraseInfo.Toffs)((FieldFragList.WeightedFragInfo.SubInfo)fragInfo.getSubInfos().get(0)).getTermsOffsets().get(0);
                if (fragInfo.getStartOffset() >= fieldEnd || firstToffs.getStartOffset() >= fieldEnd) continue;
                int fragStart = fieldStart;
                if (fragInfo.getStartOffset() > fieldStart && fragInfo.getStartOffset() < fieldEnd) {
                    fragStart = fragInfo.getStartOffset();
                }
                int fragEnd = fieldEnd;
                if (fragInfo.getEndOffset() > fieldStart && fragInfo.getEndOffset() < fieldEnd) {
                    fragEnd = fragInfo.getEndOffset();
                }
                ArrayList<FieldFragList.WeightedFragInfo.SubInfo> subInfos = new ArrayList<FieldFragList.WeightedFragInfo.SubInfo>();
                WeightedFragInfo weightedFragInfo = new WeightedFragInfo(fragStart, fragEnd, fragInfo.getTotalBoost(), subInfos);
                Iterator subInfoIterator = fragInfo.getSubInfos().iterator();
                while (subInfoIterator.hasNext()) {
                    FieldFragList.WeightedFragInfo.SubInfo subInfo = (FieldFragList.WeightedFragInfo.SubInfo)subInfoIterator.next();
                    ArrayList<FieldPhraseList.WeightedPhraseInfo.Toffs> toffsList = new ArrayList<FieldPhraseList.WeightedPhraseInfo.Toffs>();
                    Iterator toffsIterator = subInfo.getTermsOffsets().iterator();
                    while (toffsIterator.hasNext()) {
                        FieldPhraseList.WeightedPhraseInfo.Toffs toffs = (FieldPhraseList.WeightedPhraseInfo.Toffs)toffsIterator.next();
                        if (toffs.getStartOffset() < fieldStart || toffs.getEndOffset() > fieldEnd) continue;
                        toffsList.add(toffs);
                        toffsIterator.remove();
                    }
                    if (!toffsList.isEmpty()) {
                        subInfos.add(new FieldFragList.WeightedFragInfo.SubInfo(subInfo.text, toffsList, subInfo.getSeqnum()));
                    }
                    if (!subInfo.getTermsOffsets().isEmpty()) continue;
                    subInfoIterator.remove();
                }
                ((List)fieldNameToFragInfos.get(field.name())).add(weightedFragInfo);
            }
        }
        ArrayList<FieldFragList.WeightedFragInfo> result = new ArrayList<FieldFragList.WeightedFragInfo>();
        for (List weightedFragInfos : fieldNameToFragInfos.values()) {
            result.addAll(weightedFragInfos);
        }
        Collections.sort(result, new Comparator<FieldFragList.WeightedFragInfo>(){

            @Override
            public int compare(FieldFragList.WeightedFragInfo info1, FieldFragList.WeightedFragInfo info2) {
                return info1.getStartOffset() - info2.getStartOffset();
            }
        });
        return result;
    }

    private static class WeightedFragInfo
    extends FieldFragList.WeightedFragInfo {
        private static final List<FieldPhraseList.WeightedPhraseInfo> EMPTY = Collections.emptyList();

        private WeightedFragInfo(int startOffset, int endOffset, float totalBoost, List<FieldFragList.WeightedFragInfo.SubInfo> subInfos) {
            super(startOffset, endOffset, EMPTY);
            this.subInfos = subInfos;
            this.totalBoost = totalBoost;
        }
    }
}

