/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import java.util.Properties;

public final class OptionsSupport {
    private static final String UNAVAILABLE = "n/a";

    public static String updateUrl(String url, Properties props) {
        String readPreferenceType;
        String writeConcernType;
        String threadsAllowedToBlockForConnectionMultiplier;
        String result = url;
        String maxConnections = props.getProperty("mongodb.maxconnections", UNAVAILABLE).toLowerCase();
        if (!UNAVAILABLE.equals(maxConnections)) {
            result = OptionsSupport.addUrlOption(result, "maxPoolSize", maxConnections);
        }
        if (!UNAVAILABLE.equals(threadsAllowedToBlockForConnectionMultiplier = props.getProperty("mongodb.threadsAllowedToBlockForConnectionMultiplier", UNAVAILABLE).toLowerCase())) {
            result = OptionsSupport.addUrlOption(result, "waitQueueMultiple", threadsAllowedToBlockForConnectionMultiplier);
        }
        if (!UNAVAILABLE.equals(writeConcernType = props.getProperty("mongodb.writeConcern", UNAVAILABLE).toLowerCase())) {
            if ("errors_ignored".equals(writeConcernType)) {
                result = OptionsSupport.addUrlOption(result, "w", "0");
            } else if ("unacknowledged".equals(writeConcernType)) {
                result = OptionsSupport.addUrlOption(result, "w", "0");
            } else if ("acknowledged".equals(writeConcernType)) {
                result = OptionsSupport.addUrlOption(result, "w", "1");
            } else if ("journaled".equals(writeConcernType)) {
                result = OptionsSupport.addUrlOption(result, "journal", "true");
                result = OptionsSupport.addUrlOption(result, "j", "true");
            } else if ("replica_acknowledged".equals(writeConcernType)) {
                result = OptionsSupport.addUrlOption(result, "w", "2");
            } else if ("majority".equals(writeConcernType)) {
                result = OptionsSupport.addUrlOption(result, "w", "majority");
            } else {
                System.err.println("WARNING: Invalid writeConcern: '" + writeConcernType + "' will be ignored. " + "Must be one of [ unacknowledged | acknowledged | " + "journaled | replica_acknowledged | majority ]");
            }
        }
        if (!UNAVAILABLE.equals(readPreferenceType = props.getProperty("mongodb.readPreference", UNAVAILABLE).toLowerCase())) {
            if ("primary".equals(readPreferenceType)) {
                result = OptionsSupport.addUrlOption(result, "readPreference", "primary");
            } else if ("primary_preferred".equals(readPreferenceType)) {
                result = OptionsSupport.addUrlOption(result, "readPreference", "primaryPreferred");
            } else if ("secondary".equals(readPreferenceType)) {
                result = OptionsSupport.addUrlOption(result, "readPreference", "secondary");
            } else if ("secondary_preferred".equals(readPreferenceType)) {
                result = OptionsSupport.addUrlOption(result, "readPreference", "secondaryPreferred");
            } else if ("nearest".equals(readPreferenceType)) {
                result = OptionsSupport.addUrlOption(result, "readPreference", "nearest");
            } else {
                System.err.println("WARNING: Invalid readPreference: '" + readPreferenceType + "' will be ignored. " + "Must be one of [ primary | primary_preferred | " + "secondary | secondary_preferred | nearest ]");
            }
        }
        return result;
    }

    private static String addUrlOption(String url, String name, String value) {
        String fullName = name + "=";
        if (!url.contains(fullName)) {
            if (url.contains("?")) {
                return url + "&" + fullName + value;
            }
            return url + "?" + fullName + value;
        }
        return url;
    }

    private OptionsSupport() {
    }
}

