/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.support.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.springframework.shell.support.util.OsUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.FileCopyUtils;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FileUtils {
    private static final String BACKSLASH = "\\";
    private static final String ESCAPED_BACKSLASH = "\\\\";
    public static final String CURRENT_DIRECTORY = ".";
    private static final String WINDOWS_DRIVE_PREFIX = "^[A-Za-z]:";
    private static final Pattern WINDOWS_DRIVE_PATH = Pattern.compile("^[A-Za-z]:.*");
    private static final PathMatcher PATH_MATCHER = new AntPathMatcher();

    public static boolean deleteRecursively(File file) {
        Assert.notNull((Object)file, (String)"File to delete required");
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                if (FileUtils.deleteRecursively(f)) continue;
                return false;
            }
        }
        file.delete();
        return true;
    }

    public static boolean copyRecursively(File source, File destination, boolean deleteDestinationOnExit) {
        Assert.notNull((Object)source, (String)"Source directory required");
        Assert.notNull((Object)destination, (String)"Destination directory required");
        Assert.isTrue((boolean)source.exists(), (String)("Source directory '" + source + "' must exist"));
        Assert.isTrue((boolean)source.isDirectory(), (String)("Source directory '" + source + "' must be a directory"));
        if (destination.exists()) {
            Assert.isTrue((boolean)destination.isDirectory(), (String)("Destination directory '" + destination + "' must be a directory"));
        } else {
            destination.mkdirs();
            if (deleteDestinationOnExit) {
                destination.deleteOnExit();
            }
        }
        for (File s : source.listFiles()) {
            File d = new File(destination, s.getName());
            if (deleteDestinationOnExit) {
                d.deleteOnExit();
            }
            if (s.isFile()) {
                try {
                    FileCopyUtils.copy((File)s, (File)d);
                    continue;
                }
                catch (IOException ioe) {
                    return false;
                }
            }
            d.mkdir();
            if (FileUtils.copyRecursively(s, d, deleteDestinationOnExit)) continue;
            return false;
        }
        return true;
    }

    public static boolean denotesAbsolutePath(String fileName) {
        if (OsUtils.isWindows() && WINDOWS_DRIVE_PATH.matcher(fileName).matches()) {
            return true;
        }
        return fileName.startsWith(File.separator);
    }

    public static String getFirstDirectory(String fileIdentifier) {
        if (new File(fileIdentifier = FileUtils.removeTrailingSeparator(fileIdentifier)).isDirectory()) {
            return fileIdentifier;
        }
        return FileUtils.backOneDirectory(fileIdentifier);
    }

    public static String backOneDirectory(String fileIdentifier) {
        fileIdentifier = FileUtils.removeTrailingSeparator(fileIdentifier);
        fileIdentifier = fileIdentifier.substring(0, fileIdentifier.lastIndexOf(File.separator));
        return FileUtils.removeTrailingSeparator(fileIdentifier);
    }

    public static String removeTrailingSeparator(String path) {
        while (path != null && path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - File.separator.length());
        }
        return path;
    }

    public static boolean matchesAntPath(String antPattern, String canonicalPath) {
        Assert.hasText((String)antPattern, (String)"Ant pattern required");
        Assert.hasText((String)canonicalPath, (String)"Canonical path required");
        return PATH_MATCHER.match(antPattern, canonicalPath);
    }

    public static String removeLeadingAndTrailingSeparators(String path) {
        if (!StringUtils.hasText((String)path)) {
            return path;
        }
        while (path.endsWith(File.separator)) {
            path = path.substring(0, path.length() - File.separator.length());
        }
        while (path.startsWith(File.separator)) {
            path = path.substring(File.separator.length());
        }
        return path;
    }

    public static String ensureTrailingSeparator(String path) {
        Assert.notNull((Object)path);
        return FileUtils.removeTrailingSeparator(path) + File.separatorChar;
    }

    public static String getSystemDependentPath(String ... pathElements) {
        return FileUtils.getSystemDependentPath(Arrays.asList(pathElements));
    }

    public static String getSystemDependentPath(Collection<String> pathElements) {
        Assert.notEmpty(pathElements);
        return StringUtils.collectionToDelimitedString(pathElements, (String)File.separator);
    }

    public static String getCanonicalPath(File file) {
        if (file == null) {
            return null;
        }
        try {
            return file.getCanonicalPath();
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Cannot determine canonical path for '" + file + "'", ioe);
        }
    }

    public static String getFileSeparatorAsRegex() {
        String fileSeparator = File.separator;
        if (fileSeparator.contains(BACKSLASH)) {
            return fileSeparator.replace(BACKSLASH, ESCAPED_BACKSLASH);
        }
        return fileSeparator;
    }

    public static String getPath(Class<?> loadingClass, String relativeFilename) {
        Assert.notNull(loadingClass, (String)"Loading class required");
        Assert.hasText((String)relativeFilename, (String)"Filename required");
        Assert.isTrue((!relativeFilename.startsWith("/") ? 1 : 0) != 0, (String)"Filename shouldn't start with a slash");
        return "/" + loadingClass.getPackage().getName().replace('.', '/') + "/" + relativeFilename;
    }

    public static File getFile(Class<?> loadingClass, String filename) {
        URL url = loadingClass.getResource(filename);
        Assert.notNull((Object)url, (String)("Could not locate '" + filename + "' in classpath of " + loadingClass.getName()));
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static InputStream getInputStream(Class<?> loadingClass, String filename) {
        InputStream inputStream = loadingClass.getResourceAsStream(filename);
        Assert.notNull((Object)inputStream, (String)("Could not locate '" + filename + "' in classpath of " + loadingClass.getName()));
        return inputStream;
    }

    public static String readBanner(Reader reader) {
        try {
            String content = FileCopyUtils.copyToString((Reader)new BufferedReader(reader));
            return content.replaceAll("(\\r|\\n)+", OsUtils.LINE_SEPARATOR);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot read stream", ex);
        }
    }

    public static String readBanner(Class<?> loadingClass, String resourceName) {
        return FileUtils.readBanner(new InputStreamReader(FileUtils.getInputStream(loadingClass, resourceName)));
    }

    public static String read(File file) {
        try {
            return FileCopyUtils.copyToString((Reader)new FileReader(file));
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private FileUtils() {
    }

    static {
        ((AntPathMatcher)PATH_MATCHER).setPathSeparator(File.separator);
    }
}

