/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.shell.commands;

import java.io.IOException;
import java.util.logging.Logger;
import org.springframework.shell.commands.OsOperations;
import org.springframework.shell.commands.OsOperationsImpl;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;
import org.springframework.shell.support.logging.HandlerUtils;
import org.springframework.stereotype.Component;

@Component
public class OsCommands
implements CommandMarker {
    private static final Logger LOGGER = HandlerUtils.getLogger(OsCommands.class);
    private OsOperations osOperations = new OsOperationsImpl();

    @CliCommand(value={"!"}, help="Allows execution of operating system (OS) commands.")
    public void command(@CliOption(key={"", "command"}, mandatory=false, specifiedDefaultValue="", unspecifiedDefaultValue="", help="The command to execute") String command) {
        System.out.println("command is:" + command);
        if (command != null && command.length() > 0) {
            try {
                this.osOperations.executeCommand(command);
            }
            catch (IOException e) {
                LOGGER.severe("Unable to execute command " + command + " [" + e.getMessage() + "]");
            }
        }
    }
}

