/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.yahoo.ycsb.ByteArrayByteIterator;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.thrift.TException;
import org.hypertable.thrift.SerializedCellsReader;
import org.hypertable.thrift.SerializedCellsWriter;
import org.hypertable.thrift.ThriftClient;
import org.hypertable.thriftgen.Cell;
import org.hypertable.thriftgen.ClientException;
import org.hypertable.thriftgen.Key;
import org.hypertable.thriftgen.KeyFlag;
import org.hypertable.thriftgen.RowInterval;
import org.hypertable.thriftgen.ScanSpec;

public class HypertableClient
extends DB {
    private boolean _debug = false;
    private ThriftClient connection;
    private long ns;
    private String _columnFamily = "";
    public static final int OK = 0;
    public static final int SERVERERROR = -1;
    public static final String NAMESPACE = "/ycsb";
    public static final int THRIFTBROKER_PORT = 38080;
    public static final int BUFFER_SIZE = 4096;

    public void init() throws DBException {
        if (this.getProperties().getProperty("debug") != null && this.getProperties().getProperty("debug").equals("true")) {
            this._debug = true;
        }
        try {
            this.connection = ThriftClient.create((String)"localhost", (int)38080);
            if (!this.connection.namespace_exists(NAMESPACE)) {
                this.connection.namespace_create(NAMESPACE);
            }
            this.ns = this.connection.open_namespace(NAMESPACE);
        }
        catch (ClientException e) {
            throw new DBException("Could not open namespace", (Throwable)e);
        }
        catch (TException e) {
            throw new DBException("Could not open namespace", (Throwable)e);
        }
        this._columnFamily = this.getProperties().getProperty("columnfamily");
        if (this._columnFamily == null) {
            System.err.println("Error, must specify a columnfamily for Hypertable table");
            throw new DBException("No columnfamily specified");
        }
    }

    public void cleanup() throws DBException {
        try {
            this.connection.namespace_close(this.ns);
        }
        catch (ClientException e) {
            throw new DBException("Could not close namespace", (Throwable)e);
        }
        catch (TException e) {
            throw new DBException("Could not close namespace", (Throwable)e);
        }
    }

    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        if (this._debug) {
            System.out.println("Doing read from Hypertable columnfamily " + this._columnFamily);
            System.out.println("Doing read for key: " + key);
        }
        try {
            if (null != fields) {
                Vector<HashMap<String, ByteIterator>> resMap = new Vector<HashMap<String, ByteIterator>>();
                if (0 != this.scan(table, key, 1, fields, resMap)) {
                    return -1;
                }
                if (!resMap.isEmpty()) {
                    result.putAll((Map<String, ByteIterator>)resMap.firstElement());
                }
            } else {
                SerializedCellsReader reader = new SerializedCellsReader(null);
                reader.reset(this.connection.get_row_serialized(this.ns, table, key));
                while (reader.next()) {
                    result.put(new String(reader.get_column_qualifier()), (ByteIterator)new ByteArrayByteIterator(reader.get_value()));
                }
            }
        }
        catch (ClientException e) {
            if (this._debug) {
                System.err.println("Error doing read: " + e.message);
            }
            return -1;
        }
        catch (TException e) {
            if (this._debug) {
                System.err.println("Error doing read");
            }
            return -1;
        }
        return 0;
    }

    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        ScanSpec spec = new ScanSpec();
        RowInterval elem = new RowInterval();
        elem.setStart_inclusive(true);
        elem.setStart_row(startkey);
        spec.addToRow_intervals(elem);
        if (null != fields) {
            for (String field : fields) {
                spec.addToColumns(this._columnFamily + ":" + field);
            }
        }
        spec.setVersions(1);
        spec.setRow_limit(recordcount);
        SerializedCellsReader reader = new SerializedCellsReader(null);
        try {
            long sc = this.connection.scanner_open(this.ns, table, spec);
            String lastRow = null;
            boolean eos = false;
            while (!eos) {
                reader.reset(this.connection.scanner_get_cells_serialized(sc));
                while (reader.next()) {
                    String currentRow = new String(reader.get_row());
                    if (!currentRow.equals(lastRow)) {
                        result.add(new HashMap());
                        lastRow = currentRow;
                    }
                    result.lastElement().put(new String(reader.get_column_qualifier()), (ByteIterator)new ByteArrayByteIterator(reader.get_value()));
                }
                eos = reader.eos();
                if (!this._debug) continue;
                System.out.println("Number of rows retrieved so far: " + result.size());
            }
            this.connection.scanner_close(sc);
        }
        catch (ClientException e) {
            if (this._debug) {
                System.err.println("Error doing scan: " + e.message);
            }
            return -1;
        }
        catch (TException e) {
            if (this._debug) {
                System.err.println("Error doing scan");
            }
            return -1;
        }
        return 0;
    }

    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        return this.insert(table, key, values);
    }

    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        if (this._debug) {
            System.out.println("Setting up put for key: " + key);
        }
        try {
            long mutator = this.connection.mutator_open(this.ns, table, 0, 0);
            SerializedCellsWriter writer = new SerializedCellsWriter(4096 * values.size(), true);
            for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
                writer.add(key, this._columnFamily, entry.getKey(), -9223372036854775806L, ByteBuffer.wrap(entry.getValue().toArray()));
            }
            this.connection.mutator_set_cells_serialized(mutator, writer.buffer(), true);
            this.connection.mutator_close(mutator);
        }
        catch (ClientException e) {
            if (this._debug) {
                System.err.println("Error doing set: " + e.message);
            }
            return -1;
        }
        catch (TException e) {
            if (this._debug) {
                System.err.println("Error doing set");
            }
            return -1;
        }
        return 0;
    }

    public int delete(String table, String key) {
        if (this._debug) {
            System.out.println("Doing delete for key: " + key);
        }
        Cell entry = new Cell();
        entry.key = new Key();
        entry.key.row = key;
        entry.key.flag = KeyFlag.DELETE_ROW;
        try {
            this.connection.set_cell(this.ns, table, entry);
        }
        catch (ClientException e) {
            if (this._debug) {
                System.err.println("Error doing delete: " + e.message);
            }
            return -1;
        }
        catch (TException e) {
            if (this._debug) {
                System.err.println("Error doing delete");
            }
            return -1;
        }
        return 0;
    }
}

