/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.licensecheck;

import com.springsource.vfabric.licensing.log.Logger;
import com.vmware.licensecheck.BitVector;
import com.vmware.licensecheck.BitVectorHelper;
import com.vmware.licensecheck.HashUtil;
import com.vmware.licensecheck.LicenseAttributes;
import com.vmware.licensecheck.SerialNumException;
import com.vmware.licensecheck.SerialNumber;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class SerialNumChecker {
    private static final int SERIAL_FULLSTR2_LEN = 25;
    private static final int SERIAL_BATCH_SIZE = 15;
    private static final int SERIAL_VERSION_SIZE = 5;
    private static final int SERIAL_UNIT_SIZE = 25;
    private static final int SERIAL_ISSUEDATE_SIZE = 12;
    private static final int SERIAL_EXPPER2_SIZE = 2;
    private static final int SERIAL_SUBSCRIPTION_SIZE = 3;
    private static final int SERIAL_MAXPROC2_SIZE = 16;
    private static final int SERIAL_SUPPORT_SIZE = 2;
    private static final int SERIAL_ADDON_SIZE = 5;
    private static final int SERIAL_RESERVED_2_1_SIZE = 0;
    private static final int SERIAL_HASH1_SIZE = 40;
    private static final int SERIAL_RESERVED_2_SIZE = 40;
    private static final int SERIAL2_SIZE = 125;
    private static final int[] serial_full2 = new int[]{25, 21, 1, 16, 19, 0, 20, 8, 22, 24, 27, 2, 9, 10, 6, 14, 26, 28, 3, 4, 12, 13, 7, 15, 18};
    private static final String serial_alphabet = "0123456789ACDEFGHJKLMNPQRTUVWXYZ";
    private static final int SHA1_HASH_LEN = 20;

    public static boolean checkSerialNumberSyntax(String serial) {
        return serial.matches("\\p{Alnum}{5}(-\\p{Alnum}{5}){4}");
    }

    public static String formatSerial(String serial) {
        String outSerial = serial.toUpperCase();
        outSerial = outSerial.replace('B', '8');
        outSerial = outSerial.replace('I', '1');
        outSerial = outSerial.replace('O', '0');
        outSerial = outSerial.replace('S', '5');
        return outSerial;
    }

    public static SerialNumber serialDecode(String serialNum) throws SerialNumException {
        BitVector bv = SerialNumChecker.serialHuman2bitvector2(serialNum);
        if (bv != null) {
            return SerialNumChecker.serialDecode2(serialNum, bv);
        }
        return null;
    }

    public static boolean checkValidDlfWithSN(SerialNumber serial, String licenseHash) throws SerialNumException {
        Logger log = Logger.getLogger(SerialNumChecker.class);
        long serialHash = serial.getHash();
        BitVector bv = serial.getBv();
        try {
            long theoretical_hash = SerialNumChecker.serial_hash4(bv, licenseHash);
            return serialHash == theoretical_hash;
        }
        catch (NoSuchAlgorithmException e) {
            log.warn(e.getMessage());
            log.debug(e.getMessage(), e);
            throw new SerialNumException(e);
        }
    }

    private static BitVector serialHuman2bitvector2(String serialNum) throws SerialNumException {
        Logger log = Logger.getLogger(SerialNumChecker.class);
        String message = "";
        if (serialNum.length() != 29) {
            message = "Invalid format for serial number: The length of the serial number (" + serialNum.length() + " characters) is invalid. It should be " + 29;
            log.warn(message);
            log.debug(message);
            throw new SerialNumException(message);
        }
        if (serialNum.charAt(5) != '-') {
            message = "Invalid format for serial number: Character number 6 should be a dash.";
            log.warn(message);
            log.debug(message);
            throw new SerialNumException(message);
        }
        if (serialNum.charAt(11) != '-') {
            message = "Invalid format for serial number: Character number 11 should be a dash.";
            log.warn(message);
            log.debug(message);
            throw new SerialNumException(message);
        }
        if (serialNum.charAt(17) != '-') {
            message = "Invalid format for serial number: Character number 17 should be a dash.";
            log.warn(message);
            log.debug(message);
            throw new SerialNumException(message);
        }
        if (serialNum.charAt(23) != '-') {
            log.warn(message);
            log.debug(message);
            throw new SerialNumException(message);
        }
        return SerialNumChecker.serialString2bitvector(serialNum, serial_full2, 25);
    }

    private static BitVector serialString2bitvector(String serialNum, int[] pos, int nr) throws SerialNumException {
        Logger log = Logger.getLogger(SerialNumChecker.class);
        BitVector bv = new BitVector(5 * nr);
        for (int i = nr - 1; i >= 0; --i) {
            int off2 = serial_alphabet.indexOf(serialNum.charAt(pos[i]));
            if (off2 == -1) {
                String message = "Invalid format for serial number: the character number " + (pos[i] + 1) + " is invalid.";
                log.warn(message);
                log.debug(message);
                throw new SerialNumException(message);
            }
            int start = 5 * i;
            int nb = 5;
            for (int j = 0; j < nb; ++j) {
                bv = (off2 & 1) == 1 ? BitVectorHelper.bitVectorSet(bv, start + j) : BitVectorHelper.bitVectorClear(bv, start + j);
                off2 >>= 1;
            }
        }
        return bv;
    }

    private static BitVector serial_permute2(BitVector bv, boolean inverse) {
        int unit_pos = 80;
        int reserved_pos = 40;
        int hash_pos = 0;
        int blocksize = 21;
        BitVector bv2 = new BitVector(125);
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < blocksize; ++j) {
                boolean bit;
                if (inverse) {
                    bit = BitVectorHelper.bitVectorTest(bv, blocksize * i + j);
                    if (j % 3 == 0 || j == 20) {
                        bv2 = bit ? BitVectorHelper.bitVectorSet(bv2, hash_pos) : BitVectorHelper.bitVectorClear(bv2, hash_pos);
                        ++hash_pos;
                        continue;
                    }
                    if (j % 2 == 1 || j == 16) {
                        bv2 = bit ? BitVectorHelper.bitVectorSet(bv2, reserved_pos) : BitVectorHelper.bitVectorClear(bv2, reserved_pos);
                        ++reserved_pos;
                        continue;
                    }
                    bv2 = bit ? BitVectorHelper.bitVectorSet(bv2, unit_pos) : BitVectorHelper.bitVectorClear(bv2, unit_pos);
                    ++unit_pos;
                    continue;
                }
                if (j % 3 == 0 || j == 20) {
                    bit = BitVectorHelper.bitVectorTest(bv, hash_pos);
                    ++hash_pos;
                } else if (j % 2 == 1 || j == 16) {
                    bit = BitVectorHelper.bitVectorTest(bv, reserved_pos);
                    ++reserved_pos;
                } else {
                    bit = BitVectorHelper.bitVectorTest(bv, unit_pos);
                    ++unit_pos;
                }
                bv2 = bit ? BitVectorHelper.bitVectorSet(bv2, blocksize * i + j) : BitVectorHelper.bitVectorClear(bv2, blocksize * i + j);
            }
        }
        for (int k = 105; k < 125; ++k) {
            boolean bit = BitVectorHelper.bitVectorTest(bv, k);
            bv2 = bit ? BitVectorHelper.bitVectorSet(bv2, k) : BitVectorHelper.bitVectorClear(bv2, k);
        }
        return bv2;
    }

    private static SerialNumber serialDecode2(String serialNum, BitVector bv) {
        LicenseAttributes attr = new LicenseAttributes();
        attr.setSerial(serialNum);
        bv = SerialNumChecker.serial_permute2(bv, true);
        attr = SerialNumChecker.serialDecode2common(bv, attr);
        if (attr.getVersion() >= 6) {
            attr = SerialNumChecker.serialDecode2V6(bv, attr);
        }
        if (attr.getVersion() >= 8) {
            attr = SerialNumChecker.serialDecode2V8(bv, attr);
        }
        long hash = BitVectorHelper.getHashFromBitVector(bv, 0, 40);
        return new SerialNumber(serialNum, attr, hash, bv);
    }

    private static LicenseAttributes serialDecode2common(BitVector bv, LicenseAttributes attr) {
        int pos = 80;
        attr.setUnitId(BitVectorHelper.getValueFromBitVector(bv, pos, 25));
        attr.setVersion(BitVectorHelper.getValueFromBitVector(bv, pos += 25, 5));
        attr.setBatchId(BitVectorHelper.getValueFromBitVector(bv, pos += 5, 15));
        return attr;
    }

    private static LicenseAttributes serialDecode2V6(BitVector bv, LicenseAttributes attr) {
        int pos = 45;
        attr.setCount(BitVectorHelper.getValueFromBitVector(bv, pos, 16));
        attr.setSupport(BitVectorHelper.getValueFromBitVector(bv, pos += 16, 2));
        attr.setSubscription(BitVectorHelper.getValueFromBitVector(bv, pos += 2, 3));
        attr.setExpiration(BitVectorHelper.getValueFromBitVector(bv, pos += 3, 2));
        attr.setIssue(BitVectorHelper.getValueFromBitVector(bv, pos += 2, 12));
        return attr;
    }

    private static LicenseAttributes serialDecode2V8(BitVector bv, LicenseAttributes attr) {
        int pos = 40;
        boolean[] addons = new boolean[5];
        for (int i = 0; i < 5; ++i) {
            addons[i] = BitVectorHelper.getValueFromBitVector(bv, pos, 1) == 1;
            ++pos;
        }
        attr.setAddons(addons);
        return attr;
    }

    private static long serial_hash4(BitVector bv, String licenseHash) throws NoSuchAlgorithmException {
        byte[] secret = new byte[]{125, -57, -119, -7, 105, 93, 113, -112, -6, -124, 34, -54, -65, 29, -64, -64, -120, 66, 55, -43, 112, -128, 46, -125, -57, -110, -93, 89, -58, -107, 36, -65};
        return SerialNumChecker.serialHash(bv, 85, licenseHash, secret, secret.length);
    }

    private static long serialHash(BitVector bv, int size2, String data, byte[] secret, int secretSize) throws NoSuchAlgorithmException {
        byte[] value2 = new byte[20];
        size2 = (size2 + 8 - 1) / 8;
        for (int i = 0; i < size2; ++i) {
            value2[i] = (byte)BitVectorHelper.getValueFromBitVector(bv, 8 * i + 40, 8);
        }
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
        messageDigest.update(value2, 0, size2);
        messageDigest.update(data.getBytes(), 0, data.length());
        messageDigest.update(secret, 0, secretSize);
        byte[] result = messageDigest.digest();
        return SerialNumChecker.foldHash(result, 40);
    }

    public static long foldHash(byte[] hash, int len) {
        long h = 0L;
        long[] hash2 = new long[hash.length];
        for (int i = 0; i < hash.length; ++i) {
            hash2[i] = HashUtil.byteToInt(hash[i]);
        }
        if (len == 40) {
            h = hash2[0] ^ hash2[5] ^ hash2[10] ^ hash2[15] | (hash2[1] ^ hash2[6] ^ hash2[11] ^ hash2[16]) << 8 | (hash2[2] ^ hash2[7] ^ hash2[12] ^ hash2[17]) << 16 | (hash2[3] ^ hash2[8] ^ hash2[13] ^ hash2[18]) << 24 | (hash2[4] ^ hash2[9] ^ hash2[14] ^ hash2[19]) << 32;
        }
        return h;
    }

    public static void main(String[] args) throws SerialNumException {
        String serialNum = "44M1K-J0KAK-H8J0C-011H0-98KKH";
        long test = 247L;
        System.out.println(test << 32);
        String licenseHash = "8c32ab91-fb372347-dc3e5fc1-20c072f7-7ff8cd9e";
        SerialNumber serialObject = SerialNumChecker.serialDecode(serialNum);
        boolean valid = SerialNumChecker.checkValidDlfWithSN(serialObject, licenseHash);
        if (!valid) {
            System.out.println("INVALID!!!!");
        } else {
            LicenseAttributes licAttrs = new LicenseAttributes();
            licAttrs.addSerialAttributes(serialObject.getAtts());
            if (licAttrs != null) {
                System.out.println("YOUPI");
            }
        }
    }
}

