/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.licensecheck;

import com.vmware.licensecheck.DLFException;
import com.vmware.licensecheck.DLFPathFactory;
import com.vmware.licensecheck.DormantLicense;
import com.vmware.licensecheck.ExpirationDateHelper;
import com.vmware.licensecheck.IDLFFactory;
import com.vmware.licensecheck.ILicenseChecker;
import com.vmware.licensecheck.LicenseAttributes;
import com.vmware.licensecheck.LicenseAttributesFactory;
import com.vmware.licensecheck.SerialNumChecker;
import com.vmware.licensecheck.SerialNumException;
import com.vmware.licensecheck.SerialNumber;
import java.util.Calendar;
import java.util.Vector;

public class LicenseChecker
implements ILicenseChecker {
    @Override
    public LicenseAttributes checkSerial(String serialNum, IDLFFactory dlfFactory) throws DLFException, SerialNumException {
        if (!SerialNumChecker.checkSerialNumberSyntax(serialNum = SerialNumChecker.formatSerial(serialNum))) {
            throw new SerialNumException("Invalid Serial Number Format");
        }
        SerialNumber serialObject = SerialNumChecker.serialDecode(serialNum);
        Vector<DormantLicense> validDormantLicenses = dlfFactory.getDLFList();
        for (DormantLicense dormantLicense : validDormantLicenses) {
            LicenseAttributes licAttrs = LicenseAttributesFactory.createLicenseAttributes(dormantLicense);
            boolean isSerialMatching = SerialNumChecker.checkValidDlfWithSN(serialObject, dormantLicense.getHash());
            if (!isSerialMatching) continue;
            licAttrs.addSerialAttributes(serialObject.getAtts());
            Calendar expirationDate = licAttrs.getExpirationDate();
            if (ExpirationDateHelper.hasExpired(expirationDate)) {
                throw new DLFException(4L, licAttrs);
            }
            return licAttrs;
        }
        throw new SerialNumException("Invalid serial number: no dormant license file corresponding to the serial number");
    }

    @Override
    public synchronized LicenseAttributes checkSerial(String serialNum, String productVersion, String productName, String dormantPath) throws DLFException, SerialNumException {
        DLFPathFactory dlfFactory = new DLFPathFactory(dormantPath, productVersion, productName);
        return this.checkSerial(serialNum, dlfFactory);
    }
}

