/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.licensecheck;

import com.springsource.vfabric.licensing.log.Logger;
import com.vmware.licensecheck.DLFConstants;
import com.vmware.licensecheck.DLFException;
import com.vmware.licensecheck.DormantLicense;
import com.vmware.licensecheck.HashUtil;
import java.io.UnsupportedEncodingException;
import java.security.NoSuchAlgorithmException;

public class LicenseCheckHelper {
    public static void validateLicense(DormantLicense dormantLicense) throws DLFException {
        String data;
        String dlf_hash_field = dormantLicense.getHash();
        if (dlf_hash_field == null) {
            throw new DLFException(2L, "Corrupted Dormant License File");
        }
        String dlf_parsed = dormantLicense.parseLicense();
        if (!LicenseCheckHelper.hashCompare(dlf_parsed, dormantLicense.getEncoding(), dlf_hash_field)) {
            throw new DLFException(2L, "Corrupted Dormant License File");
        }
        int dlf_option = DLFConstants.LICENSECHECK_OPTION_NONE;
        String option = dormantLicense.getOption();
        if (option != null) {
            dlf_option = Integer.parseInt(option);
        }
        if ((data = dormantLicense.getData()) != null) {
            String dataHash = dormantLicense.getDataHash();
            if (dataHash == null) {
                throw new DLFException(2L, "Corrupted Dormant License File");
            }
            data = data + ":";
            if (!LicenseCheckHelper.hashCompare(data = data + dormantLicense.getHash(), dormantLicense.getEncoding(), dataHash)) {
                throw new DLFException(2L, "Corrupted Dormant License File");
            }
        } else if ((dlf_option & DLFConstants.LICENSECHECK_OPTION_KVPAIR) != 0) {
            throw new DLFException(2L, "Corrupted Dormant License File");
        }
    }

    public static boolean hashCompare(String data, String encoding, String expectedHash) {
        byte[] dlf_hash;
        Logger log = Logger.getLogger(LicenseCheckHelper.class);
        try {
            dlf_hash = HashUtil.hash(data, encoding, DormantLicense.getSecret());
        }
        catch (NoSuchAlgorithmException e) {
            log.warn(e.getMessage());
            log.debug(e.getMessage(), e);
            return false;
        }
        catch (UnsupportedEncodingException e) {
            log.warn(e.getMessage());
            log.debug(e.getMessage(), e);
            return false;
        }
        String dlf_strHashed = HashUtil.hashToFormatedString(dlf_hash);
        return expectedHash.equals(dlf_strHashed);
    }
}

