/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.licensecheck;

import com.vmware.licensecheck.DLFException;
import com.vmware.licensecheck.DormantLicense;
import com.vmware.licensecheck.LicenseAttributes;
import java.util.HashMap;

public class LicenseAttributesFactory {
    public static LicenseAttributes createLicenseAttributes(DormantLicense dormantLicense) throws DLFException {
        LicenseAttributes licAttr = new LicenseAttributes();
        licAttr.setHash(dormantLicense.getHash());
        licAttr.setData(dormantLicense.getData());
        licAttr.setDataHash(dormantLicense.getDataHash());
        licAttr.setEpoch(dormantLicense.getEpoch());
        if (dormantLicense.getData() != null) {
            licAttr.setExtendedAttributes(LicenseAttributesFactory.createExtendedAttributes(dormantLicense.getData()));
        }
        licAttr.setLicenseEdition(dormantLicense.getLicenseEdition());
        licAttr.setLicenseType(dormantLicense.getLicenseType());
        licAttr.setProductName(dormantLicense.getProductId());
        licAttr.setLicenseVersion(dormantLicense.getLicenseVersion());
        licAttr.setPath(dormantLicense.getPath());
        return licAttr;
    }

    private static HashMap<String, String> createExtendedAttributes(String data) throws DLFException {
        HashMap<String, String> options = new HashMap<String, String>();
        if (data == null) {
            throw new DLFException(5L, "Cannot read Extended Attributes from Dormant License File");
        }
        String[] arrayExtendedAttributes = data.split(";");
        for (int i = 0; i < arrayExtendedAttributes.length; ++i) {
            String[] arrayOption = arrayExtendedAttributes[i].split("=");
            if (arrayOption == null || arrayOption.length != 2) {
                throw new DLFException(5L, "Cannot read options from Dormant License File");
            }
            options.put(arrayOption[0], arrayOption[1]);
        }
        return options;
    }
}

