/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.licensecheck;

import com.vmware.licensecheck.DLFException;
import java.util.Properties;
import java.util.Vector;

public class DormantLicense {
    private String encoding;
    private Properties licenseProps;

    public DormantLicense(Properties licenseProps, String encoding) throws DLFException {
        if (licenseProps == null) {
            throw new DLFException(5L, "Cannot create Dormant License from null Properties object");
        }
        this.licenseProps = licenseProps;
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Properties getLicenseProps() {
        return this.licenseProps;
    }

    public String getStartFields() {
        return this.licenseProps.getProperty("StartFields");
    }

    public String getCpt() {
        return this.licenseProps.getProperty("Cpt");
    }

    public String getProductId() {
        return this.licenseProps.getProperty("ProductID");
    }

    public String getLicenseVersion() {
        return this.licenseProps.getProperty("LicenseVersion");
    }

    public String getLicenseType() {
        return this.licenseProps.getProperty("LicenseType");
    }

    public String getEpoch() {
        return this.licenseProps.getProperty("Epoch");
    }

    public String getLicenseEdition() {
        return this.licenseProps.getProperty("LicenseEdition");
    }

    public String getOption() {
        return this.licenseProps.getProperty("Option");
    }

    public String getData() {
        return this.licenseProps.getProperty("Data");
    }

    public String getDataHash() {
        return this.licenseProps.getProperty("DataHash");
    }

    public String getHash() {
        return this.licenseProps.getProperty("Hash");
    }

    public String getPath() {
        return this.licenseProps.getProperty("_path");
    }

    public static byte[] getSecret() {
        int i;
        byte[] secret = new byte[13];
        secret[0] = 42;
        for (i = 1; i < secret.length; ++i) {
            secret[i] = (byte)(212 + secret[i - 1] * 11 & 0xFF);
        }
        secret[0] = (byte)(secret[0] + 83);
        for (i = 2; i < secret.length; ++i) {
            secret[i] = (byte)(39 + secret[i - 2] + secret[i - 1] * 7 & 0xFF);
        }
        secret[0] = (byte)(secret[0] + secret[5]);
        secret[1] = (byte)(secret[1] + secret[12]);
        for (i = 3; i < secret.length; ++i) {
            secret[i] = (byte)(149 + secret[i - 3] + 8 * secret[i - 2] + secret[i - 1] * 19 & 0xFF);
        }
        return secret;
    }

    public String parseLicense() throws DLFException {
        Vector<String> arrayStartFields = new Vector<String>();
        this.addFields(arrayStartFields, this.getHashFields("StartFields"));
        String output = "";
        for (int i = 0; i < arrayStartFields.size(); ++i) {
            String key2 = arrayStartFields.elementAt(i);
            output = output + this.licenseProps.getProperty(key2) + ":";
        }
        output = output.substring(0, output.length() - 1);
        return output;
    }

    private void addFields(Vector<String> fields, String[] input) throws DLFException {
        for (int i = 0; i < input.length; ++i) {
            String key2 = input[i];
            if (key2.matches("Field[\\d]")) {
                this.addFields(fields, this.getHashFields(key2));
                continue;
            }
            fields.add(key2);
        }
    }

    private String[] getHashFields(String name) throws DLFException {
        String value2 = (String)this.licenseProps.get(name);
        if (value2 == null) {
            throw new DLFException(2L, "Corrupted Dormant License File");
        }
        value2 = value2.replace(" ", "");
        return value2.split(",");
    }
}

