/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.licensecheck;

import com.springsource.vfabric.licensing.log.Logger;
import com.vmware.licensecheck.DLFAbstractFactory;
import com.vmware.licensecheck.DLFException;
import com.vmware.licensecheck.DLFReader;
import com.vmware.licensecheck.DormantLicense;
import com.vmware.licensecheck.IDLFFactory;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;

public class DLFFileFactory
extends DLFAbstractFactory
implements IDLFFactory {
    private Logger log = Logger.getLogger(this.getClass());
    private DLFReader dlfReader;
    private String dlfPath;

    public DLFFileFactory(String dlfPath) {
        this.dlfPath = dlfPath;
        this.dlfReader = new DLFReader();
        this.encoding = "UTF-8";
    }

    @Override
    public Vector<DormantLicense> getDLFList() throws DLFException {
        File f = new File(this.dlfPath);
        if (!f.exists()) {
            this.log.warn("Cannot find " + this.dlfPath);
            this.log.debug("Cannot find " + this.dlfPath);
            throw new DLFException(1L, "Cannot find " + this.dlfPath);
        }
        Vector<DormantLicense> validDLFs = new Vector<DormantLicense>();
        if (f.isDirectory()) {
            Vector<Properties> listDlfProps = this.dlfReader.loadDormantLicenseFiles(this.dlfPath);
            if (listDlfProps == null || listDlfProps.size() < 1) {
                this.log.warn("No Valid License available in dir " + this.dlfPath);
                this.log.debug("No Valid License available in dir " + this.dlfPath);
                throw new DLFException(3L, "No Valid License available in dir " + this.dlfPath);
            }
            this.addLicense(validDLFs, listDlfProps);
        } else if (f.isFile()) {
            Properties dlfProps;
            try {
                dlfProps = this.dlfReader.loadDormantLicenseFile(this.dlfPath);
            }
            catch (IOException e) {
                this.log.warn(e.getMessage());
                this.log.debug(e.getMessage(), e);
                throw new DLFException(e);
            }
            this.addLicense(validDLFs, dlfProps);
        }
        return validDLFs;
    }
}

