/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.licensecheck;

import com.springsource.vfabric.licensing.log.Logger;
import com.vmware.licensecheck.DLFException;
import com.vmware.licensecheck.DormantLicense;
import com.vmware.licensecheck.LicenseCheckHelper;
import java.util.Properties;
import java.util.Vector;

public abstract class DLFAbstractFactory {
    protected String encoding;
    protected String productVersion;
    protected String productName;
    private Logger log = Logger.getLogger(this.getClass());

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public void setProductVersion(String productVersion) {
        this.productVersion = productVersion;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    protected boolean matchFilters(DormantLicense dormantLicense) throws DLFException {
        if (this.productVersion != null && !this.productVersion.equals(dormantLicense.getLicenseVersion())) {
            return false;
        }
        if (this.productName != null && !this.productName.equals(dormantLicense.getProductId())) {
            return false;
        }
        LicenseCheckHelper.validateLicense(dormantLicense);
        return true;
    }

    protected void addLicense(Vector<DormantLicense> validDLFs, Properties properties) throws DLFException {
        DormantLicense dormantLicense = new DormantLicense(properties, this.encoding);
        if (this.matchFilters(dormantLicense)) {
            validDLFs.add(dormantLicense);
        }
    }

    protected void addLicense(Vector<DormantLicense> validDLFs, Vector<Properties> listDlfProps) throws DLFException {
        if (listDlfProps != null && listDlfProps.size() > 0) {
            for (Properties properties : listDlfProps) {
                try {
                    this.addLicense(validDLFs, properties);
                }
                catch (DLFException e) {
                    this.log.warn("DLF corrupted: " + properties.getProperty("_path"));
                }
            }
        }
    }
}

