/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.state;

import com.springsource.vfabric.licensing.state.LicenseStateException;
import com.springsource.vfabric.licensing.state.StateUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ServerLicenseState {
    private final String componentId;
    private final Date timestamp;
    private final Collection<License> licenses;
    private static int MESSAGE_VERSION = 1;
    private static final Pattern UNIQUE_KEY_PATTERN = Pattern.compile("license\\.([0-9]*)\\.uniqueKey");

    public ServerLicenseState(String componentId, Date timestamp, Collection<License> licenses) {
        if (componentId == null || componentId.length() == 0 || timestamp == null || licenses == null) {
            throw new IllegalArgumentException("Need all arguments for ServerLicenseState");
        }
        this.componentId = componentId;
        this.timestamp = timestamp;
        this.licenses = licenses;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Collection<License> getLicenses() {
        return this.licenses;
    }

    public String serialize() throws LicenseStateException {
        Properties props = new Properties();
        props.put("componentId", this.componentId);
        props.put("timestamp", String.valueOf(this.timestamp.getTime()));
        props.put("version", Integer.toString(MESSAGE_VERSION));
        int index2 = 0;
        for (License license : this.licenses) {
            String prefix = "license." + index2;
            props.put(prefix + ".uniqueKey", license.uniqueKey);
            props.put(prefix + ".totalAvailable", Integer.toString(license.totalAvailable));
            props.put(prefix + ".totalUsed", Integer.toString(license.totalUsed));
            props.put(prefix + ".enforcement", license.getEnforcement());
            if (license.getExpirationDate() != null) {
                props.put(prefix + ".expirationDate", Long.toString(license.getExpirationDate().getTime()));
            }
            if (license.addonFeatures != null && license.addonFeatures.size() > 0) {
                Iterator it = license.addonFeatures.iterator();
                StringBuilder addonString = new StringBuilder((String)it.next());
                while (it.hasNext()) {
                    addonString.append(',').append((String)it.next());
                }
                props.put(prefix + ".addon", addonString.toString());
            }
            if (license.extendedParameters != null) {
                for (Map.Entry<Object, Object> entry : license.extendedParameters.entrySet()) {
                    props.put(prefix + ".extended." + entry.getKey(), entry.getValue());
                }
            }
            ++index2;
        }
        StateUtils.addChecksum(props);
        try {
            ByteArrayOutputStream writer = new ByteArrayOutputStream();
            props.store(writer, "LicenseState");
            byte[] charData = writer.toByteArray();
            return new String(charData, "UTF-8");
        }
        catch (IOException e) {
            throw new LicenseStateException("Could not write licenseState: " + e.getMessage());
        }
    }

    public static ServerLicenseState deserialize(String saved) throws LicenseStateException {
        Properties props = new Properties();
        try {
            ByteArrayInputStream reader = new ByteArrayInputStream(saved.getBytes());
            props.load(reader);
        }
        catch (IOException e) {
            throw new LicenseStateException("Could not read LicenseState: " + e.getMessage());
        }
        if (!StateUtils.validateChecksum(props)) {
            throw new LicenseStateException("Bad checksum on ServerLicenseState!");
        }
        int version = StateUtils.getIntOrThrow("version", props);
        if (version > MESSAGE_VERSION) {
            throw new LicenseStateException("Don't know how to read ServerLicenseState message version " + version + ". Incompatible client/license server. " + "Message version must be " + MESSAGE_VERSION + " or lower");
        }
        String componentId = StateUtils.getOrThrow("componentId", props);
        Date timestamp = StateUtils.getDateOrThrow("timestamp", props);
        LinkedList<String> indices = new LinkedList<String>();
        Enumeration<?> names = props.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Matcher m = UNIQUE_KEY_PATTERN.matcher(name);
            if (!m.matches()) continue;
            indices.add(m.group(1));
        }
        LinkedList<License> licenses = new LinkedList<License>();
        for (String index2 : indices) {
            String prefix = "license." + index2;
            String uniqueKey = StateUtils.getOrThrow(prefix + ".uniqueKey", props);
            int available = StateUtils.getIntOrThrow(prefix + ".totalAvailable", props);
            int used = StateUtils.getIntOrThrow(prefix + ".totalUsed", props);
            String enforcement = StateUtils.getOrThrow(prefix + ".enforcement", props);
            Date expiration = StateUtils.getDateOrNull(prefix + ".expirationDate", props);
            String addonString = props.getProperty(prefix + ".addon");
            List<String> addons = null;
            if (addonString != null) {
                addons = Arrays.asList(addonString.split(","));
            }
            Properties extended = new Properties();
            Pattern pattern = Pattern.compile(prefix + ".extended\\.(.*)");
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                String name = (String)entry.getKey();
                Matcher m = pattern.matcher(name);
                if (!m.matches()) continue;
                extended.setProperty(m.group(1), (String)entry.getValue());
            }
            licenses.add(new License(uniqueKey, available, used, expiration, enforcement, addons, extended));
        }
        return new ServerLicenseState(componentId, timestamp, licenses);
    }

    public static class License {
        private final String uniqueKey;
        private final int totalAvailable;
        private final int totalUsed;
        private final Date expirationDate;
        private final String enforcement;
        private final Collection<String> addonFeatures;
        private final Properties extendedParameters;

        public License(String uniqueKey, int totalAvailable, int totalUsed, Date expirationDate, String enforcement, Collection<String> addonFeatures, Properties extendedParameters) {
            if (uniqueKey == null || enforcement == null) {
                throw new IllegalArgumentException("Need all arguments for ServerLicenseState.License");
            }
            this.uniqueKey = uniqueKey;
            this.totalAvailable = totalAvailable;
            this.totalUsed = totalUsed;
            this.expirationDate = expirationDate;
            this.enforcement = enforcement;
            this.addonFeatures = addonFeatures == null ? new ArrayList() : addonFeatures;
            this.extendedParameters = extendedParameters == null ? new Properties() : extendedParameters;
        }

        public String getUniqueKey() {
            return this.uniqueKey;
        }

        public int getTotalAvailable() {
            return this.totalAvailable;
        }

        public int getTotalUsed() {
            return this.totalUsed;
        }

        public Date getExpirationDate() {
            return this.expirationDate;
        }

        public String getEnforcement() {
            return this.enforcement;
        }

        public Collection<String> getAddonFeatures() {
            return this.addonFeatures;
        }

        public Properties getExtendedParameters() {
            return this.extendedParameters;
        }
    }
}

