/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.state;

import com.springsource.vfabric.licensing.state.LicenseStateException;
import com.springsource.vfabric.licensing.state.StateUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LicenseState {
    final String componentId;
    final Date timestamp;
    final String licenseType;
    final int totalAvailable;
    final int totalUsed;
    final Date expirationDate;
    final Set<String> addonFeatures;
    final String enforcement;
    final Properties extendedParameters;
    public static final String LICENSE_TYPE_SERVER = "server";
    public static final String LICENSE_TYPE_LOCAL = "local";
    public static final String LICENSE_TYPE_DEFAULT = "default";
    public static final String LICENSE_ENFORCEMENT_SOFT = "soft";
    public static final String LICENSE_ENFORCEMENT_HARD = "hard";

    public LicenseState(String componentId, Date timestamp, String licenseType, int totalAvailable, int totalUsed, Date expirationDate, String enforcement, Set<String> addonFeatures, Properties extendedParameters) {
        assert (componentId != null && componentId.length() > 0);
        assert (timestamp != null);
        this.componentId = componentId;
        this.timestamp = timestamp;
        this.licenseType = licenseType;
        this.totalAvailable = totalAvailable;
        this.totalUsed = totalUsed;
        this.expirationDate = expirationDate;
        this.addonFeatures = addonFeatures;
        this.enforcement = enforcement;
        this.extendedParameters = extendedParameters;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public int getTotalAvailable() {
        return this.totalAvailable;
    }

    public int getTotalUsed() {
        return this.totalUsed;
    }

    public String getLicenseType() {
        return this.licenseType;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public String serialize() throws LicenseStateException {
        Properties props = new Properties();
        props.put("id", this.componentId);
        props.put("type", this.licenseType);
        props.put("timestamp", String.valueOf(this.timestamp.getTime()));
        props.put("total", String.valueOf(this.totalAvailable));
        props.put("used", String.valueOf(this.totalUsed));
        if (this.expirationDate != null) {
            props.put("expiration", String.valueOf(this.expirationDate.getTime()));
        }
        props.put("enforce", this.enforcement);
        if (this.addonFeatures != null && this.addonFeatures.size() > 0) {
            Iterator<String> it = this.addonFeatures.iterator();
            StringBuilder addonString = new StringBuilder(it.next());
            while (it.hasNext()) {
                addonString.append(',').append(it.next());
            }
            props.put("addon", addonString.toString());
        }
        if (this.extendedParameters != null) {
            for (Map.Entry<Object, Object> entry : this.extendedParameters.entrySet()) {
                props.put("extended." + entry.getKey(), entry.getValue());
            }
        }
        try {
            ByteArrayOutputStream writer = new ByteArrayOutputStream();
            props.store(writer, "LicenseState");
            byte[] charData = writer.toByteArray();
            return new String(charData, "UTF-8");
        }
        catch (IOException e) {
            throw new LicenseStateException("Could not write licenseState: " + e.getMessage());
        }
    }

    public static LicenseState deserialize(String saved) throws LicenseStateException {
        Properties props = new Properties();
        try {
            ByteArrayInputStream reader = new ByteArrayInputStream(saved.getBytes());
            props.load(reader);
        }
        catch (IOException e) {
            throw new LicenseStateException("Could not read LicenseState: " + e.getMessage());
        }
        String componentId = StateUtils.getOrThrow("id", props);
        String licenseType = StateUtils.getOrThrow("type", props);
        Date timestamp = StateUtils.getDateOrThrow("timestamp", props);
        Date expiration = StateUtils.getDateOrNull("expiration", props);
        int total = StateUtils.getIntOrThrow("total", props);
        int used = StateUtils.getIntOrThrow("used", props);
        String enforce = StateUtils.getOrThrow("enforce", props);
        String addonString = props.getProperty("addon");
        HashSet<String> addons = new HashSet<String>();
        if (addonString != null) {
            addons.addAll(Arrays.asList(addonString.split(",")));
        }
        Properties extended = new Properties();
        Pattern pattern = Pattern.compile("extended\\.(.*)");
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String name = (String)entry.getKey();
            Matcher m = pattern.matcher(name);
            if (!m.matches()) continue;
            extended.setProperty(m.group(1), (String)entry.getValue());
        }
        return new LicenseState(componentId, timestamp, licenseType, total, used, expiration, enforce, addons, extended);
    }

    public Set<String> getAddonFeatures() {
        return this.addonFeatures;
    }

    public String getEnforcement() {
        return this.enforcement;
    }

    public Properties getExtendedParameters() {
        return this.extendedParameters;
    }

    public boolean equals(Object otherObject) {
        if (otherObject == null || !(otherObject instanceof LicenseState)) {
            return false;
        }
        LicenseState other = (LicenseState)otherObject;
        try {
            return this.serialize().equals(other.serialize());
        }
        catch (LicenseStateException e) {
            return false;
        }
    }

    public int hashCode() {
        try {
            return this.serialize().hashCode();
        }
        catch (LicenseStateException e) {
            return this.totalAvailable;
        }
    }
}

