/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.state;

import com.springsource.vfabric.licensing.state.InstanceState;
import com.springsource.vfabric.licensing.state.LicenseStateException;
import com.springsource.vfabric.licensing.state.StateUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ComponentUsage {
    private final String componentId;
    private final String componentVersion;
    private Date timestamp;
    private final Collection<InstanceState> instanceStates;
    private final String sourceIpAddress;
    private final int numCpus;
    private static int MESSAGE_VERSION = 1;

    public ComponentUsage(String componentId, String componentVersion, Date timestamp, Collection<InstanceState> instanceStates) {
        this(componentId, componentVersion, timestamp, instanceStates, "", -1);
    }

    public ComponentUsage(String componentId, String componentVersion, Date timestamp, Collection<InstanceState> instanceStates, String sourceIp, int numCpus) {
        this.componentId = componentId;
        this.componentVersion = componentVersion;
        this.timestamp = timestamp;
        this.instanceStates = instanceStates;
        this.sourceIpAddress = sourceIp;
        this.numCpus = numCpus;
    }

    public String getComponentId() {
        return this.componentId;
    }

    public String getComponentVersion() {
        return this.componentVersion;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Collection<InstanceState> getInstanceStates() {
        return this.instanceStates;
    }

    public String toString() {
        try {
            return this.serialize();
        }
        catch (LicenseStateException e) {
            return "ComponentUsage serialization failed for " + this.componentId + ": " + e;
        }
    }

    public String getSourceIpAddress() {
        return this.sourceIpAddress;
    }

    public int getNumCpus() {
        return this.numCpus;
    }

    public String serialize() throws LicenseStateException {
        Properties props = new Properties();
        props.put("componentId", this.componentId);
        props.put("componentVersion", this.componentVersion);
        props.put("timestamp", String.valueOf(this.timestamp.getTime()));
        props.put("sourceIp", this.sourceIpAddress);
        props.put("numCpus", Integer.toString(this.numCpus));
        props.put("version", Integer.toString(MESSAGE_VERSION));
        int count = 0;
        for (InstanceState instanceState : this.instanceStates) {
            String prefix = "instance." + count + ".";
            props.put(prefix + "state", instanceState.getComponentState());
            props.put(prefix + "id", instanceState.getIdentifier());
            props.put(prefix + "type", instanceState.getIdentifierType());
            props.put(prefix + "timestamp", String.valueOf(instanceState.getTimestamp().getTime()));
            ++count;
        }
        StateUtils.addChecksum(props);
        try {
            ByteArrayOutputStream writer = new ByteArrayOutputStream();
            props.store(writer, "ComponentUsage");
            byte[] charData = writer.toByteArray();
            return new String(charData, "UTF-8");
        }
        catch (IOException e) {
            throw new LicenseStateException("Could not write componentUsage: " + e.getMessage());
        }
    }

    public static ComponentUsage deserialize(String saved) throws LicenseStateException {
        Properties props = new Properties();
        try {
            ByteArrayInputStream reader = new ByteArrayInputStream(saved.getBytes());
            props.load(reader);
        }
        catch (IOException e) {
            throw new LicenseStateException("Could not read componentUsage: " + e.getMessage());
        }
        if (!StateUtils.validateChecksum(props)) {
            throw new LicenseStateException("Bad checksum on ComponentUsage!");
        }
        int version = StateUtils.getIntOrThrow("version", props);
        if (version > MESSAGE_VERSION) {
            throw new LicenseStateException("Don't know how to read ComponentUsage message version " + version + ". Incompatible client/license server. " + "Message version must be " + MESSAGE_VERSION + " or lower");
        }
        String componentId = StateUtils.getOrThrow("componentId", props);
        String componentVersion = StateUtils.getOrThrow("componentVersion", props);
        Date timestamp = StateUtils.getDateOrThrow("timestamp", props);
        int numCpus = StateUtils.getIntOrThrow("numCpus", props);
        String sourceIp = StateUtils.getOrThrow("sourceIp", props);
        LinkedList<String> counts = new LinkedList<String>();
        Enumeration<?> names = props.propertyNames();
        Pattern pattern = Pattern.compile("instance\\.([0-9]*)\\.id");
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Matcher m = pattern.matcher(name);
            if (!m.matches()) continue;
            counts.add(m.group(1));
        }
        LinkedList<InstanceState> states2 = new LinkedList<InstanceState>();
        for (String count : counts) {
            String prefix = "instance." + count + ".";
            String id = StateUtils.getOrThrow(prefix + "id", props);
            String type = StateUtils.getOrThrow(prefix + "type", props);
            String state = StateUtils.getOrThrow(prefix + "state", props);
            Date instanceTime = StateUtils.getDateOrThrow(prefix + "timestamp", props);
            states2.add(new InstanceState(id, type, state, instanceTime));
        }
        return new ComponentUsage(componentId, componentVersion, timestamp, states2, sourceIp, numCpus);
    }

    public void setTimestamp(Date date) {
        this.timestamp = date;
    }
}

