/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.log;

import com.springsource.vfabric.licensing.log.Logger;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

class SimpleConsoleLogger
extends Logger {
    private final String name;
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("[yyyy-MM-dd'T'HH:mm:ss]");

    public SimpleConsoleLogger(Class<?> c) {
        this.name = c.getName();
    }

    @Override
    public void debug(Object ... message) {
        System.out.println(this.formatMessage(message, "DEBUG"));
    }

    @Override
    public void info(Object ... message) {
        System.out.println(this.formatMessage(message, "INFO"));
    }

    @Override
    public void warn(Object ... message) {
        System.out.println(this.formatMessage(message, "WARN"));
    }

    @Override
    public void error(Object ... message) {
        System.err.println(this.formatMessage(message, "ERROR"));
    }

    private String formatMessage(Object[] messages, String level) {
        StringBuilder builder = new StringBuilder();
        builder.append(DATE_FORMAT.format(new Date())).append(' ').append(level).append(' ').append(this.name).append(' ').append(Thread.currentThread().toString());
        for (Object message : messages) {
            builder.append(" | ").append(message.toString());
        }
        return builder.toString();
    }
}

