/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.events;

import com.springsource.vfabric.licensing.client.ActivatedLicense;
import com.springsource.vfabric.licensing.client.AllowedComponentVersion;
import com.springsource.vfabric.licensing.events.Event;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;

public class LicenseActivatedEvent
extends Event {
    ActivatedLicense license;

    public LicenseActivatedEvent(ActivatedLicense license) {
        super(Event.EventSeverity.INFO);
        this.license = license;
    }

    @Override
    protected Properties getArguments() {
        String expirationDate = "";
        if (this.license.isPerpetual()) {
            expirationDate = "never";
        } else if (this.license.isExpiringOnASetDate()) {
            expirationDate = this.FORMAT_8601.format(this.license.getExpirationDate().getTime());
        } else if (this.license.isFloatingEval()) {
            Calendar expiration = this.license.getExpirationDate();
            expirationDate = expiration == null ? "unset" : this.FORMAT_8601.format(expiration.getTime());
        }
        Set<AllowedComponentVersion> allowed = this.license.getAllowedComponentVersions();
        Iterator<AllowedComponentVersion> it = allowed.iterator();
        StringWriter allowedStr = new StringWriter();
        while (it.hasNext()) {
            AllowedComponentVersion acv = it.next();
            allowedStr.append(acv.getComponentId()).append('-');
            int[] ver = acv.getVersion();
            for (int i = 0; i < ver.length; ++i) {
                allowedStr.append(Integer.toString(ver[i]));
                if (i == ver.length - 1) continue;
                allowedStr.append('.');
            }
            if (!it.hasNext()) continue;
            allowedStr.append('+');
        }
        return LicenseActivatedEvent.makeProperties("serialNumber", this.license.getSerialNumber(), "available", Integer.toString(this.license.getCount()), "expirationType", this.license.getPrettyExpirationType(), "expirationDate", expirationDate, "allowedVersions", allowedStr.toString());
    }
}

