/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.events;

import com.springsource.vfabric.licensing.events.Event;
import com.springsource.vfabric.licensing.state.ServerLicenseState;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;

public class ConsumeServerLicenseEvent
extends Event {
    private final ServerLicenseState.License license;

    public ConsumeServerLicenseEvent(ServerLicenseState.License serverLicense) {
        super(Event.EventSeverity.INFO);
        this.license = serverLicense;
    }

    @Override
    protected Properties getArguments() {
        Date expirationDate = this.license.getExpirationDate();
        String expirationString = expirationDate == null ? "permanent" : this.FORMAT_8601.format(expirationDate.getTime());
        Collection<String> addons = this.license.getAddonFeatures();
        StringWriter addonStr = new StringWriter();
        if (addons != null && addons.size() != 0) {
            Iterator<String> addonsIt = addons.iterator();
            while (addonsIt.hasNext()) {
                addonStr.append(addonsIt.next());
                if (!addonsIt.hasNext()) continue;
                addonStr.append('+');
            }
        } else {
            addonStr.append("<empty>");
        }
        return ConsumeServerLicenseEvent.makeProperties("available", Integer.toString(this.license.getTotalAvailable()), "used", Integer.toString(this.license.getTotalUsed()), "expirationDate", expirationString, "enforcement", this.license.getEnforcement(), "addons", addonStr.toString());
    }
}

