/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.client;

import com.springsource.vfabric.licensing.client.ClassLoaderResource;
import com.springsource.vfabric.licensing.client.CpuInfo;
import com.springsource.vfabric.licensing.client.LocalLicenseConfigurationException;
import com.springsource.vfabric.licensing.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.util.Scanner;

public class WindowsCpuInfo
implements CpuInfo {
    private int[] coreCounts;
    private static final Logger LOG = Logger.getLogger(WindowsCpuInfo.class);

    public WindowsCpuInfo() {
        File logFile;
        LOG.info("Checking 64 bit cpu info...");
        Process process = null;
        try {
            logFile = File.createTempFile("cpuinfo", ".log");
            logFile.deleteOnExit();
        }
        catch (IOException e) {
            LOG.warn("Failed to create logfile for cpuinfo tool, using default count [1]" + e.getMessage());
            this.coreCounts = new int[]{1};
            return;
        }
        try {
            process = this.runFromResource("cpuinfo-tool.exe.x64", new String[]{"--logfile", logFile.getAbsolutePath()});
            process.waitFor();
            LOG.info("64 bit cpuinfo succeeded");
        }
        catch (IOException e) {
            LOG.info("Failed to launch 64 bit binary: " + e + "... trying 32 bit cpu info...");
        }
        catch (InterruptedException e) {
            LOG.error("Wait was interruped!!");
        }
        if (process == null) {
            try {
                process = this.runFromResource("cpuinfo-tool.exe.x86", new String[]{"--logfile", logFile.getAbsolutePath()});
                process.waitFor();
                LOG.info("32 bit cpuinfo succeeded");
            }
            catch (IOException e) {
                LOG.info("Failed to launch 32 bit binary: " + e);
            }
            catch (InterruptedException e) {
                LOG.error("Wait was interruped!!");
            }
        }
        if (process == null) {
            LOG.error("Failed to launch either version of cpuinfo");
            this.coreCounts = new int[]{1};
            return;
        }
        if (process.exitValue() != 0) {
            Scanner errScan = new Scanner(process.getErrorStream());
            StringWriter errString = new StringWriter();
            while (errScan.hasNextLine()) {
                errString.write(errScan.nextLine());
                errString.write(10);
            }
            LOG.error("cpuinfo returned a non-zero exit code, exitCode = " + process.exitValue() + ": " + errString.toString());
            this.coreCounts = new int[]{1};
        } else {
            Scanner scanner = new Scanner(process.getInputStream());
            String output = scanner.nextLine();
            String clean = output.replaceAll("[\\[\\]\\s]", "");
            String[] elems = clean.split(",");
            this.coreCounts = new int[elems.length];
            for (int i = 0; i < elems.length; ++i) {
                try {
                    this.coreCounts[i] = Integer.parseInt(elems[i]);
                    continue;
                }
                catch (NumberFormatException e) {
                    LOG.error("Failed to parse numbers from cpuinfo, error = " + e);
                    this.coreCounts[i] = 1;
                }
            }
        }
        this.saveToLogAndDelete(logFile);
    }

    @Override
    public int[] getCoreCounts() {
        return this.coreCounts;
    }

    private Process runFromResource(String resourceName, String[] args) throws IOException {
        int numRead;
        InputStream in = null;
        try {
            ClassLoaderResource resource = new ClassLoaderResource(this.getClass(), resourceName);
            in = resource.getStream();
        }
        catch (LocalLicenseConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        File binary = File.createTempFile("vfabric-cpuinfo", ".tmp");
        binary.deleteOnExit();
        FileOutputStream out = new FileOutputStream(binary);
        byte[] buf = new byte[4096];
        while ((numRead = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, numRead);
        }
        in.close();
        ((OutputStream)out).close();
        String[] execArgs = new String[1 + args.length];
        execArgs[0] = binary.getAbsolutePath();
        for (int i = 0; i < args.length; ++i) {
            execArgs[i + 1] = args[i];
        }
        return Runtime.getRuntime().exec(execArgs);
    }

    private void saveToLogAndDelete(File logFile) {
        try {
            Scanner s = new Scanner(new FileInputStream(logFile));
            while (s.hasNextLine()) {
                LOG.info(s.nextLine());
            }
            s.close();
            logFile.delete();
        }
        catch (FileNotFoundException e) {
            LOG.warn("Failed to read log from cpuinfo tool" + e.getMessage());
            return;
        }
    }
}

