/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.client;

import com.springsource.vfabric.licensing.client.LocalLicenseConfigurationException;
import com.springsource.vfabric.licensing.log.Logger;
import com.springsource.vfabric.licensing.util.SerialNumberUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class SerialNumberReader {
    private static final Logger LOG = Logger.getLogger(SerialNumberReader.class);
    private List<String> serialNumbers;

    public SerialNumberReader(Collection<String> serialNumbers) {
        this.serialNumbers = new LinkedList<String>();
        if (serialNumbers == null || serialNumbers.size() == 0) {
            LOG.debug("No serial numbers provided");
            return;
        }
        for (String serialNumber : serialNumbers) {
            if (serialNumber == null || serialNumber.length() == 0) {
                throw new IllegalArgumentException("Serial number values cannot be null or empty");
            }
            this.serialNumbers.add(serialNumber);
        }
    }

    public SerialNumberReader(File serialNumberFile) throws LocalLicenseConfigurationException {
        if (serialNumberFile == null) {
            throw new IllegalArgumentException("serialNumberFile cannot be null");
        }
        FileInputStream fstream = null;
        this.serialNumbers = new LinkedList<String>();
        try {
            fstream = new FileInputStream(serialNumberFile);
            SerialNumberReader.getSerialNumbersFromStream(fstream, this.serialNumbers);
            fstream.close();
        }
        catch (FileNotFoundException e) {
            LOG.debug("File not found loading serial numbers: ", e);
        }
        catch (IOException e) {
            LOG.error("Unexpected exception accessing serial numbers file, " + e);
        }
    }

    public SerialNumberReader(String componentId, File serialNumberDirectory) throws LocalLicenseConfigurationException {
        File[] files;
        if (serialNumberDirectory == null) {
            throw new IllegalArgumentException("serialNumberDirectory cannot be null");
        }
        this.serialNumbers = new LinkedList<String>();
        if (!serialNumberDirectory.isDirectory()) {
            LOG.warn(serialNumberDirectory + " is not a directory");
            return;
        }
        if (componentId == null || componentId.length() == 0) {
            throw new IllegalArgumentException("Must provide componentId");
        }
        String absPath = serialNumberDirectory.getAbsolutePath();
        String alaCarte = absPath + File.separatorChar + componentId + "-serial-numbers.txt";
        String vfabric = absPath + File.separatorChar + "vfabric-serial-numbers.txt";
        for (File file : files = new File[]{new File(alaCarte), new File(vfabric)}) {
            FileInputStream fstream = null;
            try {
                fstream = new FileInputStream(file);
                SerialNumberReader.getSerialNumbersFromStream(fstream, this.serialNumbers);
                fstream.close();
            }
            catch (FileNotFoundException e) {
                LOG.debug("File not found loading serial numbers: ", e);
            }
            catch (IOException e) {
                LOG.error("Unexpected exception accessing serial numbers file, " + e);
            }
        }
    }

    public SerialNumberReader(InputStream istream) throws LocalLicenseConfigurationException {
        this.serialNumbers = new LinkedList<String>();
        SerialNumberReader.getSerialNumbersFromStream(istream, this.serialNumbers);
    }

    private static void getSerialNumbersFromStream(InputStream istream, List<String> serials) throws LocalLicenseConfigurationException {
        try {
            SerialNumberUtil.getSerialNumbersFromStream(istream, serials);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LocalLicenseConfigurationException(e.getMessage());
        }
    }

    public Collection<String> getSerialNumbers() {
        return this.serialNumbers;
    }
}

