/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.client;

import com.springsource.vfabric.licensing.client.GuestInfoException;
import com.springsource.vfabric.licensing.client.LicenseManagerEnvironment;
import com.springsource.vfabric.licensing.log.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.LinkedList;

class RpcToolCommandBuilder {
    private final String[] toolsCmd;
    private static final String TOOLS_BINARY_PROPERTY_NAME = "vfabric.licensing.client.toolsbinary";
    private static Logger LOG = Logger.getLogger(RpcToolCommandBuilder.class);

    public RpcToolCommandBuilder() throws GuestInfoException {
        if (LicenseManagerEnvironment.isWindows()) {
            this.toolsCmd = RpcToolCommandBuilder.findWindowsToolsBinary();
        } else if (LicenseManagerEnvironment.isLinux()) {
            this.toolsCmd = RpcToolCommandBuilder.findUnixToolsBinary();
        } else {
            throw new GuestInfoException("Unsupported operating system '" + System.getProperty("os.name") + "'");
        }
        LOG.info("Using vmware tools service in '" + this.toolsCmd[0] + "'");
    }

    public String[] buildCommand(String rpcCommand) {
        Object[] cmd = new String[this.toolsCmd.length + 1];
        for (int i = 0; i < this.toolsCmd.length; ++i) {
            cmd[i] = this.toolsCmd[i];
        }
        cmd[this.toolsCmd.length] = rpcCommand;
        LOG.debug("GuestInfo command = " + Arrays.toString(cmd));
        return cmd;
    }

    private static String[] findWindowsToolsBinary() throws GuestInfoException {
        String userValue = System.getProperty(TOOLS_BINARY_PROPERTY_NAME);
        String retPath = null;
        if (userValue != null && userValue.length() > 0) {
            File userFile = new File(userValue);
            if (userFile.exists() && userFile.isFile()) {
                retPath = userFile.getAbsolutePath();
            } else {
                LOG.warn("Property vfabric.licensing.client.toolsbinary does specify an existing file. Searching other locations");
            }
        }
        LinkedList<String> prefixes = new LinkedList<String>();
        String path = System.getenv("ProgramFiles");
        if (path != null && path.length() != 0) {
            prefixes.add(path);
        }
        if ((path = System.getenv("ProgramFiles(x86)")) != null && path.length() != 0) {
            prefixes.add(path);
        }
        prefixes.add("c:\\Program Files");
        LinkedList<String> suffixes = new LinkedList<String>();
        suffixes.add("\\VMware\\VMware Tools\\rpctool.exe");
        suffixes.add("\\VMware\\VMware Tools\\VMwareService.exe");
        suffixes.add("\\VMware\\VMware Tools\\vmtoolsd.exe");
        for (String prefix : prefixes) {
            for (String suffix : suffixes) {
                File file = new File(prefix + suffix);
                LOG.info("Checking for " + file.getAbsolutePath());
                if (file.exists() && file.isFile()) {
                    retPath = file.getAbsolutePath();
                    break;
                }
                LOG.info("No tools executable in " + file.getAbsolutePath());
            }
            if (retPath == null) continue;
            break;
        }
        if (retPath == null) {
            throw new GuestInfoException("Could not find the vmware tools service binary.");
        }
        LOG.info("Found tools executable " + retPath);
        String verString = RpcToolCommandBuilder.simpleExec(new String[]{retPath, "-v"});
        if (verString != null) {
            LOG.info("Tools version: " + verString);
        } else {
            LOG.info("Tools did not report a version, probably old");
        }
        if (retPath.contains("rpctool")) {
            return new String[]{retPath};
        }
        return new String[]{retPath, "--cmd"};
    }

    private static String[] findUnixToolsBinary() throws GuestInfoException {
        String retPath = null;
        File tools = new File("/usr/sbin/vmtoolsd");
        LOG.info("Checking for " + tools.getAbsolutePath());
        if (tools.exists() || tools.isFile()) {
            retPath = tools.getAbsolutePath();
        } else {
            tools = new File("/usr/sbin/vmware-guestd");
            LOG.info("Checking for " + tools.getAbsolutePath());
            if (tools.exists() || tools.isFile()) {
                retPath = tools.getAbsolutePath();
            }
        }
        if (retPath == null) {
            throw new GuestInfoException("Could not find the vmware tools service binary.");
        }
        LOG.info("Found tools executable " + retPath);
        String verString = RpcToolCommandBuilder.simpleExec(new String[]{retPath, "-v"});
        if (verString != null) {
            LOG.info("Tools verion: " + verString);
        } else {
            LOG.info("Tools did not report a version, probably old");
        }
        return new String[]{retPath, "--cmd"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String simpleExec(String[] cmd) throws GuestInfoException {
        String retLine;
        try {
            BufferedReader reader = null;
            try {
                Process process = Runtime.getRuntime().exec(cmd);
                for (int waitTime = 0; waitTime < 5; ++waitTime) {
                    try {
                        process.exitValue();
                        break;
                    }
                    catch (IllegalThreadStateException e) {
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException e2) {
                            throw new IOException("Exception from Thread.sleep()??!!" + e2);
                        }
                    }
                }
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                retLine = reader.readLine();
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            throw new GuestInfoException("Could not launch " + Arrays.toString(cmd) + ", " + e);
        }
        return retLine;
    }
}

