/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.client;

import com.springsource.vfabric.licensing.client.ClassLoaderResource;
import com.springsource.vfabric.licensing.client.LicenseManagerEnvironment;
import com.springsource.vfabric.licensing.client.LicensePool;
import com.springsource.vfabric.licensing.client.LicenseProvider;
import com.springsource.vfabric.licensing.client.LocalLicenseConfigurationException;
import com.springsource.vfabric.licensing.client.LocalStateManager;
import com.springsource.vfabric.licensing.events.EventManager;
import com.springsource.vfabric.licensing.log.Logger;
import com.springsource.vfabric.licensing.state.LicenseState;
import com.vmware.licensecheck.DLFException;
import com.vmware.licensecheck.DLFPathFactory;
import com.vmware.licensecheck.DLFZipInputStreamFactory;
import com.vmware.licensecheck.IDLFFactory;
import com.vmware.licensecheck.LicenseAttributes;
import com.vmware.licensecheck.LicenseChecker;
import com.vmware.licensecheck.SerialNumException;
import java.io.File;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipInputStream;

class LocalVliCheckLicenseProvider
implements LicenseProvider {
    private static final Logger LOG = Logger.getLogger(LocalVliCheckLicenseProvider.class);
    private final String componentId;
    private final boolean isDefault;
    private static final String VFABRIC_PRODUCT_ID = "vFabric Platform";
    private static final String VFABRIC_LICENSE_VERSION = "5.0";
    private static final HashMap<Long, String> DLF_ERROR_MESSAGES = new HashMap();
    private LicensePool licensePool;

    public LocalVliCheckLicenseProvider(String componentId, String componentVersion, Collection<String> serialNumbers, LocalStateManager stateMgr, EventManager eventMgr) throws LocalLicenseConfigurationException {
        this.componentId = componentId;
        this.isDefault = false;
        int[] version = LocalVliCheckLicenseProvider.parseVersion(componentVersion);
        File dormantLicenseFolder = LicenseManagerEnvironment.getDefaultDormantLicensePath();
        List<LicenseAttributes> licenses = this.activateLicenses(serialNumbers, dormantLicenseFolder);
        this.licensePool = new LicensePool(licenses, this.componentId, version, stateMgr, eventMgr, this.isDefault);
    }

    public LocalVliCheckLicenseProvider(String componentId, Collection<String> serialNumbers, LocalStateManager stateMgr, EventManager eventMgr) throws LocalLicenseConfigurationException {
        this.componentId = componentId;
        this.isDefault = true;
        File dormantLicenseFolder = LicenseManagerEnvironment.getDefaultDormantLicensePath();
        List<LicenseAttributes> licenses = this.activateLicenses(serialNumbers, dormantLicenseFolder);
        this.licensePool = new LicensePool(licenses, this.componentId, null, stateMgr, eventMgr, this.isDefault);
    }

    private static int[] parseVersion(String componentVersion) {
        String[] strDigits = componentVersion.split("\\.");
        LinkedList<Integer> digits = new LinkedList<Integer>();
        for (String strDigit : strDigits) {
            try {
                digits.add(Integer.parseInt(strDigit));
            }
            catch (NumberFormatException e) {
                String msg = "Failed to parse element in version '" + componentVersion + "': " + e.getMessage();
                if (digits.size() < 2) {
                    throw new IllegalArgumentException(msg + ". Cannot continue with only " + digits.size() + " version digits.");
                }
                LOG.debug(msg + ". Continuing with " + digits.size() + " version digits.");
            }
        }
        int[] retVal = new int[digits.size()];
        int i = 0;
        for (Integer digit : digits) {
            retVal[i++] = digit;
        }
        return retVal;
    }

    @Override
    public LicenseState getComponentLicenseState() {
        Calendar expire = this.licensePool.getExpirationDate();
        LicenseState licenseState = new LicenseState(this.componentId, new Date(), this.isDefault ? "default" : "local", this.licensePool.getTotalAvailable(), this.licensePool.getTotalUsed(), expire == null ? null : expire.getTime(), this.licensePool.getEnforcement(), this.licensePool.getAddonFeatures(), new Properties());
        return licenseState;
    }

    @Override
    public void notifyStateChanged() {
        try {
            this.licensePool.startEvals();
        }
        catch (LocalLicenseConfigurationException e) {
            LOG.error("Failed to apply component change to licenses: ", e);
        }
    }

    private List<IDLFFactory> loadDLFs(File dormantLicenseFolder) throws LocalLicenseConfigurationException {
        LinkedList<IDLFFactory> dlfs = new LinkedList<IDLFFactory>();
        ClassLoaderResource resource = new ClassLoaderResource(this.getClass(), "licenses.zip");
        ZipInputStream zipStream = new ZipInputStream(resource.getStream());
        dlfs.add(new DLFZipInputStreamFactory(zipStream));
        try {
            if (dormantLicenseFolder.exists()) {
                dlfs.add(new DLFPathFactory("dir://" + dormantLicenseFolder.getAbsolutePath(), VFABRIC_LICENSE_VERSION, VFABRIC_PRODUCT_ID));
            }
        }
        catch (DLFException e) {
            throw new LocalLicenseConfigurationException("DLFException reading fil  es from " + dormantLicenseFolder + ":  " + e.getMessage());
        }
        return dlfs;
    }

    private List<LicenseAttributes> activateLicenses(Collection<String> serialNumbers, File dormantLicenseFolder) throws LocalLicenseConfigurationException {
        LinkedList<LicenseAttributes> licenses = new LinkedList<LicenseAttributes>();
        block0: for (String serialNumber : serialNumbers) {
            LicenseAttributes attributes = null;
            List<IDLFFactory> dlfs = this.loadDLFs(dormantLicenseFolder);
            for (IDLFFactory factory : dlfs) {
                attributes = this.activateOneSerialNumberInOneFactory(serialNumber, factory);
                if (attributes == null) continue;
                licenses.add(attributes);
                continue block0;
            }
        }
        return licenses;
    }

    private LicenseAttributes activateOneSerialNumberInOneFactory(String serialNumber, IDLFFactory dlfs) throws LocalLicenseConfigurationException {
        LicenseAttributes attributes = null;
        String msg = this.isDefault ? "Activated built-in default fallback serial number " : "Activated serial number ";
        try {
            LicenseChecker checker = new LicenseChecker();
            attributes = checker.checkSerial(serialNumber, dlfs);
            LOG.info(msg + serialNumber + " for " + attributes.getLicenseEdition() + ", expiration = " + attributes.getExpiration());
        }
        catch (SerialNumException e) {
            LOG.info("Failed to match serial number '" + serialNumber + "' to local license: " + e.getMessage());
        }
        catch (DLFException e) {
            if (e.getErrorCode() == 4L) {
                attributes = e.getLicenseAttributes();
                LOG.debug(msg + serialNumber + " for " + attributes.getLicenseEdition() + ", expiration = " + attributes.getExpiration());
            }
            if (e.getErrorCode() == 3L) {
                LOG.info("No valid DLFs found in filesystem factory for " + serialNumber, e);
            }
            throw new LocalLicenseConfigurationException("DLFException activating serial number '" + serialNumber + "': " + e.getMessage() + ", error = " + DLF_ERROR_MESSAGES.get(e.getErrorCode()));
        }
        return attributes;
    }

    void resetAllEvaluations() throws LocalLicenseConfigurationException {
        this.licensePool.resetAllEvaluations();
    }

    static {
        DLF_ERROR_MESSAGES.put(0L, "unknown");
        DLF_ERROR_MESSAGES.put(1L, "invalid path");
        DLF_ERROR_MESSAGES.put(2L, "DLF file is corrupted.");
        DLF_ERROR_MESSAGES.put(3L, "no DLF found");
        DLF_ERROR_MESSAGES.put(4L, "expired");
        DLF_ERROR_MESSAGES.put(5L, "unreadable properties");
    }
}

