/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.client;

import com.springsource.vfabric.licensing.client.CpuInfo;
import com.springsource.vfabric.licensing.log.Logger;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinuxCpuInfo
implements CpuInfo {
    private int[] coreCounts = null;
    private static final Logger LOG = Logger.getLogger(LinuxCpuInfo.class);

    public LinuxCpuInfo(InputStream reader) {
        Pattern linePattern = Pattern.compile("(.*?)\\s+:\\s+(.*)");
        Scanner scanner = new Scanner(reader, "US-ASCII");
        LinkedList<Processor> processors = new LinkedList<Processor>();
        int processorId = -1;
        int siblings = -1;
        int coreId = -1;
        int physicalId = -1;
        boolean foundCoreId = false;
        boolean firstPass = true;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            Matcher m = linePattern.matcher(line);
            try {
                if (!m.matches()) continue;
                if ("processor".equals(m.group(1))) {
                    if (!firstPass) {
                        LOG.info("Found processor " + processorId + ", physicalId = " + physicalId + ", siblings = " + siblings + ", coreId = " + coreId);
                        processors.add(new Processor(physicalId, coreId, siblings, processorId));
                    } else {
                        firstPass = false;
                    }
                    processorId = Integer.parseInt(m.group(2));
                    continue;
                }
                if ("core id".equals(m.group(1))) {
                    coreId = Integer.parseInt(m.group(2));
                    foundCoreId = true;
                    continue;
                }
                if ("siblings".equals(m.group(1))) {
                    siblings = Integer.parseInt(m.group(2));
                    continue;
                }
                if (!"physical id".equals(m.group(1))) continue;
                physicalId = Integer.parseInt(m.group(2));
            }
            catch (NumberFormatException e) {
                LOG.warn("Failed to parse number in cpuinfo for key '" + m.group(1) + "', value = '" + m.group(2) + "': " + e);
            }
        }
        LOG.info("Found processor " + processorId + ", physicalId = " + physicalId + ", siblings = " + siblings + ", coreId = " + coreId);
        processors.add(new Processor(physicalId, coreId, siblings, processorId));
        if (!foundCoreId) {
            this.coreCounts = new int[processors.size()];
            Arrays.fill(this.coreCounts, 1);
        } else {
            HashMap<Integer, HashSet<Integer>> coreIds = new HashMap<Integer, HashSet<Integer>>();
            for (Processor processor : processors) {
                HashSet<Integer> cores = (HashSet<Integer>)coreIds.get(processor.getPhysicalId());
                if (cores == null) {
                    cores = new HashSet<Integer>();
                }
                cores.add(processor.getCoreId());
                coreIds.put(processor.getPhysicalId(), cores);
            }
            this.coreCounts = new int[coreIds.size()];
            int i = 0;
            for (Set coreSet : coreIds.values()) {
                this.coreCounts[i++] = coreSet.size();
            }
        }
    }

    @Override
    public int[] getCoreCounts() {
        return this.coreCounts;
    }

    private static class Processor {
        int physicalId = -1;
        int coreId = -1;
        int siblings = -1;
        int processorId = -1;

        public Processor(int physicalId, int coreId, int siblings, int processorId) {
            this.physicalId = physicalId;
            this.coreId = coreId;
            this.siblings = siblings;
            this.processorId = processorId;
        }

        public int getPhysicalId() {
            return this.physicalId;
        }

        public int getCoreId() {
            return this.coreId;
        }

        public int getSiblings() {
            return this.siblings;
        }

        public int getProcessorId() {
            return this.processorId;
        }
    }
}

