/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.client;

import com.springsource.vfabric.licensing.client.ActivatedLicense;
import com.springsource.vfabric.licensing.client.LicenseManagerEnvironment;
import com.springsource.vfabric.licensing.client.LocalLicenseConfigurationException;
import com.springsource.vfabric.licensing.client.LocalStateManager;
import com.springsource.vfabric.licensing.events.EventManager;
import com.springsource.vfabric.licensing.events.LicenseActivatedEvent;
import com.springsource.vfabric.licensing.events.LicenseExpiredEvent;
import com.springsource.vfabric.licensing.log.Logger;
import com.vmware.licensecheck.LicenseAttributes;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class LicensePool {
    private final List<ActivatedLicense> licenses = new LinkedList<ActivatedLicense>();
    private static final Logger LOG = Logger.getLogger(LicensePool.class);
    static SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("EEE, MMM d, yyyy");
    private final LocalStateManager stateManager;
    private final EventManager eventManager;
    private final boolean isDefault;

    public LicensePool(Collection<LicenseAttributes> activeLicenses, String componentId, int[] componentVersion, LocalStateManager stateManager, EventManager eventManager, boolean isDefault) throws LocalLicenseConfigurationException {
        this.stateManager = stateManager;
        this.eventManager = eventManager;
        this.isDefault = isDefault;
        for (LicenseAttributes licenseAttributes : activeLicenses) {
            ActivatedLicense activated = new ActivatedLicense(licenseAttributes, stateManager);
            if ((componentVersion != null || !activated.isAllowedComponent(componentId)) && !activated.isAllowedComponentVersion(componentId, componentVersion)) continue;
            if (activated.isExpired() && !activated.expirationEventPosted()) {
                eventManager.saveEvent(new LicenseExpiredEvent(activated));
                activated.setExpirationEventPosted();
            } else {
                eventManager.saveEvent(new LicenseActivatedEvent(activated));
            }
            this.licenses.add(activated);
        }
        Collections.sort(this.licenses, new LicenseComparator());
        for (ActivatedLicense activatedLicense : this.licenses) {
            LOG.debug(activatedLicense.getSerialNumber() + " cost = " + activatedLicense.getCost());
        }
    }

    public void startEvals() throws LocalLicenseConfigurationException {
        int availableCount = 0;
        for (ActivatedLicense license : this.licenses) {
            if (license.isExpired() || license.isUnstartedEval() || license.isManagementNodeAddonLicense()) continue;
            availableCount += license.getCount();
        }
        boolean foundMoreLicenses = true;
        int currentCount = this.getTotalUsed();
        while (availableCount < currentCount && foundMoreLicenses) {
            if (!this.isDefault) {
                LOG.info("There are " + currentCount + " instances but only " + availableCount + " non-eval licenses available. Checking for evals...");
            }
            foundMoreLicenses = false;
            for (ActivatedLicense license : this.licenses) {
                if (license.isManagementNodeAddonLicense() || !license.isUnstartedEval()) continue;
                license.startEvaluationIfNotStarted(this.isDefault);
                availableCount += license.getCount();
                foundMoreLicenses = true;
                if (this.isDefault) break;
                LOG.info("Found evaluation license with serial number " + license.getSerialNumber() + " Added " + license.getCount() + " instances available until " + DATE_FORMAT.format(license.getExpirationDate().getTime()));
                break;
            }
            currentCount = this.getTotalUsed();
        }
    }

    public int getTotalAvailable() {
        int totalAvailable = 0;
        for (ActivatedLicense license : this.licenses) {
            if (license.isExpired()) {
                if (license.expirationEventPosted()) continue;
                this.eventManager.saveEvent(new LicenseExpiredEvent(license));
                license.setExpirationEventPosted();
                continue;
            }
            if (license.isManagementNodeAddonLicense()) continue;
            totalAvailable += license.getCount();
        }
        return totalAvailable;
    }

    public int getTotalUsed() {
        boolean containsSelf;
        int instancesToCount;
        try {
            instancesToCount = this.stateManager.getRunningCount();
            containsSelf = this.stateManager.containsRunningSelfInstance();
        }
        catch (LocalLicenseConfigurationException e) {
            LOG.error("Failed to get running count from license state", e);
            return Integer.MAX_VALUE;
        }
        int cpuLimit = 0;
        for (ActivatedLicense license : this.licenses) {
            if (license.isExpired()) continue;
            cpuLimit = license.getCpu();
            break;
        }
        int selfUsed = 0;
        if (containsSelf) {
            double machineCpus = LicenseManagerEnvironment.getCorrectedCpuCount();
            LOG.debug("Counting SELF based on a local cpu count of " + machineCpus + ", license cpu limit is " + cpuLimit + ", using " + (selfUsed += cpuLimit == 0 ? 1 : (int)Math.ceil(machineCpus / (double)cpuLimit)) + " counts.");
            --instancesToCount;
        }
        LOG.debug("Counting managed instances, 1 count-per-instance, for " + instancesToCount + " instances.");
        return selfUsed + instancesToCount;
    }

    public Calendar getExpirationDate() {
        Calendar latest = null;
        for (ActivatedLicense license : this.licenses) {
            if (license.isPerpetual()) {
                return null;
            }
            if (!license.isExpiringOnASetDate() && !license.isFloatingEval()) continue;
            Calendar expirationDate = license.getExpirationDate();
            if (latest != null && (expirationDate == null || !expirationDate.after(latest))) continue;
            latest = expirationDate;
        }
        return latest;
    }

    public String getEnforcement() {
        for (ActivatedLicense license : this.licenses) {
            if (!license.getEnforcement().equals("soft")) continue;
            return "soft";
        }
        return "hard";
    }

    public Set<String> getAddonFeatures() {
        HashSet<String> addonSet = new HashSet<String>();
        for (ActivatedLicense license : this.licenses) {
            addonSet.addAll(license.getAddonFeatures());
        }
        return addonSet;
    }

    void resetAllEvaluations() throws LocalLicenseConfigurationException {
        for (ActivatedLicense license : this.licenses) {
            this.stateManager.clearEvaluation(license.getSerialNumber());
        }
    }

    private class LicenseComparator
    implements Comparator<ActivatedLicense> {
        private LicenseComparator() {
        }

        @Override
        public int compare(ActivatedLicense left, ActivatedLicense right) {
            return left.getCost() - right.getCost();
        }
    }
}

