/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.client;

import com.springsource.vfabric.licensing.about.About;
import com.springsource.vfabric.licensing.client.ClassLoaderResource;
import com.springsource.vfabric.licensing.client.Config;
import com.springsource.vfabric.licensing.client.GuestInfoLicenseProvider;
import com.springsource.vfabric.licensing.client.HttpLicenseProvider;
import com.springsource.vfabric.licensing.client.LicenseException;
import com.springsource.vfabric.licensing.client.LicenseManager;
import com.springsource.vfabric.licensing.client.LicenseManagerEnvironment;
import com.springsource.vfabric.licensing.client.LicenseProvider;
import com.springsource.vfabric.licensing.client.LocalLicenseConfigurationException;
import com.springsource.vfabric.licensing.client.LocalVliCheckLicenseProvider;
import com.springsource.vfabric.licensing.client.MasterLicenseManager;
import com.springsource.vfabric.licensing.client.SerialNumberReader;
import com.springsource.vfabric.licensing.client.VmToolsGuestInfoAccessor;
import com.springsource.vfabric.licensing.log.Logger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class LicenseManagerFactory {
    public static final String COMPONENT_ID_TC = "vf.tc";
    public static final String COMPONENT_ID_HYPERIC = "vf.hyp";
    public static final String COMPONENT_ID_GEMFIRE_CACHE = "vf.gf.acn";
    public static final String COMPONENT_ID_GEMFIRE_MGMT = "vf.gf.dmn";
    public static final String COMPONENT_ID_RABBIT = "vf.rmq";
    public static final String COMPONENT_ID_SQLFIRE = "vf.sf";
    public static final String COMPONENT_ID_WEBSERVER = "vf.ws";
    public static final String COMPONENT_ID_INSIGHT = "vf.ins";
    public static final String COMPONENT_ID_EM4J = "vf.emj";
    private static final Logger LOG = Logger.getLogger(LicenseManagerFactory.class);

    public static LicenseManager getLicenseManager(String componentId, String componentVersion) throws LicenseException {
        return LicenseManagerFactory.getLicenseManager(componentId, componentVersion, (Collection<SerialNumberReader>)null, null);
    }

    public static LicenseManager getLicenseManager(String componentId, String componentVersion, String[] serialNumbers, File licenseHomeFolder) throws LicenseException {
        if (componentId == null || componentVersion == null) {
            throw new IllegalArgumentException("Need a componentId and version");
        }
        LOG.info("Creating license manager, vfabric platform version: " + About.getVersion() + ", built: " + About.getBuildDateTime() + ", head revision: " + About.getHeadRevision());
        ArrayList<String> serialsList = serialNumbers == null ? new ArrayList() : Arrays.asList(serialNumbers);
        SerialNumberReader reader = new SerialNumberReader(serialsList);
        LicenseManagerEnvironment env = new LicenseManagerEnvironment(componentId, Arrays.asList(reader), licenseHomeFolder);
        return LicenseManagerFactory.buildMasterLicenseManager(componentId, componentVersion, env);
    }

    public static LicenseManager getLicenseManager(String componentId, String componentVersion, Collection<SerialNumberReader> serialNumbers, File licenseHomeFolder) throws LicenseException {
        if (componentId == null || componentVersion == null) {
            throw new IllegalArgumentException("Need a componentId and version");
        }
        LOG.info("Creating license manager, vfabric platform version: " + About.getVersion() + ", built: " + About.getBuildDateTime() + ", head revision: " + About.getHeadRevision());
        LicenseManagerEnvironment env = new LicenseManagerEnvironment(componentId, serialNumbers, licenseHomeFolder);
        return LicenseManagerFactory.buildMasterLicenseManager(componentId, componentVersion, env);
    }

    public static LicenseManager getLicenseManager(String componentId, String componentVersion, String[] serialNumbers, File licenseStateFile, File eventsFile) throws LicenseException {
        if (componentId == null || componentVersion == null) {
            throw new IllegalArgumentException("Need a componentId and version");
        }
        ArrayList<String> serialCollection = serialNumbers == null ? new ArrayList() : Arrays.asList(serialNumbers);
        LOG.info("Creating license manager, vfabric platform version: " + About.getVersion() + ", built: " + About.getBuildDateTime() + ", head revision: " + About.getHeadRevision());
        LicenseManagerEnvironment env = new LicenseManagerEnvironment(componentId, serialCollection, licenseStateFile, eventsFile);
        return LicenseManagerFactory.buildMasterLicenseManager(componentId, componentVersion, env);
    }

    public static LicenseManager getLicenseManager(String componentId, String componentVersion, URL licenseServerAddress, File licenseHomeFolder) throws LicenseException {
        if (componentId == null || componentVersion == null) {
            throw new IllegalArgumentException("Need a componentId and version");
        }
        LicenseManagerEnvironment env = new LicenseManagerEnvironment(componentId, null, licenseHomeFolder);
        LOG.info("Creating license manager, vfabric platform version: " + About.getVersion() + ", built: " + About.getBuildDateTime() + ", head revision: " + About.getHeadRevision());
        HttpLicenseProvider activeProvider = new HttpLicenseProvider(componentId, componentVersion, LicenseManagerEnvironment.getCorrectedCpuCount(), licenseServerAddress, env.getStateManager(), env.getEventManager());
        LocalVliCheckLicenseProvider defaultProvider = LicenseManagerFactory.buildDefaultLicenseProvider(componentId, env);
        return new MasterLicenseManager(activeProvider, defaultProvider, env.getStateManager(), env.getEventManager(), false);
    }

    private static LicenseProvider tryBuildGuestInfoLicenseProvider(String componentId, String componentVersion, LicenseManagerEnvironment env) {
        try {
            return new GuestInfoLicenseProvider(componentId, componentVersion, new VmToolsGuestInfoAccessor(), env.getStateManager(), env.getEventManager());
        }
        catch (LicenseException e) {
            LOG.info("Could not create guest info license manager, ", e);
            return null;
        }
    }

    private static LicenseProvider tryBuildLocalLicenseProvider(String componentId, String componentVersion, LicenseManagerEnvironment env) {
        try {
            return new LocalVliCheckLicenseProvider(componentId, componentVersion, env.getSerialNumbers(), env.getStateManager(), env.getEventManager());
        }
        catch (LocalLicenseConfigurationException e) {
            LOG.info("Failed to create local license manager, ", e);
            return null;
        }
    }

    static LocalVliCheckLicenseProvider buildDefaultLicenseProvider(String componentId, LicenseManagerEnvironment env) throws LocalLicenseConfigurationException {
        ClassLoaderResource resource = new ClassLoaderResource(LicenseManagerFactory.class, "default-eval-serial.txt");
        SerialNumberReader serialNumbers = new SerialNumberReader(resource.getStream());
        LocalVliCheckLicenseProvider lm = new LocalVliCheckLicenseProvider(componentId, serialNumbers.getSerialNumbers(), env.getStateManager(), env.getEventManager());
        return lm;
    }

    private static LicenseManager buildMasterLicenseManager(String componentId, String componentVersion, LicenseManagerEnvironment env) throws LocalLicenseConfigurationException {
        LicenseProvider activeLm = null;
        activeLm = LicenseManagerFactory.tryBuildLocalLicenseProvider(componentId, componentVersion, env);
        boolean isSelf = true;
        if (activeLm == null || activeLm.getComponentLicenseState().getTotalAvailable() == 0) {
            Config.addFromFile(new File(env.getHomeFolder() + "/vflicense.properties"));
            String httpServerAddress = Config.getLicenseServerAddress();
            if (httpServerAddress != null && httpServerAddress.length() > 0) {
                try {
                    activeLm = new HttpLicenseProvider(componentId, componentVersion, LicenseManagerEnvironment.getCorrectedCpuCount(), new URL(httpServerAddress), env.getStateManager(), env.getEventManager());
                    isSelf = false;
                }
                catch (MalformedURLException e) {
                    LOG.error("could not build http license manager, malformed url " + httpServerAddress + ": " + e);
                }
                catch (LicenseException e) {
                    LOG.error("error building http license manager for " + httpServerAddress + ": " + e);
                }
            } else {
                activeLm = LicenseManagerFactory.tryBuildGuestInfoLicenseProvider(componentId, componentVersion, env);
            }
        }
        LocalVliCheckLicenseProvider defaultLm = LicenseManagerFactory.buildDefaultLicenseProvider(componentId, env);
        return new MasterLicenseManager(activeLm, defaultLm, env.getStateManager(), env.getEventManager(), isSelf);
    }
}

