/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.client;

import com.springsource.vfabric.licensing.log.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;

public class Config {
    private static final Logger LOG = Logger.getLogger(Config.class);
    static final String MACHINE_CPUS_PROP = "vfabric.internal.test.cpucount";
    static final String HEARTBEAT_INTERVAL_PROP = "vfabric.internal.test.heartbeatinterval";
    static final String FAKE_PROC_CPUINFO = "vfabric.internal.test.fakeproccpuinfo";
    static final String FAKE_CORES_PER_SOCKET = "vfabric.internal.test.fakecorespersocket";
    static final String VFLICENSE_SERVER_ADDRESS = "vfabric.licensing.server.address";
    static final String EC2METADATA_CONNECT_TIMEOUT = "vfabric.licensing.ec2connecttimeout";
    static final String EC2METADATA_READ_TIMEOUT = "vfabric.licensing.ec2readtimeout";
    private static final long DEFAULT_HEARTBEAT_INTERVAL_SECONDS = 3600L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void addFromFile(File file) {
        newProps = new Properties();
        reader = null;
        try {
            reader = new FileReader(file);
            newProps.load(reader);
            ** if (reader == null) goto lbl-1000
        }
        catch (FileNotFoundException e) {
            block17: {
                Config.LOG.info(new Object[]{file.getAbsolutePath() + " configuration file not found."});
                if (reader == null) break block17;
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Config.LOG.error(new Object[]{file.getAbsolutePath() + " failed to close file: " + e});
                }
            }
            return;
        }
        catch (IOException e) {
            block18: {
                Config.LOG.warn(new Object[]{file.getAbsolutePath() + " configuration file read failure " + e});
                if (reader == null) break block18;
                {
                    catch (Throwable var5_10) {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {
                                Config.LOG.error(new Object[]{file.getAbsolutePath() + " failed to close file: " + e});
                            }
                        }
                        throw var5_10;
                    }
                }
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Config.LOG.error(new Object[]{file.getAbsolutePath() + " failed to close file: " + e});
                }
            }
            return;
        }
lbl-1000:
        // 1 sources

        {
            try {
                reader.close();
            }
            catch (IOException e) {
                Config.LOG.error(new Object[]{file.getAbsolutePath() + " failed to close file: " + e});
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        for (Object key : newProps.keySet()) {
            System.setProperty((String)key, (String)newProps.get(key));
        }
    }

    public static long getHeartbeatInterval() {
        return Config.getLongProperty(HEARTBEAT_INTERVAL_PROP, 3600L);
    }

    public static long getCpuCount() {
        return Config.getLongProperty(MACHINE_CPUS_PROP, -1L);
    }

    public static String getLinuxRuntimeInfo() {
        String option = System.getProperty(FAKE_PROC_CPUINFO);
        return option == null ? "/proc/cpuinfo" : option;
    }

    public static long getMaxCoresPreSocket() {
        return Config.getLongProperty(FAKE_CORES_PER_SOCKET, 6L);
    }

    private static long getLongProperty(String propName, long defaultVal) {
        String option = System.getProperty(propName);
        long retVal = defaultVal;
        if (option != null) {
            try {
                retVal = Long.parseLong(option);
            }
            catch (NumberFormatException e) {
                LOG.error("Could not parse '" + option + "' from " + propName + ", using default value of " + defaultVal);
            }
        }
        return retVal;
    }

    public static String getLicenseServerAddress() {
        return System.getProperty(VFLICENSE_SERVER_ADDRESS);
    }

    public static int getEc2ConnectTimeout() {
        return (int)Config.getLongProperty(EC2METADATA_CONNECT_TIMEOUT, 1000L);
    }

    public static int getEc2ReadTimeout() {
        return (int)Config.getLongProperty(EC2METADATA_READ_TIMEOUT, 1000L);
    }
}

