/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.client;

import com.springsource.vfabric.licensing.client.LocalLicenseConfigurationException;
import com.springsource.vfabric.licensing.client.LocalStateManager;
import com.springsource.vfabric.licensing.log.Logger;
import java.io.InputStream;

public class ClassLoaderResource {
    private static final Logger LOG = Logger.getLogger(LocalStateManager.class);
    private InputStream stream = null;

    public ClassLoaderResource(Class clazz, String path) throws LocalLicenseConfigurationException {
        ClassLoader cl = clazz.getClassLoader();
        if (cl != null) {
            LOG.info("using " + clazz.getCanonicalName() + " classloader to get resource " + path);
        } else {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl != null) {
            LOG.info("using system classloader to get resource " + path);
            this.stream = cl.getResourceAsStream(path);
        }
        if (this.stream == null) {
            throw new LocalLicenseConfigurationException("Could not get resource " + path);
        }
    }

    public InputStream getStream() {
        return this.stream;
    }
}

