/*
 * Decompiled with CFR 0.152.
 */
package com.springsource.vfabric.licensing.client;

import com.springsource.vfabric.licensing.client.AllowedComponentVersion;
import com.springsource.vfabric.licensing.client.LocalLicenseConfigurationException;
import com.springsource.vfabric.licensing.client.LocalStateManager;
import com.springsource.vfabric.licensing.log.Logger;
import com.vmware.licensecheck.DLFException;
import com.vmware.licensecheck.LicenseAttributes;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ActivatedLicense {
    private final LicenseAttributes licenseAttributes;
    private final LocalStateManager stateManager;
    private static final Logger LOG = Logger.getLogger(ActivatedLicense.class);

    public ActivatedLicense(LicenseAttributes attributes, LocalStateManager stateManager) {
        this.licenseAttributes = attributes;
        this.stateManager = stateManager;
    }

    public String getCapacityType() {
        return this.getField("capacityType");
    }

    public String getDescription() {
        return this.getField("desc");
    }

    public int getCpu() {
        return this.getIntValueFromEnable("cpu");
    }

    public int getCost() {
        return this.getIntValueFromEnable("cost");
    }

    private int getIntValueFromEnable(String name) {
        try {
            return Integer.parseInt(this.getFromEnable(name));
        }
        catch (NumberFormatException e) {
            LOG.error("Could not parse number value for '" + name + "'", e);
        }
        catch (LocalLicenseConfigurationException e) {
            LOG.error("Could not get '" + name + "' value from dormant license", e);
        }
        return -1;
    }

    public Set<AllowedComponentVersion> getAllowedComponentVersions() {
        String[] allowedVersionStrings;
        String includes;
        try {
            includes = this.getFromEnable("include");
        }
        catch (LocalLicenseConfigurationException e) {
            LOG.error("Failed to get include value from dormant license", e);
            return new HashSet<AllowedComponentVersion>();
        }
        HashSet<AllowedComponentVersion> ret = new HashSet<AllowedComponentVersion>();
        for (String allowedVersionString : allowedVersionStrings = includes.split("\\|")) {
            String[] pair = allowedVersionString.split("-");
            String componentId = pair[0];
            String[] versionElems = pair[1].split("\\.");
            int[] version = new int[versionElems.length];
            for (int i = 0; i < versionElems.length; ++i) {
                version[i] = Integer.parseInt(versionElems[i]);
            }
            ret.add(new AllowedComponentVersion(componentId, version));
        }
        return ret;
    }

    private String getField(String key2) {
        Pattern p = Pattern.compile(".*" + key2 + "=([^;]*).*");
        Matcher m = p.matcher(this.licenseAttributes.getData());
        if (m.matches() && m.groupCount() > 0) {
            return m.group(1);
        }
        return null;
    }

    private String getFromEnable(String key2) throws LocalLicenseConfigurationException {
        String[] enables;
        for (String enable : enables = this.licenseAttributes.getEnabledFeatures()) {
            String[] pair = enable.split(":");
            if (pair == null || pair.length != 2) {
                throw new LocalLicenseConfigurationException("Found bad enable field in dlf with serial " + this.licenseAttributes.getSerial());
            }
            if (!pair[0].equals(key2)) continue;
            return pair[1];
        }
        return null;
    }

    public boolean isAllowedComponentVersion(String componentId, int[] version) {
        Set<AllowedComponentVersion> allowedVersions = this.getAllowedComponentVersions();
        for (AllowedComponentVersion allowedVersion : allowedVersions) {
            if (!allowedVersion.isAllowed(componentId, version)) continue;
            LOG.info("Component '" + componentId + "':" + Arrays.toString(version) + " is allowed for license with serial number " + this.licenseAttributes.getSerial());
            return true;
        }
        try {
            LOG.info("Component '" + componentId + "':" + Arrays.toString(version) + " is not allowed for license with serial number " + this.licenseAttributes.getSerial() + ", license includes " + this.getFromEnable("include"));
        }
        catch (LocalLicenseConfigurationException e) {
            // empty catch block
        }
        return false;
    }

    public boolean isAllowedComponent(String componentId) {
        Set<AllowedComponentVersion> allowedVersions = this.getAllowedComponentVersions();
        for (AllowedComponentVersion allowedVersion : allowedVersions) {
            if (!allowedVersion.isAllowed(componentId)) continue;
            LOG.info("Component '" + componentId + " is allowed for license with serial number " + this.licenseAttributes.getSerial() + ". No version check.");
            return true;
        }
        try {
            LOG.info("Component '" + componentId + " is not allowed even for default fallback evaluation license " + this.licenseAttributes.getSerial() + ", license includes " + this.getFromEnable("include"));
        }
        catch (LocalLicenseConfigurationException localLicenseConfigurationException) {
            // empty catch block
        }
        return false;
    }

    public void startEvaluationIfNotStarted(boolean isDefault) throws LocalLicenseConfigurationException {
        if (this.isFloatingEval()) {
            this.stateManager.startEvaluationIfNotStarted(this.licenseAttributes.getSerial(), isDefault);
        }
    }

    public void clearEvaluationPeriod() throws LocalLicenseConfigurationException {
        if (this.isFloatingEval()) {
            this.stateManager.clearEvaluation(this.licenseAttributes.getSerial());
        }
    }

    public boolean isExpired() {
        if (this.isExpiringOnASetDate()) {
            return this.licenseAttributes.isExpired();
        }
        if (this.isFloatingEval()) {
            Calendar expirationDate = this.getExpirationDate();
            if (expirationDate == null) {
                return false;
            }
            return expirationDate.before(new GregorianCalendar());
        }
        return false;
    }

    public Calendar getExpirationDate() {
        if (this.isExpiringOnASetDate()) {
            try {
                return this.licenseAttributes.getExpirationDate();
            }
            catch (DLFException e) {
                LOG.error("Failed to get expiration date", e);
                return null;
            }
        }
        if (this.isFloatingEval()) {
            Calendar evalStart = this.getEvaluationStartDate();
            if (evalStart != null) {
                GregorianCalendar expirationDate = new GregorianCalendar();
                expirationDate.setTime(evalStart.getTime());
                expirationDate.add(5, 30 * this.licenseAttributes.getExpiration());
                return expirationDate;
            }
            return null;
        }
        return null;
    }

    public boolean isFloatingEval() {
        return this.licenseAttributes.isExpiring() && this.licenseAttributes.getIssue() == 0;
    }

    public boolean isPerpetual() {
        return !this.licenseAttributes.isExpiring();
    }

    public boolean isExpiringOnASetDate() {
        return this.licenseAttributes.isExpiring() && this.licenseAttributes.getIssue() > 0;
    }

    public boolean isUnstartedEval() {
        return this.isFloatingEval() && !this.isEvalulationPeriodStarted();
    }

    public int getCount() {
        return this.licenseAttributes.getCount();
    }

    public boolean isManagementNodeAddonLicense() {
        boolean answer;
        block3: {
            answer = false;
            try {
                String[] addons = this.licenseAttributes.getAddonFeatures();
                if (addons == null) break block3;
                for (String addon : addons) {
                    if (!addon.equals("vf.gf.unlimited-client") && !addon.equals("vf.gf.global-wan") && !addon.equals("vf.sf.global-wan")) continue;
                    answer = true;
                    break;
                }
            }
            catch (DLFException dLFException) {
                // empty catch block
            }
        }
        return answer;
    }

    public String getSerialNumber() {
        return this.licenseAttributes.getSerial();
    }

    public Set<String> getAddonFeatures() {
        try {
            HashSet<String> ret = new HashSet<String>();
            String[] addonFeatures = this.licenseAttributes.getAddonFeatures();
            if (addonFeatures != null) {
                for (String feature : addonFeatures) {
                    ret.add(feature);
                }
            }
            return ret;
        }
        catch (DLFException e) {
            LOG.error("DLFException trying to get addonFeatures from DLF with serial " + this.licenseAttributes.getSerial() + ": " + e);
            return new HashSet<String>();
        }
    }

    public String getEnforcement() {
        try {
            return this.getFromEnable("enforce");
        }
        catch (LocalLicenseConfigurationException e) {
            LOG.error("Failed to get 'enforce' value from dormant license, assuming soft.", e);
            return "soft";
        }
    }

    public Calendar getEvaluationStartDate() {
        try {
            return this.stateManager.getEvaluationPeriodStart(this.licenseAttributes.getSerial());
        }
        catch (LocalLicenseConfigurationException e) {
            LOG.error("Failed to retrieve evaluation information from saved state", e);
            return null;
        }
    }

    public boolean isEvalulationPeriodStarted() {
        return this.getEvaluationStartDate() != null;
    }

    public String getPrettyExpirationType() {
        if (this.isPerpetual()) {
            return "perpetual";
        }
        if (this.isExpiringOnASetDate()) {
            return "fixed-expire";
        }
        return "floating-eval";
    }

    public boolean expirationEventPosted() {
        return this.stateManager.getExpirationEventPosted(this.licenseAttributes.getSerial());
    }

    public void setExpirationEventPosted() {
        this.stateManager.setExpirationEventPosted(this.licenseAttributes.getSerial());
    }
}

