/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.json;

import com.gemstone.org.json.JSONException;
import com.gemstone.org.json.JSONObject;
import com.gemstone.org.json.JSONTokener;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class JSONArray {
    private final ArrayList myArrayList = new ArrayList();

    public JSONArray() {
    }

    public JSONArray(JSONTokener x) throws JSONException {
        this();
        if (x.nextClean() != '[') {
            throw x.syntaxError("A JSONArray text must start with '['");
        }
        if (x.nextClean() != ']') {
            x.back();
            block4: while (true) {
                if (x.nextClean() == ',') {
                    x.back();
                    this.myArrayList.add(JSONObject.NULL);
                } else {
                    x.back();
                    this.myArrayList.add(x.nextValue());
                }
                switch (x.nextClean()) {
                    case ',': 
                    case ';': {
                        if (x.nextClean() == ']') {
                            return;
                        }
                        x.back();
                        continue block4;
                    }
                    case ']': {
                        return;
                    }
                }
                break;
            }
            throw x.syntaxError("Expected a ',' or ']'");
        }
    }

    public JSONArray(String source) throws JSONException {
        this(new JSONTokener(source));
    }

    public JSONArray(Collection collection) {
        if (collection != null) {
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                this.myArrayList.add(JSONObject.wrap(iter.next()));
            }
        }
    }

    public JSONArray(Object array) throws JSONException {
        this();
        if (array.getClass().isArray()) {
            int length = Array.getLength(array);
            for (int i = 0; i < length; ++i) {
                this.put(JSONObject.wrap(Array.get(array, i)));
            }
        } else {
            throw new JSONException("JSONArray initial value should be a string or collection or array.");
        }
    }

    public Object get(int index2) throws JSONException {
        Object object = this.opt(index2);
        if (object == null) {
            throw new JSONException("JSONArray[" + index2 + "] not found.");
        }
        return object;
    }

    public boolean getBoolean(int index2) throws JSONException {
        Object object = this.get(index2);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw new JSONException("JSONArray[" + index2 + "] is not a boolean.");
    }

    public double getDouble(int index2) throws JSONException {
        Object object = this.get(index2);
        try {
            return object instanceof Number ? ((Number)object).doubleValue() : Double.parseDouble((String)object);
        }
        catch (Exception e) {
            throw new JSONException("JSONArray[" + index2 + "] is not a number.");
        }
    }

    public int getInt(int index2) throws JSONException {
        Object object = this.get(index2);
        try {
            return object instanceof Number ? ((Number)object).intValue() : Integer.parseInt((String)object);
        }
        catch (Exception e) {
            throw new JSONException("JSONArray[" + index2 + "] is not a number.");
        }
    }

    public JSONArray getJSONArray(int index2) throws JSONException {
        Object object = this.get(index2);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw new JSONException("JSONArray[" + index2 + "] is not a JSONArray.");
    }

    public JSONObject getJSONObject(int index2) throws JSONException {
        Object object = this.get(index2);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw new JSONException("JSONArray[" + index2 + "] is not a JSONObject.");
    }

    public long getLong(int index2) throws JSONException {
        Object object = this.get(index2);
        try {
            return object instanceof Number ? ((Number)object).longValue() : Long.parseLong((String)object);
        }
        catch (Exception e) {
            throw new JSONException("JSONArray[" + index2 + "] is not a number.");
        }
    }

    public String getString(int index2) throws JSONException {
        Object object = this.get(index2);
        if (object instanceof String) {
            return (String)object;
        }
        throw new JSONException("JSONArray[" + index2 + "] not a string.");
    }

    public boolean isNull(int index2) {
        return JSONObject.NULL.equals(this.opt(index2));
    }

    public String join(String separator) throws JSONException {
        int len = this.length();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(separator);
            }
            sb.append(JSONObject.valueToString(this.myArrayList.get(i)));
        }
        return sb.toString();
    }

    public int length() {
        return this.myArrayList.size();
    }

    public Object opt(int index2) {
        return index2 < 0 || index2 >= this.length() ? null : this.myArrayList.get(index2);
    }

    public boolean optBoolean(int index2) {
        return this.optBoolean(index2, false);
    }

    public boolean optBoolean(int index2, boolean defaultValue) {
        try {
            return this.getBoolean(index2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public double optDouble(int index2) {
        return this.optDouble(index2, Double.NaN);
    }

    public double optDouble(int index2, double defaultValue) {
        try {
            return this.getDouble(index2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public int optInt(int index2) {
        return this.optInt(index2, 0);
    }

    public int optInt(int index2, int defaultValue) {
        try {
            return this.getInt(index2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public JSONArray optJSONArray(int index2) {
        Object o = this.opt(index2);
        return o instanceof JSONArray ? (JSONArray)o : null;
    }

    public JSONObject optJSONObject(int index2) {
        Object o = this.opt(index2);
        return o instanceof JSONObject ? (JSONObject)o : null;
    }

    public long optLong(int index2) {
        return this.optLong(index2, 0L);
    }

    public long optLong(int index2, long defaultValue) {
        try {
            return this.getLong(index2);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public String optString(int index2) {
        return this.optString(index2, "");
    }

    public String optString(int index2, String defaultValue) {
        Object object = this.opt(index2);
        return JSONObject.NULL.equals(object) ? defaultValue : object.toString();
    }

    public JSONArray put(boolean value2) {
        this.put(value2 ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(Collection value2) {
        this.put(new JSONArray(value2));
        return this;
    }

    public JSONArray put(double value2) throws JSONException {
        Double d = new Double(value2);
        JSONObject.testValidity(d);
        this.put(d);
        return this;
    }

    public JSONArray put(int value2) {
        this.put(new Integer(value2));
        return this;
    }

    public JSONArray put(long value2) {
        this.put(new Long(value2));
        return this;
    }

    public JSONArray put(Map value2) {
        this.put(new JSONObject(value2));
        return this;
    }

    public JSONArray put(Object value2) {
        this.myArrayList.add(value2);
        return this;
    }

    public JSONArray put(int index2, boolean value2) throws JSONException {
        this.put(index2, value2 ? Boolean.TRUE : Boolean.FALSE);
        return this;
    }

    public JSONArray put(int index2, Collection value2) throws JSONException {
        this.put(index2, new JSONArray(value2));
        return this;
    }

    public JSONArray put(int index2, double value2) throws JSONException {
        this.put(index2, new Double(value2));
        return this;
    }

    public JSONArray put(int index2, int value2) throws JSONException {
        this.put(index2, new Integer(value2));
        return this;
    }

    public JSONArray put(int index2, long value2) throws JSONException {
        this.put(index2, new Long(value2));
        return this;
    }

    public JSONArray put(int index2, Map value2) throws JSONException {
        this.put(index2, new JSONObject(value2));
        return this;
    }

    public JSONArray put(int index2, Object value2) throws JSONException {
        JSONObject.testValidity(value2);
        if (index2 < 0) {
            throw new JSONException("JSONArray[" + index2 + "] not found.");
        }
        if (index2 < this.length()) {
            this.myArrayList.set(index2, value2);
        } else {
            while (index2 != this.length()) {
                this.put(JSONObject.NULL);
            }
            this.put(value2);
        }
        return this;
    }

    public Object remove(int index2) {
        Object o = this.opt(index2);
        this.myArrayList.remove(index2);
        return o;
    }

    public JSONObject toJSONObject(JSONArray names) throws JSONException {
        if (names == null || names.length() == 0 || this.length() == 0) {
            return null;
        }
        JSONObject jo = new JSONObject();
        for (int i = 0; i < names.length(); ++i) {
            jo.put(names.getString(i), this.opt(i));
        }
        return jo;
    }

    public String toString() {
        try {
            return '[' + this.join(",") + ']';
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(int indentFactor) throws JSONException {
        StringWriter sw = new StringWriter();
        StringBuffer stringBuffer = sw.getBuffer();
        synchronized (stringBuffer) {
            return this.write(sw, indentFactor, 0).toString();
        }
    }

    public Writer write(Writer writer) throws JSONException {
        return this.write(writer, 0, 0);
    }

    Writer write(Writer writer, int indentFactor, int indent) throws JSONException {
        try {
            boolean commanate = false;
            int length = this.length();
            writer.write(91);
            if (length == 1) {
                JSONObject.writeValue(writer, this.myArrayList.get(0), indentFactor, indent);
            } else if (length != 0) {
                int newindent = indent + indentFactor;
                for (int i = 0; i < length; ++i) {
                    if (commanate) {
                        writer.write(44);
                    }
                    if (indentFactor > 0) {
                        writer.write(10);
                    }
                    JSONObject.indent(writer, newindent);
                    JSONObject.writeValue(writer, this.myArrayList.get(i), indentFactor, newindent);
                    commanate = true;
                }
                if (indentFactor > 0) {
                    writer.write(10);
                }
                JSONObject.indent(writer, indent);
            }
            writer.write(93);
            return writer;
        }
        catch (IOException e) {
            throw new JSONException(e);
        }
    }
}

