/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.util;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.SystemConnectException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.ChannelException;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.conf.ClassConfigurator;
import com.gemstone.org.jgroups.protocols.FD;
import com.gemstone.org.jgroups.protocols.PingHeader;
import com.gemstone.org.jgroups.protocols.UdpHeader;
import com.gemstone.org.jgroups.protocols.pbcast.NakAckHeader;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.util.Buffer;
import com.gemstone.org.jgroups.util.ExposedByteArrayOutputStream;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Queue;
import com.gemstone.org.jgroups.util.Range;
import com.gemstone.org.jgroups.util.Streamable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.security.SecureRandom;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class Util {
    private static final Object mutex = new Object();
    private static final ByteArrayOutputStream out_stream = new ByteArrayOutputStream(512);
    private static NumberFormat f = NumberFormat.getNumberInstance();
    public static final int MAX_PORT = 65535;
    public static final String DIAG_GROUP = "DIAG_GROUP-BELA-322649";
    static final String IGNORE_BIND_ADDRESS_PROPERTY = "ignore.bind.address";

    public static void closeInputStream(InputStream inp) {
        if (inp != null) {
            try {
                inp.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void closeOutputStream(OutputStream out) {
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object objectFromByteBuffer(byte[] buffer) throws IOException, ClassNotFoundException {
        Object object = mutex;
        synchronized (object) {
            if (buffer == null) {
                return null;
            }
            Object retval = null;
            ByteArrayInputStream in_stream = new ByteArrayInputStream(buffer);
            retval = DataSerializer.readObject(new DataInputStream(in_stream));
            if (retval == null) {
                return null;
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] objectToByteBuffer(Object obj) throws IOException {
        byte[] result = null;
        ByteArrayOutputStream byteArrayOutputStream = out_stream;
        synchronized (byteArrayOutputStream) {
            out_stream.reset();
            DataSerializer.writeObject(obj, new DataOutputStream(out_stream));
            result = out_stream.toByteArray();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Streamable streamableFromByteBuffer(Class cl, byte[] buffer) throws Exception {
        Object object = mutex;
        synchronized (object) {
            if (buffer == null) {
                return null;
            }
            Streamable retval = null;
            ByteArrayInputStream in_stream = new ByteArrayInputStream(buffer);
            DataInputStream in = new DataInputStream(in_stream);
            retval = (Streamable)cl.newInstance();
            retval.readFrom(in);
            in.close();
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] streamableToByteBuffer(Streamable obj) throws Exception {
        byte[] result = null;
        ByteArrayOutputStream byteArrayOutputStream = out_stream;
        synchronized (byteArrayOutputStream) {
            out_stream.reset();
            DataOutputStream out = new DataOutputStream(out_stream);
            obj.writeTo(out);
            result = out_stream.toByteArray();
            out.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] collectionToByteBuffer(Collection c) throws Exception {
        byte[] result = null;
        ByteArrayOutputStream byteArrayOutputStream = out_stream;
        synchronized (byteArrayOutputStream) {
            out_stream.reset();
            DataOutputStream out = new DataOutputStream(out_stream);
            Util.writeAddresses(c, out);
            result = out_stream.toByteArray();
            out.close();
        }
        return result;
    }

    public static int size(Address addr, short version) {
        int retval = 1;
        if (addr != null) {
            retval += addr.size(version) + 1;
        }
        return retval;
    }

    public static void writeAddress(Address addr, DataOutputStream out) throws IOException {
        if (addr == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        if (addr instanceof IpAddress) {
            out.writeBoolean(true);
            addr.writeTo(out);
        } else {
            out.writeBoolean(false);
            Util.writeOtherAddress(addr, out);
        }
    }

    public static Address readAddress(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        Address addr = null;
        if (!in.readBoolean()) {
            return null;
        }
        if (in.readBoolean()) {
            addr = new IpAddress();
            addr.readFrom(in);
        } else {
            addr = Util.readOtherAddress(in);
        }
        return addr;
    }

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"}, justification="the exception is logged")
    private static Address readOtherAddress(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        ClassConfigurator conf = null;
        try {
            conf = ClassConfigurator.getInstance(false);
        }
        catch (Exception e) {
            // empty catch block
        }
        int b = in.read();
        Class cl = null;
        if (b == 1) {
            int magic_number = in.readInt();
            cl = conf.get(magic_number);
        } else {
            String classname = in.readUTF();
            try {
                cl = conf.get(classname);
            }
            catch (Exception ce) {
                GemFireTracer.getLog(Util.class).error(JGroupsStrings.Util_UNABLE_TO_LOAD_CLASS_NAMED__0_, classname, (Throwable)ce);
            }
            if (cl == null) {
                GemFireTracer.getLog(Util.class).error(JGroupsStrings.Util_UNABLE_TO_LOAD_CLASS_NAMED__0_, classname, (Throwable)new Exception());
            }
        }
        Address addr = (Address)cl.newInstance();
        addr.readFrom(in);
        return addr;
    }

    @SuppressFBWarnings(value={"DE_MIGHT_IGNORE"}, justification="exception causes 'non-magic' serialization to be used")
    private static void writeOtherAddress(Address addr, DataOutputStream out) throws IOException {
        int magic_number;
        ClassConfigurator conf = null;
        try {
            conf = ClassConfigurator.getInstance(false);
        }
        catch (Exception e) {
            // empty catch block
        }
        int n = magic_number = conf != null ? conf.getMagicNumber(addr.getClass()) : -1;
        if (magic_number == -1) {
            out.write(0);
            out.writeUTF(addr.getClass().getName());
        } else {
            out.write(1);
            out.writeInt(magic_number);
        }
        addr.writeTo(out);
    }

    public static void writeAddresses(Collection v, DataOutputStream out) throws IOException {
        if (v == null) {
            out.writeShort(-1);
            return;
        }
        out.writeShort(v.size());
        for (Address addr : v) {
            Util.writeAddress(addr, out);
        }
    }

    public static Collection readAddresses(DataInputStream in, Class cl) throws IOException, IllegalAccessException, InstantiationException {
        int length = in.readShort();
        if (length < 0) {
            return null;
        }
        Collection retval = (Collection)cl.newInstance();
        for (int i = 0; i < length; ++i) {
            Address addr = Util.readAddress(in);
            retval.add(addr);
        }
        return retval;
    }

    public static long size(Collection addrs, short version) {
        int retval = 2;
        if (addrs != null && addrs.size() > 0) {
            Address addr = (Address)addrs.iterator().next();
            retval += addr.size(version) * addrs.size();
        }
        return retval;
    }

    public static void writeStreamable(Streamable obj, DataOutputStream out) throws IOException {
        if (obj == null) {
            out.writeBoolean(false);
            return;
        }
        out.writeBoolean(true);
        obj.writeTo(out);
    }

    public static Streamable readStreamable(Class clazz, DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        Streamable retval = null;
        if (!in.readBoolean()) {
            return null;
        }
        retval = (Streamable)clazz.newInstance();
        retval.readFrom(in);
        return retval;
    }

    public static void writeGenericStreamable(Streamable obj, DataOutputStream out) throws IOException {
        if (obj == null) {
            out.write(0);
            return;
        }
        try {
            out.write(1);
            int magic_number = ClassConfigurator.getInstance(false).getMagicNumber(obj.getClass());
            if (magic_number == -1) {
                out.write(0);
                String classname = obj.getClass().getName();
                out.writeUTF(classname);
            } else {
                out.write(1);
                out.writeInt(magic_number);
            }
            obj.writeTo(out);
        }
        catch (ChannelException e) {
            throw new IOException("failed writing object of type " + obj.getClass() + " to stream: " + e.toString());
        }
    }

    public static Streamable readGenericStreamable(DataInputStream in) throws IOException {
        Streamable retval = null;
        int b = in.read();
        if (b == 0) {
            return null;
        }
        int use_magic_number = in.read();
        try {
            Class clazz;
            if (use_magic_number == 1) {
                int magic_number = in.readInt();
                clazz = ClassConfigurator.getInstance(false).get(magic_number);
            } else {
                String classname = in.readUTF();
                clazz = ClassConfigurator.getInstance(false).get(classname);
            }
            retval = (Streamable)clazz.newInstance();
            retval.readFrom(in);
            return retval;
        }
        catch (Exception ex) {
            throw new IOException("failed reading object: " + ex.toString());
        }
    }

    public static void writeObject(Object obj, DataOutputStream out) throws IOException {
        if (obj == null || !(obj instanceof Streamable)) {
            byte[] buf = Util.objectToByteBuffer(obj);
            out.writeShort(buf.length);
            out.write(buf, 0, buf.length);
        } else {
            out.writeShort(-1);
            Util.writeGenericStreamable((Streamable)obj, out);
        }
    }

    public static Object readObject(DataInputStream in) throws IOException, ClassNotFoundException {
        short len = in.readShort();
        Object retval = null;
        if (len == -1) {
            retval = Util.readGenericStreamable(in);
        } else {
            byte[] buf = new byte[len];
            in.readFully(buf, 0, len);
            retval = Util.objectFromByteBuffer(buf);
        }
        return retval;
    }

    public static void writeString(String s, DataOutputStream out) throws IOException {
        if (s != null) {
            out.write(1);
            out.writeUTF(s);
        } else {
            out.write(0);
        }
    }

    public static String readString(DataInputStream in) throws IOException {
        int b = in.read();
        if (b == 1) {
            return in.readUTF();
        }
        return null;
    }

    public static void writeByteBuffer(byte[] buf, DataOutputStream out) throws IOException {
        if (buf != null) {
            out.write(1);
            out.writeInt(buf.length);
            out.write(buf, 0, buf.length);
        } else {
            out.write(0);
        }
    }

    public static byte[] readByteBuffer(DataInputStream in) throws IOException {
        int b = in.read();
        if (b == 1) {
            b = in.readInt();
            byte[] buf = new byte[b];
            if (buf.length != in.read(buf, 0, buf.length)) {
                throw new IOException("Failed to read " + buf.length + "bytes");
            }
            return buf;
        }
        return null;
    }

    public static Buffer msgListToByteBuffer(List xmit_list, Address dest) throws IOException {
        ExposedByteArrayOutputStream output = new ExposedByteArrayOutputStream(512);
        DataOutputStream out = new DataOutputStream(output);
        Buffer retval = null;
        out.writeInt(xmit_list.size());
        for (Message msg : xmit_list) {
            msg.setDest(null);
            msg.setVersion(dest.getVersionOrdinal());
            msg.writeTo(out);
        }
        out.flush();
        retval = new Buffer(output.getRawBuffer(), 0, output.size());
        out.close();
        output.close();
        return retval;
    }

    public static LinkedList byteBufferToMessageList(byte[] buffer, int offset, int length) throws Exception {
        LinkedList<Message> retval = null;
        ByteArrayInputStream input = new ByteArrayInputStream(buffer, offset, length);
        DataInputStream in = new DataInputStream(input);
        int size2 = in.readInt();
        if (size2 == 0) {
            return null;
        }
        retval = new LinkedList<Message>();
        for (int i = 0; i < size2; ++i) {
            Message msg = new Message(false);
            msg.readFrom(in);
            retval.add(msg);
        }
        return retval;
    }

    public static boolean match(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 != null) {
            return obj1.equals(obj2);
        }
        return obj2.equals(obj1);
    }

    public static boolean match(long[] a1, long[] a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1 == a2) {
            return true;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            if (a1[i] == a2[i]) continue;
            return false;
        }
        return true;
    }

    public static void sleep(long timeout) throws InterruptedException {
        Thread.sleep(timeout);
    }

    public static void sleep(long msecs, boolean busy_sleep) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!busy_sleep) {
            Util.sleep(msecs);
            return;
        }
        long start = System.currentTimeMillis();
        long stop = start + msecs;
        while (stop > start) {
            start = System.currentTimeMillis();
        }
    }

    public static long random(long range) {
        return (long)(Math.random() * 100000.0 % (double)range) + 1L;
    }

    public static void sleepRandom(long timeout) throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (timeout <= 0L) {
            return;
        }
        long r = (int)(Math.random() * 100000.0 % (double)timeout) + 1;
        Util.sleep(r);
    }

    public static boolean tossWeightedCoin(double probability) {
        long cutoff;
        long r = Util.random(100L);
        return r < (cutoff = (long)(probability * 100.0));
    }

    public static String getHostname() {
        try {
            return SocketCreator.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return "localhost";
        }
    }

    public static void dumpStack(boolean exit) {
        try {
            throw new Exception("Dumping stack:");
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
    }

    public static String dumpQueue(Queue q) {
        StringBuffer sb = new StringBuffer();
        LinkedList values = q.values();
        if (values.size() == 0) {
            sb.append("empty");
        } else {
            for (Object o : values) {
                String s = null;
                if (o instanceof Event) {
                    Event event = (Event)o;
                    int type = event.getType();
                    s = Event.type2String(type);
                    if (type == 6) {
                        s = s + " " + event.getArg();
                    }
                    if (type == 1) {
                        s = s + " " + event.getArg();
                    }
                    if (type == 1) {
                        s = s + "[";
                        Message m = (Message)event.getArg();
                        Map headers = m.getHeaders();
                        Iterator i = headers.entrySet().iterator();
                        while (i.hasNext()) {
                            Map.Entry entry = i.next();
                            Object headerKey = entry.getKey();
                            Object value2 = entry.getValue();
                            String headerToString = null;
                            if (value2 instanceof FD.FdHeader) {
                                headerToString = value2.toString();
                            } else if (value2 instanceof PingHeader) {
                                headerToString = headerKey + "-";
                                headerToString = ((PingHeader)value2).type == 1 ? headerToString + "GMREQ" : (((PingHeader)value2).type == 2 ? headerToString + "GMRSP" : headerToString + "UNKNOWN");
                            } else {
                                headerToString = headerKey + "-" + (value2 == null ? "null" : value2.toString());
                            }
                            s = s + headerToString;
                            if (!i.hasNext()) continue;
                            s = s + ",";
                        }
                        s = s + "]";
                    }
                } else {
                    s = o.toString();
                }
                sb.append(s).append("\n");
            }
        }
        return sb.toString();
    }

    public static String printStackTrace(Throwable t) {
        StringWriter s = new StringWriter();
        PrintWriter p = new PrintWriter(s);
        t.printStackTrace(p);
        return s.toString();
    }

    public static String getStackTrace(Throwable t) {
        return Util.printStackTrace(t);
    }

    public static String print(Throwable t) {
        return Util.printStackTrace(t);
    }

    public static void crash() {
    }

    public static String printEvent(Event evt) {
        Message msg;
        if (evt.getType() == 1 && (msg = (Message)evt.getArg()) != null) {
            if (msg.getLength() > 0) {
                return Util.printMessage(msg);
            }
            return msg.printObjectHeaders();
        }
        return evt.toString();
    }

    public static String printMessage(Message msg) {
        if (msg == null) {
            return "";
        }
        if (msg.getLength() == 0) {
            return null;
        }
        try {
            return msg.getObject().toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String printMethodCall(Message msg) {
        if (msg == null) {
            return "";
        }
        if (msg.getLength() == 0) {
            return "";
        }
        try {
            Object obj = msg.getObject();
            return obj.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    public static void printThreads() {
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        System.out.println("------- Threads -------");
        for (int i = 0; i < threads.length; ++i) {
            System.out.println("#" + i + ": " + threads[i]);
        }
        System.out.println("------- Threads -------\n");
    }

    public static String activeThreads() {
        StringBuffer sb = new StringBuffer();
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        sb.append("------- Threads -------\n");
        for (int i = 0; i < threads.length; ++i) {
            sb.append("#").append(i).append(": ").append(threads[i]).append('\n');
        }
        sb.append("------- Threads -------\n");
        return sb.toString();
    }

    public static String printBytes(long bytes) {
        if (bytes < 1000L) {
            return bytes + "b";
        }
        if (bytes < 1000000L) {
            double tmp = (double)bytes / 1000.0;
            return f.format(tmp) + "KB";
        }
        if (bytes < 1000000000L) {
            double tmp = (double)bytes / 1000000.0;
            return f.format(tmp) + "MB";
        }
        double tmp = (double)bytes / 1.0E9;
        return f.format(tmp) + "GB";
    }

    public static byte[][] fragmentBuffer(byte[] buf, int frag_size, int length) {
        int tmp_size = 0;
        int index2 = 0;
        int num_frags = length % frag_size == 0 ? length / frag_size : length / frag_size + 1;
        byte[][] retval = new byte[num_frags][];
        for (int accumulated_size = 0; accumulated_size < length; accumulated_size += tmp_size) {
            tmp_size = accumulated_size + frag_size <= length ? frag_size : length - accumulated_size;
            byte[] fragment = new byte[tmp_size];
            System.arraycopy(buf, accumulated_size, fragment, 0, tmp_size);
            retval[index2++] = fragment;
        }
        return retval;
    }

    public static byte[][] fragmentBuffer(byte[] buf, int frag_size) {
        return Util.fragmentBuffer(buf, frag_size, buf.length);
    }

    public static List computeFragOffsets(int offset, int length, int frag_size) {
        ArrayList<Range> retval = new ArrayList<Range>();
        long total_size = length + offset;
        int index2 = offset;
        int tmp_size = 0;
        while ((long)index2 < total_size) {
            tmp_size = (long)(index2 + frag_size) <= total_size ? frag_size : (int)(total_size - (long)index2);
            Range r = new Range(index2, tmp_size);
            retval.add(r);
            index2 += tmp_size;
        }
        return retval;
    }

    public static List computeFragOffsets(byte[] buf, int frag_size) {
        return Util.computeFragOffsets(0, buf.length, frag_size);
    }

    public static byte[] defragmentBuffer(byte[][] fragments) {
        int i;
        int total_length = 0;
        int index2 = 0;
        if (fragments == null) {
            return null;
        }
        for (i = 0; i < fragments.length; ++i) {
            if (fragments[i] == null) continue;
            total_length += fragments[i].length;
        }
        byte[] ret = new byte[total_length];
        for (i = 0; i < fragments.length; ++i) {
            if (fragments[i] == null) continue;
            System.arraycopy(fragments[i], 0, ret, index2, fragments[i].length);
            index2 += fragments[i].length;
        }
        return ret;
    }

    public static void printFragments(byte[][] frags) {
        for (int i = 0; i < frags.length; ++i) {
            System.out.println('\'' + new String(frags[i]) + '\'');
        }
    }

    public static String array2String(long[] array) {
        StringBuffer ret = new StringBuffer("[");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                ret.append(array[i]).append(" ");
            }
        }
        ret.append(']');
        return ret.toString();
    }

    public static String array2String(int[] array) {
        StringBuffer ret = new StringBuffer("[");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                ret.append(array[i]).append(" ");
            }
        }
        ret.append(']');
        return ret.toString();
    }

    public static String array2String(boolean[] array) {
        StringBuffer ret = new StringBuffer("[");
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                ret.append(array[i]).append(" ");
            }
        }
        ret.append(']');
        return ret.toString();
    }

    public static Vector pickSubset(Vector members, double subset_percentage) {
        Vector ret = new Vector();
        int num_mbrs = members.size();
        if (num_mbrs == 0) {
            return ret;
        }
        int subset_size = (int)Math.ceil((double)num_mbrs * subset_percentage);
        Vector tmp_mbrs = (Vector)members.clone();
        for (int i = subset_size; i > 0 && tmp_mbrs.size() > 0; --i) {
            int index2 = (int)(Math.random() * (double)num_mbrs % (double)tmp_mbrs.size());
            ret.addElement(tmp_mbrs.elementAt(index2));
            tmp_mbrs.removeElementAt(index2);
        }
        return ret;
    }

    public static Object pickRandomElement(Vector list) {
        if (list == null) {
            return null;
        }
        int size2 = list.size();
        int index2 = (int)(Math.random() * (double)size2 * 10.0 % (double)size2);
        return list.get(index2);
    }

    public static Vector determineLeftMembers(Vector old_mbrs, Vector new_mbrs) {
        Vector retval = new Vector();
        if (old_mbrs == null || new_mbrs == null) {
            return retval;
        }
        for (int i = 0; i < old_mbrs.size(); ++i) {
            Object mbr = old_mbrs.elementAt(i);
            if (new_mbrs.contains(mbr)) continue;
            retval.addElement(mbr);
        }
        return retval;
    }

    public static String printMembers(Vector v) {
        StringBuffer sb = new StringBuffer("(");
        boolean first = true;
        if (v != null) {
            for (int i = 0; i < v.size(); ++i) {
                if (!first) {
                    sb.append(", ");
                } else {
                    first = false;
                }
                Object el = v.elementAt(i);
                if (el instanceof Address) {
                    sb.append(el);
                    continue;
                }
                sb.append(el);
            }
        }
        sb.append(')');
        return sb.toString();
    }

    public static void doubleWrite(byte[] buf, OutputStream out) throws Exception {
        if (buf.length > 1) {
            out.write(buf, 0, 1);
            out.write(buf, 1, buf.length - 1);
        } else {
            out.write(buf, 0, 0);
            out.write(buf);
        }
    }

    public static void doubleWrite(byte[] buf, int offset, int length, OutputStream out) throws Exception {
        if (length > 1) {
            out.write(buf, offset, 1);
            out.write(buf, offset + 1, length - 1);
        } else {
            out.write(buf, offset, 0);
            out.write(buf, offset, length);
        }
    }

    public static void writeFully(ByteBuffer buf, WritableByteChannel out) throws IOException {
        int toWrite = buf.limit();
        for (int written = 0; written < toWrite; written += out.write(buf)) {
        }
    }

    public static long sizeOf(String classname) {
        try {
            Object inst = Util.loadClass(classname, null).newInstance();
            byte[] data = Util.objectToByteBuffer(inst);
            return data.length;
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    public static long sizeOf(Object inst) {
        try {
            byte[] data = Util.objectToByteBuffer(inst);
            return data.length;
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    public static long sizeOf(Streamable inst) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(output);
            inst.writeTo(out);
            out.flush();
            byte[] data = output.toByteArray();
            return data.length;
        }
        catch (Exception ex) {
            return -1L;
        }
    }

    public static Class loadClass(String classname, Class clazz) throws ClassNotFoundException {
        try {
            return ClassPathLoader.getLatest().forName(classname);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            ClassLoader loader;
            SystemFailure.checkFailure();
            if (clazz != null) {
                try {
                    loader = clazz.getClassLoader();
                    if (loader != null) {
                        return Class.forName(classname, false, loader);
                    }
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t2) {
                    SystemFailure.checkFailure();
                }
            }
            try {
                loader = ClassLoader.getSystemClassLoader();
                if (loader != null) {
                    return Class.forName(classname, false, loader);
                }
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t3) {
                SystemFailure.checkFailure();
            }
            throw new ClassNotFoundException(classname);
        }
    }

    public static InputStream getResourceAsStream(String name, Class clazz) {
        try {
            return ClassPathLoader.getLatest().getResourceAsStream(name);
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable t) {
            ClassLoader loader;
            SystemFailure.checkFailure();
            if (clazz != null) {
                try {
                    loader = clazz.getClassLoader();
                    if (loader != null) {
                        return loader.getResourceAsStream(name);
                    }
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t2) {
                    SystemFailure.checkFailure();
                }
            }
            try {
                loader = ClassLoader.getSystemClassLoader();
                if (loader != null) {
                    return loader.getResourceAsStream(name);
                }
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t3) {
                SystemFailure.checkFailure();
            }
            return null;
        }
    }

    public static boolean sameHost(Address one, Address two) {
        if (one == null || two == null) {
            return false;
        }
        if (!(one instanceof IpAddress) || !(two instanceof IpAddress)) {
            return false;
        }
        InetAddress a = ((IpAddress)one).getIpAddress();
        InetAddress b = ((IpAddress)two).getIpAddress();
        if (a == null || b == null) {
            return false;
        }
        String host_a = a.getHostAddress();
        String host_b = b.getHostAddress();
        return host_a.equals(host_b);
    }

    public static boolean fileExists(String fname) {
        return new File(fname).exists();
    }

    public static long[] parseCommaDelimitedLongs(String s) {
        Vector<Long> v = new Vector<Long>();
        long[] retval = null;
        if (s == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(s, ",");
        while (tok.hasMoreTokens()) {
            Long l = Long.valueOf(tok.nextToken());
            v.addElement(l);
        }
        if (v.size() == 0) {
            return null;
        }
        retval = new long[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            retval[i] = (Long)v.elementAt(i);
        }
        return retval;
    }

    public static List parseCommaDelimitedStrings(String l) {
        ArrayList<String> tmp = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(l, ",");
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            tmp.add(t);
        }
        return tmp;
    }

    public static String shortName(String hostname) {
        StringBuffer sb = new StringBuffer();
        if (hostname == null) {
            return null;
        }
        int index2 = hostname.indexOf(46);
        if (index2 > 0 && !Character.isDigit(hostname.charAt(0))) {
            sb.append(hostname.substring(0, index2));
        } else {
            sb.append(hostname);
        }
        return sb.toString();
    }

    public static String shortName(InetAddress hostname) {
        if (hostname == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        if (IpAddress.resolve_dns) {
            sb.append(hostname.getHostName());
        } else {
            sb.append(hostname.getHostAddress());
        }
        return sb.toString();
    }

    public static ServerSocket createServerSocket(int start_port) {
        ServerSocket ret = null;
        String bindAddress = System.getProperty("gemfire.jg-bind-address");
        while (true) {
            try {
                if (bindAddress != null && bindAddress.length() > 0) {
                    InetAddress bind_addr = InetAddress.getByName(bindAddress);
                    ret = new ServerSocket(start_port, 50, bind_addr);
                    break;
                }
                ret = new ServerSocket(start_port);
            }
            catch (SocketException bind_ex) {
                if (!Util.treatAsBindException(bind_ex)) break;
                ++start_port;
                continue;
            }
            catch (IOException iOException) {
            }
            break;
        }
        return ret;
    }

    public static ServerSocket createServerSocket(InetAddress bind_addr, int start_port, int end_port) {
        int localPort;
        ServerSocket ret = null;
        SecureRandom rand = new SecureRandom();
        int startingLocalPort = localPort = start_port == end_port ? start_port : start_port + rand.nextInt(end_port - start_port + 1);
        int lastPortInRange = end_port;
        while (true) {
            if (localPort > lastPortInRange) {
                if (startingLocalPort != 0) {
                    localPort = start_port;
                    lastPortInRange = startingLocalPort - 1;
                    startingLocalPort = 0;
                } else {
                    throw new SystemConnectException(JGroupsStrings.UNABLE_TO_FIND_FREE_PORT.toLocalizedString());
                }
            }
            try {
                ret = new ServerSocket(localPort, 1, bind_addr);
            }
            catch (SocketException bind_ex) {
                if (!Util.treatAsBindException(bind_ex)) continue;
                ++localPort;
                continue;
            }
            catch (IOException io_ex) {
            }
            break;
        }
        return ret;
    }

    public static DatagramSocket createDatagramSocket(InetAddress addr, int port) throws Exception {
        DatagramSocket sock = null;
        if (addr == null) {
            if (port == 0) {
                return new DatagramSocket();
            }
            while (port < 65535) {
                try {
                    return new DatagramSocket(port);
                }
                catch (SocketException bind_ex) {
                    if (Util.treatAsBindException(bind_ex)) {
                        ++port;
                        continue;
                    }
                    throw bind_ex;
                }
                catch (Exception ex) {
                    throw ex;
                }
            }
        } else {
            if (port == 0) {
                port = 1024;
            }
            while (port < 65535) {
                try {
                    return new DatagramSocket(port, addr);
                }
                catch (SocketException bind_ex) {
                    if (Util.treatAsBindException(bind_ex)) {
                        ++port;
                        continue;
                    }
                    throw bind_ex;
                }
                catch (Exception ex) {
                    throw ex;
                }
            }
        }
        return sock;
    }

    public static boolean checkForAIX() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("aix");
    }

    public static boolean checkForLinux() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("linux");
    }

    public static boolean checkForSolaris() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("sun");
    }

    public static boolean checkForWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.toLowerCase().startsWith("win");
    }

    public static void prompt(String s) {
        System.out.println(s);
        System.out.flush();
        try {
            while (System.in.available() > 0) {
                System.in.read();
            }
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static int getJavaVersion() {
        String version = System.getProperty("java.version");
        int retval = 0;
        if (version != null) {
            if (version.startsWith("1.2")) {
                return 12;
            }
            if (version.startsWith("1.3")) {
                return 13;
            }
            if (version.startsWith("1.4")) {
                return 14;
            }
            if (version.startsWith("1.5")) {
                return 15;
            }
            if (version.startsWith("5")) {
                return 15;
            }
            if (version.startsWith("1.6")) {
                return 16;
            }
            if (version.startsWith("6")) {
                return 16;
            }
        }
        return retval;
    }

    public static InetAddress getFirstNonLoopbackAddress() throws SocketException {
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        boolean preferIPv6 = Boolean.getBoolean("java.net.preferIPv6Addresses");
        while (en.hasMoreElements()) {
            NetworkInterface i = en.nextElement();
            Enumeration<InetAddress> en2 = i.getInetAddresses();
            while (en2.hasMoreElements()) {
                InetAddress addr = en2.nextElement();
                if (addr.isLoopbackAddress() || !(addr instanceof Inet4Address) || preferIPv6) continue;
                return addr;
            }
        }
        return null;
    }

    public static List getAllAvailableInterfaces() throws SocketException {
        ArrayList<NetworkInterface> retval = new ArrayList<NetworkInterface>(10);
        Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
        while (en.hasMoreElements()) {
            NetworkInterface intf = en.nextElement();
            retval.add(intf);
        }
        return retval;
    }

    public static boolean isBindAddressPropertyIgnored() {
        String tmp = System.getProperty(IGNORE_BIND_ADDRESS_PROPERTY);
        if (tmp == null) {
            return false;
        }
        return !(tmp = tmp.trim().toLowerCase()).equals("false") && !tmp.equals("no") && !tmp.equals("off");
    }

    public static void main(String[] args) throws Exception {
        ClassConfigurator.getInstance(true);
        Message msg = new Message(null, (Address)new IpAddress("127.0.0.1", 4444), (Serializable)((Object)"Bela"));
        long size2 = Util.sizeOf(msg);
        System.out.println("size=" + msg.size() + ", streamable size=" + size2);
        msg.putHeader("belaban", new NakAckHeader(1, 23L, 34L));
        size2 = Util.sizeOf(msg);
        System.out.println("size=" + msg.size() + ", streamable size=" + size2);
        msg.putHeader("bla", new UdpHeader("groupname"));
        size2 = Util.sizeOf(msg);
        System.out.println("size=" + msg.size() + ", streamable size=" + size2);
        IpAddress a1 = new IpAddress(1234);
        IpAddress a2 = new IpAddress("127.0.0.1", 3333);
        a1.setAdditionalData("Bela".getBytes());
        size2 = Util.sizeOf(a1);
        System.out.println("size=" + a1.size(Version.CURRENT_ORDINAL) + ", streamable size of a1=" + size2);
        size2 = Util.sizeOf(a2);
        System.out.println("size=" + a2.size(Version.CURRENT_ORDINAL) + ", streamable size of a2=" + size2);
    }

    public static boolean treatAsBindException(SocketException se) {
        if (se instanceof BindException) {
            return true;
        }
        String msg = se.getMessage();
        return msg != null && msg.contains("Invalid argument: listen failed");
    }

    static {
        f.setGroupingUsed(false);
        f.setMaximumFractionDigits(2);
    }
}

