/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.util;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

public class TimedWriter {
    Thread thread = null;
    long timeout = 2000L;
    boolean completed = true;
    Exception write_ex = null;
    Socket sock = null;
    static GemFireTracer log = GemFireTracer.getLog(TimedWriter.class);

    void start(InetAddress local2, InetAddress remote, int peer_port) {
        this.stop();
        this.thread = new SocketCreator(local2, remote, peer_port);
        this.thread.start();
    }

    void start(OutputStream out, byte[] buf) {
        this.stop();
        this.thread = new WriterThread(out, buf);
        this.thread.start();
    }

    void start(OutputStream out, int i) {
        this.stop();
        this.thread = new WriterThread(out, i);
        this.thread.start();
    }

    void stop() {
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.interrupt();
            try {
                this.thread.join(this.timeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(OutputStream out, byte[] buf, long timeout) throws Exception, Timeout, InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (out == null || buf == null) {
            log.error(JGroupsStrings.TimedWriter_TIMEDWRITERWRITE_OUTPUT_STREAM_OR_BUFFER_IS_NULL_IGNORING_WRITE);
            return;
        }
        try {
            this.timeout = timeout;
            this.completed = false;
            this.start(out, buf);
            if (this.thread == null) {
                return;
            }
            this.thread.join(timeout);
            if (!this.completed) {
                throw new Timeout();
            }
            if (this.write_ex != null) {
                Exception tmp = this.write_ex;
                this.write_ex = null;
                throw tmp;
            }
        }
        finally {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void write(OutputStream out, int i, long timeout) throws Exception, Timeout, InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (out == null) {
            log.error(JGroupsStrings.TimedWriter_TIMEDWRITERWRITE_OUTPUT_STREAM_IS_NULL_IGNORING_WRITE);
            return;
        }
        try {
            this.timeout = timeout;
            this.completed = false;
            this.start(out, i);
            if (this.thread == null) {
                return;
            }
            this.thread.join(timeout);
            if (!this.completed) {
                throw new Timeout();
            }
            if (this.write_ex != null) {
                Exception tmp = this.write_ex;
                this.write_ex = null;
                throw tmp;
            }
        }
        finally {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Socket createSocket(InetAddress local2, InetAddress remote, int port, long timeout) throws Exception, Timeout, InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        try {
            this.timeout = timeout;
            this.completed = false;
            this.start(local2, remote, port);
            if (this.thread == null) {
                Socket socket = null;
                return socket;
            }
            this.thread.join(timeout);
            if (!this.completed) {
                throw new Timeout();
            }
            if (this.write_ex != null) {
                Exception tmp = this.write_ex;
                this.write_ex = null;
                throw tmp;
            }
            Socket socket = this.sock;
            return socket;
        }
        finally {
            this.stop();
        }
    }

    class SocketCreator
    extends Thread {
        InetAddress local = null;
        InetAddress remote = null;
        int peer_port = 0;

        public SocketCreator(InetAddress local2, InetAddress remote, int peer_port) {
            this.local = local2;
            this.remote = remote;
            this.peer_port = peer_port;
        }

        @Override
        public void run() {
            TimedWriter.this.completed = false;
            TimedWriter.this.sock = null;
            try {
                TimedWriter.this.sock = new Socket(this.remote, this.peer_port, this.local, 0);
            }
            catch (IOException io_ex) {
                TimedWriter.this.write_ex = io_ex;
            }
            TimedWriter.this.completed = true;
        }
    }

    class WriterThread
    extends Thread {
        DataOutputStream out = null;
        byte[] buf = null;
        int i = 0;

        public WriterThread(OutputStream out, byte[] buf) {
            this.out = new DataOutputStream(out);
            this.buf = buf;
            this.setName("TimedWriter.WriterThread");
        }

        public WriterThread(OutputStream out, int i) {
            this.out = new DataOutputStream(out);
            this.i = i;
            this.setName("TimedWriter.WriterThread");
        }

        @Override
        public void run() {
            try {
                if (this.buf != null) {
                    this.out.write(this.buf);
                } else {
                    this.out.writeInt(this.i);
                }
            }
            catch (IOException e) {
                TimedWriter.this.write_ex = e;
            }
            TimedWriter.this.completed = true;
        }
    }

    static class Timeout
    extends Exception {
        private static final long serialVersionUID = -7263515891440595522L;

        Timeout() {
        }

        @Override
        public String toString() {
            return "TimedWriter.Timeout";
        }
    }
}

