/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.util;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Queue;
import com.gemstone.org.jgroups.util.QueueClosedException;
import com.gemstone.org.jgroups.util.ReusableThread;
import com.gemstone.org.jgroups.util.SchedulerListener;
import com.gemstone.org.jgroups.util.ThreadPool;
import com.gemstone.org.jgroups.util.Util;

public class Scheduler
implements Runnable {
    final Queue queue = new Queue();
    Thread sched_thread = null;
    Task current_task = null;
    ThreadPool pool = null;
    SchedulerListener listener = null;
    protected static final GemFireTracer log = GemFireTracer.getLog(Scheduler.class);
    boolean concurrent_processing = false;
    int NUM_THREADS = 128;
    static final int WAIT_FOR_THREAD_AVAILABILITY = 3000;
    static final int THREAD_JOIN_TIMEOUT = 1000;

    public Scheduler() {
        try {
            this.NUM_THREADS = Integer.parseInt(System.getProperty("scheduler.max.threads", "128"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public Scheduler(int num_threads) {
        this.NUM_THREADS = num_threads;
    }

    public void setListener(SchedulerListener l) {
        this.listener = l;
    }

    public boolean getConcurrentProcessing() {
        return this.concurrent_processing;
    }

    public void setConcurrentProcessing(boolean process_concurrently) {
        this.concurrent_processing = process_concurrently;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            SystemFailure.checkFailure();
            if (this.queue.closed()) break;
            try {
                this.current_task = (Task)this.queue.peek();
                if (this.current_task == null) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn("current task is null, queue.size()=" + this.queue.size() + ", queue.closed()=" + this.queue.closed() + ", continuing");
                    continue;
                }
                if (this.current_task.suspended) {
                    this.current_task.suspended = false;
                    this.current_task.thread.resume();
                    if (this.listener != null) {
                        this.listener.resumed(this.current_task.target);
                    }
                } else {
                    if (this.current_task.thread == null) {
                        this.current_task.thread = this.pool.getThread();
                        if (this.current_task.thread == null) {
                            if (log.isWarnEnabled()) {
                                log.warn("thread pool exhausted, waiting for 3000ms before retrying");
                            }
                            Util.sleep(3000L);
                            continue;
                        }
                    }
                    if (this.listener != null) {
                        this.listener.started(this.current_task.target);
                    }
                    if (!this.current_task.thread.assignTask(this.current_task.target)) continue;
                }
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                if (!this.concurrent_processing) {
                    ReusableThread reusableThread = this.current_task.thread;
                    synchronized (reusableThread) {
                        while (!this.current_task.thread.done() && !this.current_task.thread.suspended) {
                            this.current_task.thread.wait();
                        }
                    }
                    if (this.listener != null) {
                        this.listener.stopped(this.current_task.target);
                    }
                }
                this.queue.removeElement(this.current_task);
                continue;
            }
            catch (InterruptedException interrupted) {
                if (this.queue.closed()) break;
                if (this.current_task.thread != null) {
                    this.current_task.thread.suspend();
                    if (this.listener != null) {
                        this.listener.suspended(this.current_task.target);
                    }
                    this.current_task.suspended = true;
                }
                Thread.interrupted();
                continue;
            }
            catch (QueueClosedException closed_ex) {
                return;
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable ex) {
                SystemFailure.checkFailure();
                if (!log.isErrorEnabled()) continue;
                log.error(JGroupsStrings.Scheduler_EXCEPTION_0, Util.print(ex));
                continue;
            }
            break;
        }
        if (log.isTraceEnabled()) {
            log.trace("scheduler thread terminated");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPrio(Runnable task) {
        block12: {
            Task new_task = new Task(task);
            boolean do_interrupt = false;
            try {
                Object object = this.queue;
                synchronized (object) {
                    if (this.queue.size() == 0) {
                        this.queue.add(new_task);
                    } else {
                        this.queue.addAtHead(new_task);
                        do_interrupt = true;
                    }
                }
                if (!do_interrupt) break block12;
                object = this;
                synchronized (object) {
                    if (this.sched_thread != null) {
                        this.sched_thread.interrupt();
                    }
                }
            }
            catch (VirtualMachineError err) {
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable e) {
                SystemFailure.checkFailure();
                if (!log.isErrorEnabled()) break block12;
                log.error(JGroupsStrings.Scheduler_EXCEPTION_0, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Runnable task) {
        block5: {
            Task new_task = new Task(task);
            try {
                Queue queue = this.queue;
                synchronized (queue) {
                    this.queue.add(new_task);
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block5;
                log.error(JGroupsStrings.Scheduler_EXCEPTION_0, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.queue.closed()) {
            this.queue.reset();
        }
        Scheduler scheduler = this;
        synchronized (scheduler) {
            if (this.sched_thread == null) {
                this.pool = new ThreadPool(this.NUM_THREADS);
                this.sched_thread = new Thread((Runnable)this, "Scheduler main thread");
                this.sched_thread.setDaemon(true);
                this.sched_thread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Thread tmp = null;
        this.queue.close(false);
        Scheduler scheduler = this;
        synchronized (scheduler) {
            if (this.sched_thread != null && this.sched_thread.isAlive()) {
                tmp = this.sched_thread;
                this.sched_thread = null;
                tmp.interrupt();
                try {
                    tmp.join(1000L);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                if (tmp.isAlive() && log.isErrorEnabled()) {
                    log.error(JGroupsStrings.Scheduler_SCHEDULER_THREAD_IS_STILL_NOT_DEAD__);
                }
            }
            this.sched_thread = null;
        }
        if (this.pool != null) {
            this.pool.destroy();
            this.pool = null;
        }
    }

    public static class Task {
        ReusableThread thread = null;
        Runnable target = null;
        boolean suspended = false;

        Task(Runnable target) {
            this.target = target;
        }

        public String toString() {
            return "[thread=" + this.thread + ", target=" + this.target + ", suspended=" + this.suspended + ']';
        }
    }
}

