/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.util;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.util.GemFireTracer;

public class ReusableThread
implements Runnable {
    volatile Thread thread = null;
    Runnable task = null;
    String thread_name = "ReusableThread";
    volatile boolean suspended = false;
    protected static final GemFireTracer log = GemFireTracer.getLog(ReusableThread.class);
    final long TASK_JOIN_TIME = 3000L;

    public ReusableThread() {
    }

    public ReusableThread(String thread_name) {
        this.thread_name = thread_name;
    }

    public boolean done() {
        return this.task == null;
    }

    public boolean available() {
        return this.done();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive() {
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            return this.thread != null && this.thread.isAlive();
        }
    }

    public void start() {
        if (this.thread == null || this.thread != null && !this.thread.isAlive()) {
            this.thread = new Thread((Runnable)this, this.thread_name);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Thread tmp = null;
        if (log.isTraceEnabled()) {
            log.trace("entering THIS");
        }
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            if (log.isTraceEnabled()) {
                log.trace("entered THIS (thread=" + this.printObj(this.thread) + ", task=" + this.printObj(this.task) + ", suspended=" + this.suspended + ')');
            }
            if (this.thread != null && this.thread.isAlive()) {
                tmp = this.thread;
                this.thread = null;
                this.task = null;
                if (log.isTraceEnabled()) {
                    log.trace("notifying thread");
                }
                this.notifyAll();
                if (log.isTraceEnabled()) {
                    log.trace("notifying thread completed");
                }
            }
            this.thread = null;
            this.task = null;
        }
        if (tmp != null && tmp.isAlive()) {
            long s1 = System.currentTimeMillis();
            long s2 = 0L;
            if (log.isTraceEnabled()) {
                log.trace("join(3000)");
            }
            tmp.interrupt();
            try {
                tmp.join(3000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            s2 = System.currentTimeMillis();
            if (log.isTraceEnabled()) {
                log.trace("join(3000) completed in " + (s2 - s1));
            }
            if (tmp.isAlive() && log.isErrorEnabled()) {
                log.error(JGroupsStrings.ReusableThread_THREAD_IS_STILL_ALIVE);
            }
            tmp = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            if (log.isTraceEnabled()) {
                log.trace("suspended=" + this.suspended + ", task=" + this.printObj(this.task));
            }
            if (this.suspended) {
                return;
            }
            this.suspended = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            this.suspended = false;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean assignTask(Runnable t) {
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            this.start();
            if (this.task == null) {
                this.task = t;
                this.notifyAll();
                return true;
            }
            if (log.isErrorEnabled()) {
                log.error("already working on a thread: current_task=" + this.task + ", new task=" + t + ", thread=" + this.thread + ", is alive=" + (this.thread != null ? "" + this.thread.isAlive() : "null"));
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.thread != null) {
            ReusableThread reusableThread;
            SystemFailure.checkFailure();
            try {
                if (log.isTraceEnabled()) {
                    log.trace("entering ASSIGN");
                }
                reusableThread = this;
                synchronized (reusableThread) {
                    if (log.isTraceEnabled()) {
                        log.trace("entered ASSIGN (task=" + this.printObj(this.task) + ", thread=" + this.printObj(this.thread) + ')');
                    }
                    while (this.task == null && this.thread != null) {
                        if (log.isTraceEnabled()) {
                            log.trace("wait ASSIGN");
                        }
                        this.wait();
                        if (!log.isTraceEnabled()) continue;
                        log.trace("wait ASSIGN completed");
                    }
                }
            }
            catch (InterruptedException ex) {
                if (!log.isTraceEnabled()) break;
                log.trace("interrupt on ASSIGN");
                break;
            }
            if (this.thread == null) {
                return;
            }
            try {
                if (log.isTraceEnabled()) {
                    log.trace("entering SUSPEND");
                }
                ReusableThread ex = this;
                synchronized (ex) {
                    if (log.isTraceEnabled()) {
                        log.trace("entered SUSPEND (suspended=" + this.suspended + ", task=" + this.printObj(this.task) + ')');
                    }
                    while (this.suspended && this.thread != null) {
                        if (log.isTraceEnabled()) {
                            log.trace("wait SUSPEND");
                        }
                        this.wait();
                        if (!log.isTraceEnabled()) continue;
                        log.trace("wait SUSPEND completed");
                    }
                }
            }
            catch (InterruptedException ex) {
                if (!log.isTraceEnabled()) break;
                log.trace("interrupt on RESUME");
                break;
            }
            if (this.thread == null) {
                return;
            }
            if (this.task != null) {
                block37: {
                    if (log.isTraceEnabled()) {
                        log.trace("running task");
                    }
                    try {
                        this.task.run();
                    }
                    catch (VirtualMachineError err) {
                        SystemFailure.initiateFailure(err);
                        throw err;
                    }
                    catch (Throwable ex) {
                        SystemFailure.checkFailure();
                        if (!log.isErrorEnabled()) break block37;
                        log.error(JGroupsStrings.ReusableThread_FAILED_RUNNING_TASK, ex);
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace("task completed");
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("entering THIS");
            }
            reusableThread = this;
            synchronized (reusableThread) {
                if (log.isTraceEnabled()) {
                    log.trace("entered THIS");
                }
                this.task = null;
                if (log.isTraceEnabled()) {
                    log.trace("notify THIS");
                }
                this.notifyAll();
                if (log.isTraceEnabled()) {
                    log.trace("notify THIS completed");
                }
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("terminated");
        }
    }

    String printObj(Object obj) {
        if (obj == null) {
            return "null";
        }
        return "non-null";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilDone() {
        if (log.isTraceEnabled()) {
            log.trace("entering THIS");
        }
        ReusableThread reusableThread = this;
        synchronized (reusableThread) {
            if (log.isTraceEnabled()) {
                log.trace("entered THIS (task=" + this.printObj(this.task) + ')');
            }
            while (this.task != null) {
                boolean interrupted = Thread.interrupted();
                try {
                    if (log.isTraceEnabled()) {
                        log.trace("wait THIS");
                    }
                    this.wait();
                    if (!log.isTraceEnabled()) continue;
                    log.trace("wait THIS completed");
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    break;
                }
                finally {
                    if (!interrupted) continue;
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public String toString() {
        return "suspended=" + this.suspended;
    }
}

