/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.util;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.org.jgroups.oswego.concurrent.Executor;
import com.gemstone.org.jgroups.oswego.concurrent.PooledExecutor;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

@SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GemFire doesn't use this class")
public class Proxy {
    InetAddress local = null;
    InetAddress remote = null;
    int local_port = 0;
    int remote_port = 0;
    static boolean verbose = false;
    static boolean debug = false;
    String mapping_file = null;
    final HashMap mappings = new HashMap();
    Executor executor;
    static final int MAX_THREAD_POOL_SIZE = 64;
    static final int BUFSIZE = 1024;

    public Proxy(InetAddress local2, int local_port, InetAddress remote, int remote_port, boolean verbose, boolean debug2) {
        this.local = local2;
        this.local_port = local_port;
        this.remote = remote;
        this.remote_port = remote_port;
        Proxy.verbose = verbose;
        debug = debug2;
    }

    public Proxy(InetAddress local2, int local_port, InetAddress remote, int remote_port, boolean verbose, boolean debug2, String mapping_file) {
        this(local2, local_port, remote, remote_port, verbose, debug2);
        this.mapping_file = mapping_file;
    }

    public void start() throws Exception {
        if (this.remote != null && this.local != null) {
            this.mappings.put(new InetSocketAddress(this.local, this.local_port), new InetSocketAddress(this.remote, this.remote_port));
        }
        if (this.mapping_file != null) {
            try {
                this.populateMappings(this.mapping_file);
            }
            catch (Exception ex) {
                Proxy.log("Failed reading " + this.mapping_file);
                throw ex;
            }
        }
        Proxy.log("\nProxy started at " + new Date());
        if (verbose) {
            Proxy.log("\nMappings:\n---------");
            for (Map.Entry entry : this.mappings.entrySet()) {
                Proxy.log(this.toString((InetSocketAddress)entry.getKey()) + " <--> " + this.toString((InetSocketAddress)entry.getValue()));
            }
            Proxy.log("\n");
        }
        Selector selector = Selector.open();
        this.executor = new PooledExecutor(64);
        for (MyInetSocketAddress key2 : this.mappings.keySet()) {
            MyInetSocketAddress value2 = (MyInetSocketAddress)this.mappings.get(key2);
            if (key2.ssl() || value2.ssl()) {
                SocketAcceptor acceptor = new SocketAcceptor(key2, value2);
                this.executor.execute(acceptor);
                continue;
            }
            ServerSocketChannel sock_channel = ServerSocketChannel.open();
            sock_channel.configureBlocking(false);
            sock_channel.socket().bind(key2);
            sock_channel.register(selector, 16, key2);
        }
        this.loop(selector);
    }

    /*
     * Unable to fully structure code
     */
    void loop(Selector selector) {
        block4: while (true) {
            if (Proxy.verbose) {
                Proxy.log("[Proxy] ready to accept connection");
            }
            try {
                selector.select();
                ready_keys = selector.selectedKeys();
                it = ready_keys.iterator();
                while (true) lbl-1000:
                // 4 sources

                {
                    if (!it.hasNext()) continue block4;
                    key = it.next();
                    it.remove();
                    if (!key.isAcceptable()) continue;
                    srv_sock = (ServerSocketChannel)key.channel();
                    src = (InetSocketAddress)key.attachment();
                    in_sock = srv_sock.accept();
                    if (Proxy.verbose) {
                        Proxy.log("Proxy.loop()", "accepted connection from " + this.toString(in_sock));
                    }
                    if ((dest = (InetSocketAddress)this.mappings.get(src)) == null) {
                        in_sock.close();
                        Proxy.log("Proxy.loop()", "did not find a destination host for " + src);
                        continue;
                    }
                    if (Proxy.verbose) {
                        Proxy.log("Proxy.loop()", "relaying traffic from " + this.toString(src) + " to " + this.toString(dest));
                    }
                    try {
                        out_sock = SocketChannel.open(dest);
                        this.handleConnection(in_sock, out_sock);
                        continue;
                    }
                    catch (Exception ex) {
                        in_sock.close();
                        throw ex;
                    }
                    break;
                }
            }
            catch (Exception ex) {
                Proxy.log("Proxy.loop()", "exception: " + ex);
                continue;
            }
            {
                ** while (true)
            }
            break;
        }
    }

    void handleConnection(SocketChannel in, SocketChannel out) {
        try {
            this._handleConnection(in, out);
        }
        catch (Exception ex) {
            Proxy.log("Proxy.handleConnection()", "exception: " + ex);
        }
    }

    void _handleConnection(final SocketChannel in_channel, final SocketChannel out_channel) throws Exception {
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Selector sel = null;
                ByteBuffer transfer_buf = ByteBuffer.allocate(1024);
                try {
                    sel = Selector.open();
                    in_channel.configureBlocking(false);
                    out_channel.configureBlocking(false);
                    in_channel.register(sel, 1);
                    out_channel.register(sel, 1);
                    while (sel.select() > 0) {
                        SystemFailure.checkFailure();
                        Set<SelectionKey> ready_keys = sel.selectedKeys();
                        Iterator<SelectionKey> it = ready_keys.iterator();
                        while (it.hasNext()) {
                            SelectionKey key2 = it.next();
                            it.remove();
                            SocketChannel tmp = (SocketChannel)key2.channel();
                            if (tmp == null) {
                                Proxy.log("Proxy._handleConnection()", "attachment is null, continuing");
                                continue;
                            }
                            if (!key2.isReadable()) continue;
                            if (tmp == in_channel && !Proxy.this.relay(tmp, out_channel, transfer_buf)) {
                                return;
                            }
                            if (tmp != out_channel || Proxy.this.relay(tmp, in_channel, transfer_buf)) continue;
                            return;
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return;
                }
                finally {
                    Proxy.this.close(sel, in_channel, out_channel);
                }
            }
        });
    }

    void close(Selector sel, SocketChannel in_channel, SocketChannel out_channel) {
        try {
            if (sel != null) {
                sel.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (in_channel != null) {
                in_channel.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        try {
            if (out_channel != null) {
                out_channel.close();
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    boolean relay(SocketChannel from, SocketChannel to, ByteBuffer buf) throws Exception {
        buf.clear();
        int num;
        while ((num = from.read(buf)) >= 0) {
            if (num == 0) {
                return true;
            }
            buf.flip();
            if (verbose) {
                Proxy.log(Proxy.printRelayedData(this.toString(from), this.toString(to), buf.remaining()));
            }
            if (debug) {
                StringBuffer sb = new StringBuffer();
                sb.append(new String(buf.array()).trim());
                sb.append('\n');
                Proxy.log(sb.toString());
            }
            to.write(buf);
            buf.flip();
        }
        return false;
    }

    String toString(SocketChannel ch) {
        StringBuffer sb = new StringBuffer();
        if (ch == null) {
            return null;
        }
        Socket sock = ch.socket();
        if (sock == null) {
            return null;
        }
        sb.append(sock.getInetAddress().getHostName()).append(':').append(sock.getPort());
        return sb.toString();
    }

    String toString(InetSocketAddress addr) {
        StringBuffer sb = new StringBuffer();
        if (addr == null) {
            return null;
        }
        sb.append(addr.getAddress().getHostName()).append(':').append(addr.getPort());
        if (addr instanceof MyInetSocketAddress) {
            sb.append(" [ssl=").append(((MyInetSocketAddress)addr).ssl()).append(']');
        }
        return sb.toString();
    }

    static String printRelayedData(String from, String to, int num_bytes) {
        StringBuffer sb = new StringBuffer();
        sb.append("\n[PROXY] ").append(from);
        sb.append(" to ").append(to);
        sb.append(" (").append(num_bytes).append(" bytes)");
        return sb.toString();
    }

    void populateMappings(String filename) throws Exception {
        String line;
        FileInputStream in = new FileInputStream(filename);
        String HTTPS = "https";
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).startsWith("//") || line.startsWith("#") || line.length() == 0) continue;
            int index2 = line.indexOf(61);
            if (index2 == -1) {
                throw new Exception("Proxy.populateMappings(): detected no '=' character in " + line);
            }
            URI key2 = new URI(line.substring(0, index2));
            boolean ssl_key = key2.getScheme().trim().equals("https");
            URI value2 = new URI(line.substring(index2 + 1));
            boolean ssl_value = value2.getScheme().trim().equals("https");
            this.check(key2);
            this.check(value2);
            Proxy.log("key: " + key2 + ", value: " + value2);
            this.mappings.put(new MyInetSocketAddress(key2.getHost(), key2.getPort(), ssl_key), new MyInetSocketAddress(value2.getHost(), value2.getPort(), ssl_value));
        }
        in.close();
    }

    void check(URI u) throws Exception {
        if (u.getScheme() == null) {
            throw new Exception("scheme is null in " + u + ", (valid URI is \"http(s)://<host>:<port>\")");
        }
        if (u.getHost() == null) {
            throw new Exception("host is null in " + u + ", (valid URI is \"http(s)://<host>:<port>\")");
        }
        if (u.getPort() <= 0) {
            throw new Exception("port is <=0 in " + u + ", (valid URI is \"http(s)://<host>:<port>\")");
        }
    }

    SocketAddress strToAddr(String input) throws Exception {
        StringTokenizer tok = new StringTokenizer(input, ":");
        String host = tok.nextToken();
        String port = tok.nextToken();
        return new InetSocketAddress(host, Integer.parseInt(port));
    }

    String printSelectionOps(SelectionKey key2) {
        StringBuffer sb = new StringBuffer();
        if ((key2.readyOps() & 0x10) != 0) {
            sb.append("OP_ACCEPT ");
        }
        if ((key2.readyOps() & 8) != 0) {
            sb.append("OP_CONNECT ");
        }
        if ((key2.readyOps() & 1) != 0) {
            sb.append("OP_READ ");
        }
        if ((key2.readyOps() & 4) != 0) {
            sb.append("OP_WRITE ");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        InetAddress local2 = null;
        InetAddress remote = null;
        int local_port = 0;
        int remote_port = 0;
        boolean verbose = false;
        boolean debug2 = false;
        String mapping_file = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                String tmp_port;
                String tmp_addr;
                int index2;
                String tmp = args[i];
                if ("-help".equals(tmp)) {
                    Proxy.help();
                    return;
                }
                if ("-verbose".equals(tmp)) {
                    verbose = true;
                    continue;
                }
                if ("-local".equals(tmp)) {
                    if ((index2 = (tmp_addr = args[++i]).indexOf(58)) > -1) {
                        tmp_port = tmp_addr.substring(index2 + 1);
                        local_port = Integer.parseInt(tmp_port);
                        tmp_addr = tmp_addr.substring(0, index2);
                        local2 = InetAddress.getByName(tmp_addr);
                        continue;
                    }
                    local2 = InetAddress.getByName(args[++i]);
                    continue;
                }
                if ("-local_port".equals(tmp)) {
                    local_port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-remote".equals(tmp)) {
                    if ((index2 = (tmp_addr = args[++i]).indexOf(58)) > -1) {
                        tmp_port = tmp_addr.substring(index2 + 1);
                        remote_port = Integer.parseInt(tmp_port);
                        tmp_addr = tmp_addr.substring(0, index2);
                        remote = InetAddress.getByName(tmp_addr);
                        continue;
                    }
                    remote = InetAddress.getByName(args[++i]);
                    continue;
                }
                if ("-remote_port".equals(tmp)) {
                    remote_port = Integer.parseInt(args[++i]);
                    continue;
                }
                if ("-file".equals(tmp)) {
                    mapping_file = args[++i];
                    continue;
                }
                if ("-debug".equals(tmp)) {
                    debug2 = true;
                    continue;
                }
                Proxy.help();
                return;
            }
            if (local2 == null) {
                local2 = InetAddress.getLocalHost();
            }
            Proxy p = new Proxy(local2, local_port, remote, remote_port, verbose, debug2, mapping_file);
            p.start();
        }
        catch (VirtualMachineError err) {
            SystemFailure.initiateFailure(err);
            throw err;
        }
        catch (Throwable ex) {
            SystemFailure.checkFailure();
            ex.printStackTrace();
        }
    }

    static void help() {
        System.out.println("Proxy [-help] [-local <local address>] [-local_port <port>] [-remote <remote address>] [-remote_port <port>] [-verbose] [-file <mapping file>] [-debug]");
    }

    static void log(String method_name, String msg) {
        System.out.println('[' + method_name + "]: " + msg);
    }

    static void log(String msg) {
        System.out.println(msg);
    }

    static void close(Socket in, Socket out) {
        if (in != null) {
            try {
                in.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static void close(Socket sock) {
        if (sock != null) {
            try {
                sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static class Connection
    implements Relayer.Listener {
        Relayer in_to_out = null;
        Relayer out_to_in = null;

        public Connection(Socket in, Socket out) throws Exception {
            this.in_to_out = new Relayer(in, out, "in-out");
            this.in_to_out.addListener(this);
            this.out_to_in = new Relayer(out, in, "out-in");
            this.out_to_in.addListener(this);
        }

        public void start() {
            this.in_to_out.start();
            this.out_to_in.start();
        }

        public void stop() {
            if (this.in_to_out != null) {
                this.in_to_out.stop();
            }
            if (this.out_to_in != null) {
                this.out_to_in.stop();
            }
        }

        @Override
        public void connectionClosed() {
            this.stop();
        }
    }

    class SocketAcceptor
    implements Runnable {
        ServerSocket srv_sock = null;
        MyInetSocketAddress dest = null;

        public SocketAcceptor(MyInetSocketAddress sock_addr, MyInetSocketAddress dest) throws Exception {
            this.dest = dest;
            this.srv_sock = sock_addr.ssl() ? this.createSSLServerSocket(sock_addr) : this.createServerSocket(sock_addr);
            Proxy.this.executor.execute(this);
        }

        @Override
        public void run() {
            while (this.srv_sock != null) {
                SystemFailure.checkFailure();
                try {
                    Socket s = this.srv_sock.accept();
                    Socket dest_sock = this.dest.ssl() ? this.createSSLSocket(this.dest) : this.createSocket(this.dest);
                    Connection conn = new Connection(s, dest_sock);
                    conn.start();
                }
                catch (Exception e) {
                    Proxy.log("Proxy.SSLServerSocketAcceptor.run(): exception=" + e);
                    break;
                }
            }
        }

        Socket createSocket(InetSocketAddress addr) throws Exception {
            return new Socket(addr.getAddress(), addr.getPort());
        }

        Socket createSSLSocket(InetSocketAddress addr) throws Exception {
            SSLSocketFactory sslsocketfactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            SSLSocket sslsocket = (SSLSocket)sslsocketfactory.createSocket(addr.getAddress(), addr.getPort());
            return sslsocket;
        }

        ServerSocket createServerSocket(InetSocketAddress addr) throws Exception {
            return new ServerSocket(addr.getPort(), 10, addr.getAddress());
        }

        ServerSocket createSSLServerSocket(InetSocketAddress addr) throws Exception {
            SSLServerSocketFactory sslserversocketfactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            SSLServerSocket sslserversocket = (SSLServerSocket)sslserversocketfactory.createServerSocket(addr.getPort(), 10, addr.getAddress());
            return sslserversocket;
        }
    }

    static class MyInetSocketAddress
    extends InetSocketAddress {
        private static final long serialVersionUID = -2564520028821259228L;
        boolean is_ssl = false;

        public MyInetSocketAddress(InetAddress addr, int port) {
            super(addr, port);
        }

        public MyInetSocketAddress(InetAddress addr, int port, boolean is_ssl) {
            super(addr, port);
            this.is_ssl = is_ssl;
        }

        public MyInetSocketAddress(int port) {
            super(port);
        }

        public MyInetSocketAddress(int port, boolean is_ssl) {
            super(port);
            this.is_ssl = is_ssl;
        }

        public MyInetSocketAddress(String hostname, int port) {
            super(hostname, port);
        }

        public MyInetSocketAddress(String hostname, int port, boolean is_ssl) {
            super(hostname, port);
            this.is_ssl = is_ssl;
        }

        public boolean ssl() {
            return this.is_ssl;
        }

        @Override
        public String toString() {
            return super.toString() + " [ssl: " + this.ssl() + ']';
        }
    }

    static class Relayer
    implements Runnable {
        final Socket in_sock;
        final Socket out_sock;
        final InputStream in;
        final OutputStream out;
        Thread t = null;
        final List listeners = new ArrayList();
        String name = null;

        public Relayer(Socket in_sock, Socket out_sock, String name) throws Exception {
            this.in_sock = in_sock;
            this.out_sock = out_sock;
            this.name = name;
            this.in = in_sock.getInputStream();
            this.out = out_sock.getOutputStream();
        }

        public void addListener(Listener l) {
            if (l != null && !this.listeners.contains(l)) {
                this.listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] buf = new byte[1024];
            try {
                while (this.t != null) {
                    int num;
                    if (SystemFailure.getFailure() != null) {
                        Socket s = this.in_sock;
                        if (s != null) {
                            try {
                                s.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        if ((s = this.out_sock) != null) {
                            try {
                                s.close();
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                        SystemFailure.checkFailure();
                    }
                    if ((num = this.in.read(buf)) == -1) {
                        break;
                    }
                    if (verbose) {
                        Proxy.log(Proxy.printRelayedData(this.toString(this.in_sock), this.toString(this.out_sock), num));
                    }
                    if (debug) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(new String(buf, 0, num).trim());
                        Proxy.log(sb.toString());
                    }
                    this.out.write(buf, 0, num);
                }
            }
            catch (Exception ex) {
                Proxy.log("Proxy.Relayer.run(): [" + this.name + "] exception=" + ex + ", in_sock=" + this.in_sock + ", out_sock=" + this.out_sock);
            }
            finally {
                this.stop();
            }
        }

        public void start() {
            if (this.t == null) {
                this.t = new Thread((Runnable)this, "Proxy.Relayer");
                this.t.setDaemon(true);
                this.t.start();
            }
        }

        public void stop() {
            this.t = null;
            Proxy.close(this.in_sock);
            Proxy.close(this.out_sock);
        }

        String toString(Socket s) {
            if (s == null) {
                return null;
            }
            return s.getInetAddress().getHostName() + ':' + s.getPort();
        }

        void notifyListeners() {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                try {
                    ((Listener)it.next()).connectionClosed();
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable ex) {
                    SystemFailure.checkFailure();
                }
            }
        }

        static interface Listener {
            public void connectionClosed();
        }
    }
}

