/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.util;

import com.gemstone.org.jgroups.TimeoutException;

public class Promise {
    Object result = null;
    boolean hasResult = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResultWithTimeout(long timeout) throws TimeoutException {
        Promise promise = this;
        synchronized (promise) {
            Object object;
            try {
                object = this._getResultWithTimeout(timeout);
                this.notifyAll();
            }
            catch (Throwable throwable) {
                this.notifyAll();
                throw throwable;
            }
            return object;
        }
    }

    private Object _getResultWithTimeout(long timeout) throws TimeoutException {
        Object ret = null;
        long time_to_wait = timeout;
        boolean timeout_occurred = false;
        long start = System.currentTimeMillis();
        while (!this.hasResult && !Thread.currentThread().isInterrupted()) {
            if (timeout <= 0L) {
                this.doWait();
                continue;
            }
            if (time_to_wait <= 0L) {
                timeout_occurred = true;
                break;
            }
            this.doWait(time_to_wait);
            time_to_wait = timeout - (System.currentTimeMillis() - start);
        }
        ret = this.result;
        this.result = null;
        this.hasResult = false;
        if (timeout_occurred) {
            throw new TimeoutException();
        }
        return ret;
    }

    public Object getResult() {
        try {
            return this.getResultWithTimeout(0L);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    public Object getResult(long timeout) {
        try {
            return this.getResultWithTimeout(timeout);
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    void doWait() {
        try {
            this.wait();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    void doWait(long timeout) {
        try {
            this.wait(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasResult() {
        Promise promise = this;
        synchronized (promise) {
            return this.hasResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResult(Object obj) {
        Promise promise = this;
        synchronized (promise) {
            this.result = obj;
            this.hasResult = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Promise promise = this;
        synchronized (promise) {
            this.result = null;
            this.hasResult = false;
            this.notifyAll();
        }
    }

    public String toString() {
        return "hasResult=" + this.hasResult + ",result=" + this.result;
    }
}

