/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.util;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.ChannelException;
import com.gemstone.org.jgroups.conf.ClassConfigurator;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;

public class MagicObjectOutputStream
extends ObjectOutputStream {
    static ClassConfigurator conf = null;
    static final GemFireTracer log = GemFireTracer.getLog(MagicObjectOutputStream.class);

    public MagicObjectOutputStream(OutputStream out) throws IOException {
        super(out);
        if (conf == null) {
            try {
                conf = ClassConfigurator.getInstance(false);
            }
            catch (ChannelException e) {
                log.error(JGroupsStrings.MagicObjectOutputStream_CLASSCONFIGURATOR_COULD_NOT_BE_INSTANTIATED, (Throwable)e);
            }
        }
    }

    @Override
    protected void writeClassDescriptor(ObjectStreamClass desc) throws IOException {
        if (conf == null) {
            super.writeInt(-1);
            super.writeClassDescriptor(desc);
            return;
        }
        int magic_num = conf.getMagicNumberFromObjectStreamClass(desc);
        super.writeInt(magic_num);
        if (magic_num == -1) {
            if (log.isTraceEnabled()) {
                log.trace("could not find magic number for '" + desc.getName() + "': writing full class descriptor");
            }
            super.writeClassDescriptor(desc);
        }
    }
}

