/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.util;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.ChannelException;
import com.gemstone.org.jgroups.conf.ClassConfigurator;
import com.gemstone.org.jgroups.util.ContextObjectInputStream;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectStreamClass;

public class MagicObjectInputStream
extends ContextObjectInputStream {
    static ClassConfigurator conf = null;
    static final GemFireTracer log = GemFireTracer.getLog(MagicObjectInputStream.class);

    public MagicObjectInputStream(InputStream is) throws IOException {
        super(is);
        if (conf == null) {
            try {
                conf = ClassConfigurator.getInstance(false);
            }
            catch (ChannelException e) {
                log.error(JGroupsStrings.MagicObjectInputStream_CLASSCONFIGURATOR_COULD_NOT_BE_INSTANTIATED, (Throwable)e);
            }
        }
    }

    @Override
    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        int magic_num = super.readInt();
        if (conf == null || magic_num == -1) {
            return super.readClassDescriptor();
        }
        ObjectStreamClass retval = conf.getObjectStreamClassFromMagicNumber(magic_num);
        if (retval == null) {
            throw new ClassNotFoundException("failed fetching class descriptor for magic number " + magic_num);
        }
        return retval;
    }
}

