/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.util;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMembershipManager;
import com.gemstone.gemfire.i18n.StringId;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.gemfire.internal.logging.InternalLogWriter;
import com.gemstone.gemfire.internal.logging.StandardOutputPrinter;
import com.gemstone.gemfire.internal.process.StartupStatus;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.StringWriter;

public class GemFireTracer {
    public static boolean DEBUG = JGroupMembershipManager.DEBUG_JAVAGROUPS;
    static InternalLogWriter defaultLogWriter = new StandardOutputPrinter(800);
    protected static final InternalLogWriter defaultSecurityLogWriter = new StandardOutputPrinter(800);
    private static InternalLogWriter logWriter = defaultLogWriter;
    private static InternalLogWriter securityLogWriter = defaultSecurityLogWriter;
    public static final ThreadGroup GROUP = new ThreadGroup("JGroups Threads"){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (e instanceof VirtualMachineError) {
                SystemFailure.setFailure((VirtualMachineError)e);
            }
            StringWriter sw = new StringWriter();
            sw.write("Uncaught Exception in thread ");
            sw.write(t.getName());
            GemFireTracer.getLog(GemFireTracer.class).error("ThreadGroup: " + sw.toString(), e);
        }
    };
    private static GemFireTracer defaultInstance;

    public static GemFireTracer getLog(Class clz) {
        return defaultInstance;
    }

    public static void setLogWriter(InternalLogWriter writer) {
        GemFireTracer.setLogWriter(writer, DEBUG);
    }

    public static void setLogWriter(InternalLogWriter writer, boolean debug2) {
        DEBUG = debug2;
        defaultLogWriter = writer;
        logWriter = writer;
    }

    public static void setSecurityLogWriter(InternalLogWriter writer) {
        securityLogWriter = writer;
    }

    public InternalLogWriter getInternalLogWriter() {
        return this._log();
    }

    public InternalLogWriter getSecurityInternalLogWriter() {
        return this._securityLog();
    }

    private final InternalLogWriter _log() {
        return logWriter;
    }

    private final InternalLogWriter _securityLog() {
        return securityLogWriter;
    }

    public void startup(StringId msgId, Object ... params) {
        StartupStatus.startup(msgId, params);
    }

    public void debug(Object arg0, Throwable arg1) {
        if (DEBUG) {
            this._log().info(JGroupsStrings.ONE_ARG, "" + arg0, arg1);
        }
    }

    public void debug(Object arg0) {
        if (DEBUG) {
            this._log().info(JGroupsStrings.ONE_ARG, "" + arg0);
        }
    }

    public void debug(StringId arg0, Object[] arg1, Throwable arg2) {
        if (DEBUG) {
            this._log().info(arg0, arg1, arg2);
        }
    }

    public void debug(StringId arg0, Throwable arg1) {
        if (DEBUG) {
            this._log().info(arg0, arg1);
        }
    }

    public void debug(StringId arg0, Object[] arg1) {
        if (DEBUG) {
            this._log().info(arg0, arg1);
        }
    }

    public void debug(StringId arg0) {
        if (DEBUG) {
            this._log().info(arg0);
        }
    }

    public void error(Object arg0, Throwable arg1) {
        this._log().error(JGroupsStrings.ONE_ARG, arg0, arg1);
    }

    public void error(Object arg0) {
        this._log().error(JGroupsStrings.ONE_ARG, arg0);
    }

    public void error(StringId arg0, Object[] arg1, Throwable arg2) {
        if (DEBUG) {
            this._log().error(arg0, arg1, arg2);
        }
    }

    public void error(StringId arg0, Object arg1, Throwable arg2) {
        if (DEBUG) {
            this._log().error(arg0, arg1, arg2);
        }
    }

    public void error(StringId arg0, Object[] arg1) {
        if (DEBUG) {
            this._log().error(arg0, arg1);
        }
    }

    public void error(StringId arg0, Object arg1) {
        if (DEBUG) {
            this._log().error(arg0, arg1);
        }
    }

    public void error(StringId arg0, Throwable arg1) {
        if (DEBUG) {
            this._log().error(arg0, arg1);
        }
    }

    public void error(StringId arg0) {
        if (DEBUG) {
            this._log().error(arg0);
        }
    }

    public void fatal(Object arg0, Throwable arg1) {
        this._log().severe(JGroupsStrings.ONE_ARG, arg0, arg1);
    }

    public void fatal(Object arg0) {
        this._log().severe(JGroupsStrings.ONE_ARG, arg0);
    }

    public void fatal(StringId arg0, Object[] arg1) {
        if (DEBUG) {
            this._log().severe(arg0, arg1);
        }
    }

    public void fatal(StringId arg0, Object[] arg1, Throwable arg2) {
        if (DEBUG) {
            this._log().severe(arg0, arg1, arg2);
        }
    }

    public void fatal(StringId arg0, Throwable arg1) {
        if (DEBUG) {
            this._log().severe(arg0, arg1);
        }
    }

    public void fatal(StringId arg0) {
        if (DEBUG) {
            this._log().severe(arg0);
        }
    }

    public void info(Object arg0, Throwable arg1) {
        if (DEBUG) {
            this._log().info(JGroupsStrings.ONE_ARG, "" + arg0, arg1);
        } else {
            this._log().fine("" + arg0, arg1);
        }
    }

    public void info(Object arg0) {
        if (DEBUG) {
            this._log().info(JGroupsStrings.ONE_ARG, "" + arg0);
        } else {
            this._log().fine("" + arg0);
        }
    }

    public void info(StringId arg0, Object[] arg1, Throwable arg2) {
        if (DEBUG) {
            this._log().info(arg0, arg1, arg2);
        } else {
            this._log().fine(arg0.toLocalizedString(arg1), arg2);
        }
    }

    public void info(StringId arg0, Throwable arg1) {
        if (DEBUG) {
            this._log().info(arg0, arg1);
        } else {
            this._log().fine(arg0.toLocalizedString(), arg1);
        }
    }

    public void info(StringId arg0, Object[] arg1) {
        if (DEBUG) {
            this._log().info(arg0, arg1);
        } else {
            this._log().fine(arg0.toLocalizedString(arg1));
        }
    }

    public void info(StringId arg0, Object arg1) {
        this.info(arg0, new Object[]{arg1});
    }

    public void info(StringId arg0) {
        if (DEBUG) {
            this._log().info(arg0);
        } else {
            this._log().fine("" + arg0.toLocalizedString());
        }
    }

    public boolean isDebugEnabled() {
        return DEBUG;
    }

    public boolean isErrorEnabled() {
        return this._log().errorEnabled();
    }

    public boolean isFatalEnabled() {
        return this._log().severeEnabled();
    }

    public boolean isInfoEnabled() {
        if (DEBUG) {
            return this._log().infoEnabled();
        }
        return this._log().fineEnabled();
    }

    public boolean isTraceEnabled() {
        return DEBUG;
    }

    public boolean isWarnEnabled() {
        if (DEBUG) {
            return this._log().warningEnabled();
        }
        return this._log().fineEnabled();
    }

    public void trace(Object arg0, Throwable arg1) {
        if (DEBUG) {
            this._log().info(JGroupsStrings.ONE_ARG, "" + arg0, arg1);
        } else {
            this._log().finer("" + arg0, arg1);
        }
    }

    public void trace(Object arg0) {
        if (DEBUG) {
            this._log().info(JGroupsStrings.ONE_ARG, "" + arg0);
        } else {
            this._log().finer("" + arg0);
        }
    }

    public void warn(Object arg0, Throwable arg1) {
        if (DEBUG) {
            this._log().warning(JGroupsStrings.ONE_ARG, arg0, arg1);
        } else {
            this._log().fine("" + arg0, arg1);
        }
    }

    public void warn(Object arg0) {
        if (DEBUG) {
            this._log().warning(JGroupsStrings.ONE_ARG, arg0);
        } else {
            this._log().fine("" + arg0);
        }
    }

    public static String getStackTrace(Throwable x) {
        if (x == null) {
            return null;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream writer = new PrintStream(bout);
        x.printStackTrace(writer);
        String result = new String(bout.toByteArray());
        return result;
    }

    static {
        GROUP.setDaemon(false);
        defaultInstance = new GemFireTracer();
    }
}

