/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.util;

import com.gemstone.org.jgroups.TimeoutException;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.ViewId;
import com.gemstone.org.jgroups.util.Promise;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class AckCollector {
    private List missing_acks;
    private Set received_acks = new HashSet();
    private final Promise all_acks_received = new Promise();
    private ViewId proposed_view;
    private Set suspected_mbrs = new HashSet();

    public AckCollector() {
        this.missing_acks = new ArrayList();
    }

    public AckCollector(ViewId v, List l) {
        this.missing_acks = new ArrayList(l);
        this.proposed_view = v;
    }

    public List getMissing() {
        return this.missing_acks;
    }

    public Set getReceived() {
        return this.received_acks;
    }

    public ViewId getViewId() {
        return this.proposed_view;
    }

    public void reset(ViewId v, Collection l) {
        this.proposed_view = v;
        this.missing_acks = new ArrayList();
        if (l != null) {
            this.missing_acks.addAll(l);
        }
        this.missing_acks.removeAll(this.suspected_mbrs);
        this.missing_acks.removeAll(this.received_acks);
        this.received_acks.addAll(this.suspected_mbrs);
        this.all_acks_received.reset();
        if (this.missing_acks.size() == 0) {
            this.all_acks_received.setResult(Boolean.TRUE);
        }
    }

    public void fullyReset() {
        this.received_acks = new HashSet();
        this.suspected_mbrs = new HashSet();
    }

    public int size() {
        return this.missing_acks.size();
    }

    public void ack(Object member, ViewId vid) {
        ViewId proposed = this.proposed_view;
        if (vid != null && proposed != null && !proposed.equals(vid)) {
            return;
        }
        this.missing_acks.remove(member);
        this.received_acks.add(member);
        if (this.missing_acks.size() == 0) {
            this.all_acks_received.setResult(Boolean.TRUE);
        }
    }

    public void suspect(Object member) {
        this.ack(member, null);
        this.suspected_mbrs.add(member);
    }

    public void unsuspect(Object member) {
        this.suspected_mbrs.remove(member);
    }

    public Set getSuspectedMembers() {
        return this.suspected_mbrs;
    }

    public void handleView(View v) {
        if (v == null) {
            return;
        }
        Vector mbrs = v.getMembers();
        this.suspected_mbrs.retainAll(mbrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForAllAcks() {
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            this.missing_acks.removeAll(this.suspected_mbrs);
            if (this.missing_acks.size() == 0) {
                return true;
            }
        }
        Object result = this.all_acks_received.getResult();
        return result != null && result instanceof Boolean && (Boolean)result != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitForAllAcks(long timeout) throws TimeoutException {
        AckCollector ackCollector = this;
        synchronized (ackCollector) {
            this.missing_acks.removeAll(this.suspected_mbrs);
            if (this.missing_acks.size() == 0) {
                return true;
            }
        }
        Object result = this.all_acks_received.getResultWithTimeout(timeout);
        return result != null && result instanceof Boolean && (Boolean)result != false;
    }

    public synchronized List getMissingAcks() {
        return new ArrayList(this.missing_acks);
    }

    public String toString() {
        return "missing=" + this.missing_acks + ", received=" + this.received_acks;
    }
}

