/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.stack.tcpserver;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.UnsupportedVersionException;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.VersionedDataInputStream;
import com.gemstone.gemfire.internal.VersionedDataOutputStream;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.stack.tcpserver.InfoRequest;
import com.gemstone.org.jgroups.stack.tcpserver.InfoResponse;
import com.gemstone.org.jgroups.stack.tcpserver.ShutdownRequest;
import com.gemstone.org.jgroups.stack.tcpserver.TcpServer;
import com.gemstone.org.jgroups.stack.tcpserver.VersionRequest;
import com.gemstone.org.jgroups.stack.tcpserver.VersionResponse;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;

public class TcpClient {
    private static final GemFireTracer LOG = GemFireTracer.getLog(TcpClient.class);
    private static final int REQUEST_TIMEOUT = 120000;
    private static Map<IpAddress, Short> serverVersions = new HashMap<IpAddress, Short>();

    public static void stop(InetAddress addr, int port) throws ConnectException {
        try {
            ShutdownRequest request = new ShutdownRequest();
            TcpClient.requestToServer(addr, port, request, 120000);
        }
        catch (ConnectException ce) {
            throw ce;
        }
        catch (Exception ex) {
            LOG.error("TcpClient.stop(): exception connecting to locator " + addr + ":" + port + ": " + ex);
        }
    }

    public static String[] getInfo(InetAddress addr, int port) {
        try {
            InfoRequest request = new InfoRequest();
            InfoResponse response = (InfoResponse)TcpClient.requestToServer(addr, port, request, 120000);
            return response.getInfo();
        }
        catch (ConnectException ignore) {
            return null;
        }
        catch (Exception ex) {
            LOG.error("TcpClient.getInfo(): exception connecting to locator " + addr + ":" + port + ": " + ex);
            return null;
        }
    }

    public static Object requestToServer(InetAddress addr, int port, Object request, int timeout) throws IOException, ClassNotFoundException {
        return TcpClient.requestToServer(addr, port, request, timeout, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object requestToServer(InetAddress addr, int port, Object request, int timeout, boolean replyExpected) throws IOException, ClassNotFoundException {
        IpAddress ipAddr = addr == null ? new IpAddress(port) : new IpAddress(addr, port);
        short serverVersion = TcpClient.getServerVersion(ipAddr, 120000);
        if (serverVersion > Version.CURRENT_ORDINAL) {
            serverVersion = Version.CURRENT_ORDINAL;
        }
        int gossipVersion = TcpServer.getCurrentGossipVersion();
        if (Version.GFE_71.compareTo(serverVersion) > 0) {
            gossipVersion = TcpServer.getOldGossipVersion();
        }
        Socket sock = SocketCreator.getDefaultInstance().connect(ipAddr.getIpAddress(), ipAddr.getPort(), timeout, null, false);
        sock.setSoTimeout(timeout);
        try {
            DataOutputStream out = new DataOutputStream(sock.getOutputStream());
            if (serverVersion < Version.CURRENT_ORDINAL) {
                out = new VersionedDataOutputStream(out, Version.fromOrdinalNoThrow(serverVersion, false));
            }
            out.writeInt(gossipVersion);
            if (gossipVersion > TcpServer.getOldGossipVersion()) {
                out.writeShort(serverVersion);
            }
            DataSerializer.writeObject(request, out);
            out.flush();
            if (replyExpected) {
                DataInputStream in = new DataInputStream(sock.getInputStream());
                in = new VersionedDataInputStream(in, Version.fromOrdinal(serverVersion, false));
                try {
                    Object response;
                    Object t = response = DataSerializer.readObject(in);
                    return t;
                }
                catch (EOFException ex) {
                    throw new EOFException("Locator at " + ipAddr + " did not respond. This is normal if the locator was shutdown. If it wasn't check its log for exceptions.");
                }
            }
            Object var10_12 = null;
            return var10_12;
        }
        catch (UnsupportedVersionException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Remote TcpServer version: " + serverVersion + " is higher than local version: " + Version.CURRENT_ORDINAL + ". This is never expected as remoteVersion");
            }
            Object var10_11 = null;
            return var10_11;
        }
        finally {
            try {
                sock.close();
            }
            catch (Exception e) {
                LOG.error("Error closing socket ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Short getServerVersion(IpAddress ipAddr, int timeout) throws IOException, ClassNotFoundException {
        block23: {
            int gossipVersion = TcpServer.getCurrentGossipVersion();
            Short serverVersion = null;
            Object verRes = null;
            Map<IpAddress, Short> map = serverVersions;
            synchronized (map) {
                serverVersion = serverVersions.get(ipAddr);
            }
            if (serverVersion != null) {
                return serverVersion;
            }
            gossipVersion = TcpServer.getOldGossipVersion();
            Socket sock = SocketCreator.getDefaultInstance().connect(ipAddr.getIpAddress(), ipAddr.getPort(), timeout, null, false);
            sock.setSoTimeout(timeout);
            try {
                DataOutputStream out = new DataOutputStream(sock.getOutputStream());
                out = new VersionedDataOutputStream(out, Version.GFE_57);
                out.writeInt(gossipVersion);
                VersionRequest verRequest = new VersionRequest();
                DataSerializer.writeObject(verRequest, out);
                out.flush();
                DataInputStream in = new DataInputStream(sock.getInputStream());
                in = new VersionedDataInputStream(in, Version.GFE_57);
                try {
                    VersionResponse response = (VersionResponse)DataSerializer.readObject(in);
                    if (response == null) break block23;
                    serverVersion = response.getVersionOrdinal();
                    Object object = serverVersions;
                    synchronized (object) {
                        serverVersions.put(ipAddr, serverVersion);
                    }
                    object = serverVersion;
                    return object;
                }
                catch (EOFException ex) {
                    // empty catch block
                }
            }
            finally {
                try {
                    sock.close();
                }
                catch (Exception e) {
                    LOG.error("Error closing socket ", (Throwable)e);
                }
            }
        }
        if (LOG.getInternalLogWriter().fineEnabled()) {
            LOG.getInternalLogWriter().fine("Locator " + ipAddr + " did not respond to a request for its version.  I will assume it is using v5.7 for safety.");
        }
        Map<IpAddress, Short> map = serverVersions;
        synchronized (map) {
            serverVersions.put(ipAddr, Version.GFE_57.ordinal());
        }
        return Version.GFE_57.ordinal();
    }

    private TcpClient() {
    }
}

