/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.stack;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.stack.IpAddress;
import com.gemstone.org.jgroups.util.Buffer;
import com.gemstone.org.jgroups.util.ExposedByteArrayOutputStream;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.List;
import com.gemstone.org.jgroups.util.Util;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.net.Socket;

public class RouterStub {
    String router_host = null;
    int router_port = 0;
    Socket sock = null;
    final ExposedByteArrayOutputStream out_stream = new ExposedByteArrayOutputStream(512);
    DataOutputStream output = null;
    DataInputStream input = null;
    Address local_addr = null;
    static final long RECONNECT_TIMEOUT = 5000L;
    private volatile boolean connected = false;
    private volatile boolean reconnect = false;
    protected static final GemFireTracer log = GemFireTracer.getLog(RouterStub.class);

    public RouterStub(String router_host, int router_port) {
        this.router_host = router_host != null ? router_host : "localhost";
        this.router_port = router_port;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public synchronized Address connect() throws Exception {
        Address ret = null;
        int len = 0;
        try {
            this.sock = new Socket(this.router_host, this.router_port);
            this.sock.setSoLinger(true, 500);
            this.input = new DataInputStream(this.sock.getInputStream());
            len = this.input.readInt();
            byte[] buf = new byte[len];
            this.input.readFully(buf);
            ret = (Address)Util.objectFromByteBuffer(buf);
            this.output = new DataOutputStream(this.sock.getOutputStream());
            this.connected = true;
        }
        catch (Exception e) {
            this.connected = false;
            if (this.sock != null) {
                this.sock.close();
            }
            throw e;
        }
        if (ret == null && this.sock != null) {
            ret = new IpAddress(this.sock.getLocalPort());
        }
        if (this.local_addr == null) {
            this.local_addr = ret;
        }
        return ret;
    }

    public synchronized void disconnect() {
        if (this.output != null) {
            try {
                this.output.close();
                this.output = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.input != null) {
            try {
                this.input.close();
                this.input = null;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.sock != null) {
            try {
                this.sock.close();
                this.sock = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.connected = false;
        this.reconnect = false;
    }

    public boolean register(String groupname) {
        byte[] buf = null;
        if (this.sock == null || this.output == null || this.input == null) {
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.RouterStub_NO_CONNECTION_TO_ROUTER_GROUPNAME_0, groupname);
            }
            this.connected = false;
            return false;
        }
        if (groupname == null || groupname.length() == 0) {
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.RouterStub_GROUPNAME_IS_NULL);
            }
            return false;
        }
        if (this.local_addr == null) {
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.RouterStub_LOCAL_ADDR_IS_NULL);
            }
            return false;
        }
        try {
            buf = Util.objectToByteBuffer(this.local_addr);
            this.output.writeInt(-11);
            this.output.writeUTF(groupname);
            this.output.writeInt(buf.length);
            this.output.write(buf, 0, buf.length);
            this.output.flush();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.RouterStub_FAILURE__0, Util.getStackTrace(e));
            }
            this.connected = false;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List get(String groupname) {
        List ret = null;
        Socket tmpsock = null;
        FilterOutputStream tmpOutput = null;
        FilterInputStream tmpInput = null;
        if (groupname == null || groupname.length() == 0) {
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.RouterStub_GROUPNAME_IS_NULL);
            }
            return null;
        }
        try {
            tmpsock = new Socket(this.router_host, this.router_port);
            tmpsock.setSoLinger(true, 500);
            tmpInput = new DataInputStream(tmpsock.getInputStream());
            int len = ((DataInputStream)tmpInput).readInt();
            byte[] buf = new byte[len];
            ((DataInputStream)tmpInput).readFully(buf);
            tmpOutput = new DataOutputStream(tmpsock.getOutputStream());
            ((DataOutputStream)tmpOutput).writeInt(-10);
            ((DataOutputStream)tmpOutput).writeUTF(groupname);
            len = ((DataInputStream)tmpInput).readInt();
            if (len == 0) {
                List list = null;
                return list;
            }
            buf = new byte[len];
            ((DataInputStream)tmpInput).readFully(buf);
            ret = (List)Util.objectFromByteBuffer(buf);
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.RouterStub_EXCEPTION_0, (Throwable)e);
            }
        }
        finally {
            try {
                if (tmpOutput != null) {
                    tmpOutput.close();
                }
            }
            catch (Exception e) {}
            try {
                if (tmpInput != null) {
                    tmpInput.close();
                }
            }
            catch (Exception e) {}
            try {
                if (tmpsock != null) {
                    tmpsock.close();
                }
            }
            catch (Exception e) {}
        }
        return ret;
    }

    public boolean send(Message msg, String groupname) {
        Address dst_addr = null;
        if (this.sock == null || this.output == null || this.input == null) {
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.RouterStub_NO_CONNECTION_TO_ROUTER_GROUPNAME_0, groupname);
            }
            this.connected = false;
            return false;
        }
        if (msg == null) {
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.RouterStub_MESSAGE_IS_NULL);
            }
            return false;
        }
        try {
            dst_addr = msg.getDest();
            this.out_stream.reset();
            DataOutputStream tmp = new DataOutputStream(this.out_stream);
            msg.writeTo(tmp);
            tmp.close();
            Buffer buf = new Buffer(this.out_stream.getRawBuffer(), 0, this.out_stream.size());
            this.output.writeUTF(groupname);
            Util.writeAddress(dst_addr, this.output);
            this.output.writeInt(buf.getLength());
            this.output.write(buf.getBuf(), 0, buf.getLength());
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.RouterStub_FAILED_SENDING_MESSAGE_TO__0, dst_addr, (Throwable)e);
            }
            this.connected = false;
            return false;
        }
        return true;
    }

    public Message receive() {
        Message ret = null;
        byte[] buf = null;
        if (this.sock == null || this.output == null || this.input == null) {
            if (log.isErrorEnabled()) {
                log.error(JGroupsStrings.RouterStub_NO_CONNECTION_TO_ROUTER);
            }
            this.connected = false;
            return null;
        }
        try {
            Address dest = Util.readAddress(this.input);
            int len = this.input.readInt();
            if (len != 0) {
                buf = new byte[len];
                this.input.readFully(buf, 0, len);
                ret = new Message(false);
                ByteArrayInputStream tmp = new ByteArrayInputStream(buf);
                DataInputStream in = new DataInputStream(tmp);
                ret.readFrom(in);
                ret.setDest(dest);
                in.close();
            }
        }
        catch (Exception e) {
            if (this.connected && log.isTraceEnabled()) {
                log.trace("failed receiving message", e);
            }
            this.connected = false;
            return null;
        }
        if (log.isTraceEnabled()) {
            log.trace("received " + ret);
        }
        return ret;
    }

    public boolean reconnect(int max_attempts) {
        Address new_addr = null;
        int num_atttempts = 0;
        if (this.connected) {
            return false;
        }
        this.disconnect();
        this.reconnect = true;
        while (this.reconnect && (num_atttempts++ < max_attempts || max_attempts == -1)) {
            block9: {
                try {
                    new_addr = this.connect();
                    if (new_addr != null) {
                        break;
                    }
                }
                catch (Exception ex) {
                    if (!log.isTraceEnabled()) break block9;
                    log.trace("failed reconnecting", ex);
                }
            }
            if (max_attempts != -1) continue;
            try {
                Util.sleep(5000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        if (new_addr == null) {
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace("client reconnected, new address is " + new_addr);
        }
        return true;
    }

    public boolean reconnect() {
        return this.reconnect(-1);
    }
}

