/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.stack;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.stack.Interval;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.TimeScheduler;
import com.gemstone.org.jgroups.util.Util;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Retransmitter {
    private static final long SEC = 1000L;
    private static long[] RETRANSMIT_TIMEOUTS = new long[]{2000L, 3000L, 5000L, 8000L};
    private static final long SUSPEND_TIMEOUT = 2000L;
    protected Address sender = null;
    private final LinkedList msgs = new LinkedList();
    protected RetransmitCommand cmd = null;
    private boolean retransmitter_owned;
    private TimeScheduler retransmitter = null;
    protected static final GemFireTracer log = GemFireTracer.getLog(Retransmitter.class);

    public Retransmitter(Address sender, RetransmitCommand cmd, TimeScheduler sched) {
        this.init(sender, cmd, sched, false);
    }

    public Retransmitter(Address sender, RetransmitCommand cmd) {
        this.init(sender, cmd, new TimeScheduler(2000L), true);
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GemFire only sets the retransmit timeout sequence to one value")
    public void setRetransmitTimeouts(long[] timeouts) {
        if (timeouts != null) {
            RETRANSMIT_TIMEOUTS = timeouts;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(long first_seqno, long last_seqno) {
        if (first_seqno > last_seqno) {
            long tmp = first_seqno;
            first_seqno = last_seqno;
            last_seqno = tmp;
        }
        LinkedList linkedList = this.msgs;
        synchronized (linkedList) {
            Entry e = new Entry(first_seqno, last_seqno, RETRANSMIT_TIMEOUTS);
            this.msgs.add(e);
            this.retransmitter.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(long seqno) {
        LinkedList linkedList = this.msgs;
        synchronized (linkedList) {
            ListIterator it = this.msgs.listIterator();
            while (it.hasNext()) {
                Entry e = (Entry)it.next();
                if (seqno < e.low || e.high < seqno) continue;
                e.remove(seqno);
                if (e.low <= e.high) break;
                e.cancel();
                it.remove();
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        LinkedList linkedList = this.msgs;
        synchronized (linkedList) {
            ListIterator it = this.msgs.listIterator();
            while (it.hasNext()) {
                Entry entry = (Entry)it.next();
                entry.cancel();
            }
            this.msgs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LinkedList linkedList = this.msgs;
        synchronized (linkedList) {
            block8: {
                if (this.retransmitter_owned) {
                    try {
                        this.retransmitter.stop();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        if (!log.isErrorEnabled()) break block8;
                        log.error(JGroupsStrings.Retransmitter_FAILED_STOPPING_RETRANSMITTER, (Throwable)ex);
                    }
                } else {
                    ListIterator it = this.msgs.listIterator();
                    while (it.hasNext()) {
                        Entry entry = (Entry)it.next();
                        entry.cancel();
                    }
                }
            }
            this.msgs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        LinkedList linkedList = this.msgs;
        synchronized (linkedList) {
            int size2 = this.size();
            StringBuffer sb = new StringBuffer();
            sb.append(size2).append(" messages to retransmit: ").append(this.msgs);
            return sb.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void toString(StringBuffer sb) {
        LinkedList linkedList = this.msgs;
        synchronized (linkedList) {
            this.retransmitter.toString(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int size2 = 0;
        LinkedList linkedList = this.msgs;
        synchronized (linkedList) {
            for (Entry entry : this.msgs) {
                size2 += entry.size();
            }
        }
        return size2;
    }

    private void init(Address sender, RetransmitCommand cmd, TimeScheduler sched, boolean sched_owned) {
        this.sender = sender;
        this.cmd = cmd;
        this.retransmitter_owned = sched_owned;
        this.retransmitter = sched;
    }

    static void sleep(long timeout) throws InterruptedException {
        Util.sleep(timeout);
    }

    static class MyXmitter
    implements RetransmitCommand {
        MyXmitter() {
        }

        @Override
        public void retransmit(long first_seqno, long last_seqno, Address sender) {
            System.out.println("-- " + new Date() + ": retransmit(" + first_seqno + ", " + last_seqno + ", " + sender + ')');
        }

        @Override
        public Address getDest() {
            return null;
        }
    }

    private class Entry
    extends Task {
        protected long low;
        protected long high;
        final List list;

        public Entry(long low, long high, long[] intervals) {
            super(intervals);
            this.list = new ArrayList();
            this.low = low;
            this.high = high;
            this.list.add(new long[]{low, high});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(long seqno) {
            long[] bounds = null;
            List list = this.list;
            synchronized (list) {
                int i;
                for (i = 0; i < this.list.size() && (seqno < (bounds = (long[])this.list.get(i))[0] || bounds[1] < seqno); ++i) {
                }
                if (i == this.list.size()) {
                    return;
                }
                if (seqno == bounds[0]) {
                    if (bounds[0] == bounds[1]) {
                        this.list.remove(i);
                    } else {
                        bounds[0] = bounds[0] + 1L;
                    }
                    if (i == 0) {
                        this.low = this.list.size() == 0 ? this.high + 1L : ((long[])this.list.get(i))[0];
                    }
                } else if (seqno == bounds[1]) {
                    bounds[1] = bounds[1] - 1L;
                    if (i == this.list.size() - 1) {
                        this.high = ((long[])this.list.get(i))[1];
                    }
                } else {
                    long[] newBounds = new long[]{seqno + 1L, bounds[1]};
                    bounds[1] = seqno - 1L;
                    this.list.add(i + 1, newBounds);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList copy;
            List list = this.list;
            synchronized (list) {
                copy = new LinkedList(this.list);
            }
            for (long[] bounds : copy) {
                try {
                    Retransmitter.this.cmd.retransmit(bounds[0], bounds[1], Retransmitter.this.sender);
                }
                catch (IllegalStateException e) {
                    this.cancel();
                }
                catch (VirtualMachineError err) {
                    SystemFailure.initiateFailure(err);
                    throw err;
                }
                catch (Throwable t) {
                    SystemFailure.checkFailure();
                    log.error(JGroupsStrings.Retransmitter_FAILURE_ASKING__0__FOR_RETRANSMISSION, Retransmitter.this.cmd, t);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int size() {
            int size2 = 0;
            List list = this.list;
            synchronized (list) {
                for (long[] tmp : this.list) {
                    long diff = tmp[1] - tmp[0] + 1L;
                    size2 = (int)((long)size2 + diff);
                }
            }
            return size2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            StringBuffer sb = new StringBuffer();
            List list = this.list;
            synchronized (list) {
                boolean first = true;
                for (long[] range : this.list) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(range[0]).append('-').append(range[1]);
                }
            }
            return "xmit(" + Retransmitter.this.cmd.getDest() + ":" + sb.toString() + ")<" + this.low + "," + this.high + ">";
        }
    }

    private static abstract class Task
    implements TimeScheduler.Task {
        private final Interval intervals;
        private boolean cancelled;

        protected Task(long[] intervals) {
            this.intervals = new Interval(intervals);
            this.cancelled = false;
        }

        @Override
        public long nextInterval() {
            return this.intervals.next();
        }

        @Override
        public boolean cancelled() {
            return this.cancelled;
        }

        public void cancel() {
            this.cancelled = true;
        }
    }

    public static interface RetransmitCommand {
        public void retransmit(long var1, long var3, Address var5);

        public Address getDest();
    }
}

