/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.stack;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.internal.DMStats;
import com.gemstone.gemfire.distributed.internal.membership.jgroup.JGroupMembershipManager;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.stack.DownHandler;
import com.gemstone.org.jgroups.stack.ProtocolObserver;
import com.gemstone.org.jgroups.stack.ProtocolStack;
import com.gemstone.org.jgroups.stack.UpHandler;
import com.gemstone.org.jgroups.util.GemFireTracer;
import com.gemstone.org.jgroups.util.Queue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public abstract class Protocol {
    protected final Properties props = new Properties();
    protected Protocol up_prot = null;
    public Protocol down_prot = null;
    public ProtocolStack stack = null;
    protected final Queue up_queue = new Queue();
    protected final Queue down_queue = new Queue();
    protected UpHandler up_handler = null;
    protected int up_thread_prio = -1;
    protected DownHandler down_handler = null;
    protected int down_thread_prio = -1;
    protected ProtocolObserver observer = null;
    private static final long THREAD_JOIN_TIMEOUT = 1000L;
    protected boolean down_thread = true;
    protected boolean up_thread = true;
    public boolean stats = false;
    public final GemFireTracer log = GemFireTracer.getLog(this.getClass());
    public static boolean trace = JGroupMembershipManager.DEBUG_JAVAGROUPS;
    public boolean warn = this.log.isWarnEnabled();
    protected static final int enumUDP = 1;
    protected static final int enumPING = 2;
    protected static final int enumNAKACK = 3;
    protected static final int enumUNICAST = 4;
    protected static final int enumSTABLE = 5;
    protected static final int enumFRAG2 = 6;
    protected static final int enumGMS = 7;
    protected static final int enumFC = 8;
    protected static final int enumVIEWSYNC = 9;
    protected static final int enumFD = 10;
    protected static final int enumTCPGOSSIP = 11;
    protected static final int enumDISCOVERY = 12;
    protected static final int enumDirAck = 13;

    public int getProtocolEnum() {
        return -1;
    }

    public long nanoTime() {
        return NanoTimer.getTime();
    }

    public boolean setProperties(Properties props) {
        if (props != null) {
            this.props.putAll((Map<?, ?>)props);
        }
        return true;
    }

    public boolean setPropertiesInternal(Properties props) {
        this.props.putAll((Map<?, ?>)props);
        String str = props.getProperty("down_thread");
        if (str != null) {
            this.down_thread = Boolean.valueOf(str);
            props.remove("down_thread");
        }
        if ((str = props.getProperty("down_thread_prio")) != null) {
            this.down_thread_prio = Integer.parseInt(str);
            props.remove("down_thread_prio");
        }
        if ((str = props.getProperty("up_thread")) != null) {
            this.up_thread = Boolean.valueOf(str);
            props.remove("up_thread");
        }
        if ((str = props.getProperty("up_thread_prio")) != null) {
            this.up_thread_prio = Integer.parseInt(str);
            props.remove("up_thread_prio");
        }
        if ((str = props.getProperty("stats")) != null) {
            this.stats = Boolean.valueOf(str);
            props.remove("stats");
        }
        return this.setProperties(props);
    }

    public Properties getProperties() {
        return this.props;
    }

    public boolean isTrace() {
        return trace;
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"}, justification="GemFire doesn't use this method")
    public void setTrace(boolean trace) {
        Protocol.trace = trace;
    }

    public boolean isWarn() {
        return this.warn;
    }

    public void setWarn(boolean warn) {
        this.warn = warn;
    }

    public boolean upThreadEnabled() {
        return this.up_thread;
    }

    public boolean downThreadEnabled() {
        return this.down_thread;
    }

    public boolean statsEnabled() {
        return this.stats;
    }

    public void enableStats(boolean flag) {
        this.stats = flag;
    }

    public void resetStats() {
    }

    public String printStats() {
        return null;
    }

    public Map dumpStats() {
        return null;
    }

    public void setObserver(ProtocolObserver observer) {
        this.observer = observer;
        observer.setProtocol(this);
        if (this.up_handler != null) {
            this.up_handler.setObserver(observer);
        }
        if (this.down_handler != null) {
            this.down_handler.setObserver(observer);
        }
    }

    public void init() throws Exception {
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    public void destroy() {
    }

    public Queue getUpQueue() {
        return this.up_queue;
    }

    public Queue getDownQueue() {
        return this.down_queue;
    }

    public Vector requiredUpServices() {
        return null;
    }

    public Vector requiredDownServices() {
        return null;
    }

    public Vector providedUpServices() {
        return null;
    }

    public Vector providedDownServices() {
        return null;
    }

    public abstract String getName();

    public Protocol getUpProtocol() {
        return this.up_prot;
    }

    public Protocol getDownProtocol() {
        return this.down_prot;
    }

    public void setUpProtocol(Protocol up_prot) {
        this.up_prot = up_prot;
    }

    public void setDownProtocol(Protocol down_prot) {
        this.down_prot = down_prot;
    }

    public void setProtocolStack(ProtocolStack stack) {
        this.stack = stack;
    }

    public void startUpHandler() {
        if (this.up_thread && this.up_handler == null) {
            block5: {
                this.up_handler = new UpHandler(this.up_queue, this, this.observer);
                if (this.up_thread_prio >= 0) {
                    try {
                        this.up_handler.setPriority(this.up_thread_prio);
                    }
                    catch (VirtualMachineError err) {
                        SystemFailure.initiateFailure(err);
                        throw err;
                    }
                    catch (Throwable t) {
                        SystemFailure.checkFailure();
                        if (!this.log.isErrorEnabled()) break block5;
                        this.log.error("priority " + this.up_thread_prio + " could not be set for thread", t);
                    }
                }
            }
            this.up_handler.setDaemon(true);
            this.up_handler.start();
        }
    }

    public void startDownHandler() {
        if (this.down_thread && this.down_handler == null) {
            block5: {
                this.down_handler = new DownHandler(this.down_queue, this, this.observer);
                if (this.down_thread_prio >= 0) {
                    try {
                        this.down_handler.setPriority(this.down_thread_prio);
                    }
                    catch (VirtualMachineError err) {
                        SystemFailure.initiateFailure(err);
                        throw err;
                    }
                    catch (Throwable t) {
                        SystemFailure.checkFailure();
                        if (!this.log.isErrorEnabled()) break block5;
                        this.log.error("priority " + this.down_thread_prio + " could not be set for thread", t);
                    }
                }
            }
            this.down_handler.setDaemon(true);
            this.down_handler.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopInternal() {
        boolean interrupted;
        this.up_queue.close(false);
        if (this.up_handler != null && this.up_handler.isAlive()) {
            interrupted = Thread.interrupted();
            try {
                this.up_handler.join(1000L);
            }
            catch (InterruptedException ex) {
                interrupted = true;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.up_handler != null && this.up_handler.isAlive()) {
                this.up_handler.interrupt();
                interrupted = Thread.interrupted();
                try {
                    this.up_handler.join(1000L);
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (this.up_handler != null && this.up_handler.isAlive() && this.log.isErrorEnabled()) {
                    this.log.error("up_handler thread for " + this.getName() + " was interrupted (in order to be terminated), but is still alive");
                }
            }
        }
        this.up_handler = null;
        this.down_queue.close(false);
        if (this.down_handler != null && this.down_handler.isAlive()) {
            interrupted = Thread.interrupted();
            try {
                this.down_handler.join(1000L);
            }
            catch (InterruptedException ex) {
                interrupted = true;
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            if (this.down_handler != null && this.down_handler.isAlive()) {
                this.down_handler.interrupt();
                interrupted = Thread.interrupted();
                try {
                    this.down_handler.join(1000L);
                }
                catch (InterruptedException ex) {
                    interrupted = true;
                }
                finally {
                    if (interrupted) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (this.down_handler != null && this.down_handler.isAlive() && this.log.isErrorEnabled()) {
                    this.log.error("down_handler thread for " + this.getName() + " was interrupted (in order to be terminated), but is is still alive");
                }
            }
        }
        this.down_handler = null;
    }

    public void tunnelEventUp(Event evt) {
        this.receiveUpEvent(evt);
    }

    public void tunnelEventDown(Event evt) {
        this.receiveDownEvent(evt);
    }

    protected void receiveUpEvent(Event evt) {
        block6: {
            if (this.up_handler == null) {
                long sTime = 0L;
                if (this.stack.enableJgStackStats) {
                    sTime = this.startJgStackEventTime();
                }
                if (this.observer != null && !this.observer.up(evt, this.up_queue.size())) {
                    return;
                }
                this.up(evt);
                if (this.stack.enableJgStackStats) {
                    this.endJgStackEventTime(sTime, true);
                }
                return;
            }
            try {
                this.up_queue.add(evt);
            }
            catch (Exception e) {
                if (!this.log.isWarnEnabled()) break block6;
                this.log.warn("caught unexpected exception", e);
            }
        }
    }

    protected void receiveDownEvent(Event evt) {
        block7: {
            if (this.down_handler == null) {
                long sTime = 0L;
                if (this.stack.enableJgStackStats) {
                    sTime = this.startJgStackEventTime();
                }
                if (this.observer != null && !this.observer.down(evt, this.down_queue.size())) {
                    return;
                }
                int type = evt.getType();
                if (!(type != 61 && type != 63 || this.handleSpecialDownEvent(evt))) {
                    return;
                }
                this.down(evt);
                if (this.stack.enableJgStackStats) {
                    this.endJgStackEventTime(sTime, false);
                }
                return;
            }
            try {
                this.down_queue.add(evt);
            }
            catch (Exception e) {
                if (!this.log.isWarnEnabled()) break block7;
                this.log.warn("caught unexpected exception", e);
            }
        }
    }

    protected long startJgStackEventTime() {
        DMStats stats = this.stack.gemfireStats;
        if (stats == null) {
            return 0L;
        }
        return this.nanoTime();
    }

    protected void endJgStackEventTime(long start, boolean isUp) {
    }

    public void passUp(Event evt) {
        if (this.observer != null && !this.observer.passUp(evt)) {
            return;
        }
        this.up_prot.up(evt);
    }

    public void passDown(Event evt) {
        if (this.observer != null && !this.observer.passDown(evt)) {
            return;
        }
        if (this.down_prot != null) {
            int type = evt.getType();
            if (!(type != 61 && type != 63 || this.down_prot.handleSpecialDownEvent(evt))) {
                return;
            }
            this.down_prot.down(evt);
        }
    }

    public void up(Event evt) {
        this.passUp(evt);
    }

    public void down(Event evt) {
        this.passDown(evt);
    }

    protected boolean handleSpecialDownEvent(Event evt) {
        switch (evt.getType()) {
            case 61: {
                try {
                    this.start();
                    if (this.down_prot == null) {
                        this.passUp(new Event(62, Boolean.TRUE));
                        return false;
                    }
                    return true;
                }
                catch (Exception e) {
                    this.passUp(new Event(62, new Exception("exception caused by " + this.getName() + ".start()", e)));
                    return false;
                }
            }
            case 63: {
                this.stop();
                if (this.down_prot == null) {
                    this.passUp(new Event(64, Boolean.TRUE));
                    return false;
                }
                return true;
            }
        }
        return true;
    }
}

