/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.stack;

import com.gemstone.gemfire.internal.i18n.JGroupsStrings;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.Event;
import com.gemstone.org.jgroups.Message;
import com.gemstone.org.jgroups.SuspectedException;
import com.gemstone.org.jgroups.TimeoutException;
import com.gemstone.org.jgroups.View;
import com.gemstone.org.jgroups.blocks.GroupRequest;
import com.gemstone.org.jgroups.blocks.RequestCorrelator;
import com.gemstone.org.jgroups.blocks.RequestHandler;
import com.gemstone.org.jgroups.stack.Protocol;
import com.gemstone.org.jgroups.util.Rsp;
import com.gemstone.org.jgroups.util.RspList;
import com.gemstone.org.jgroups.util.Util;
import java.util.Vector;

public abstract class MessageProtocol
extends Protocol
implements RequestHandler {
    protected RequestCorrelator _corr = null;
    protected final Vector members = new Vector();

    @Override
    public void start() throws Exception {
        if (this._corr == null) {
            this._corr = new RequestCorrelator(this.getName(), this, this);
        }
        this._corr.start();
    }

    @Override
    public void stop() {
        if (this._corr != null) {
            this._corr.stop();
        }
    }

    public RspList castMessage(Vector dests, Message msg, int mode, long timeout) {
        GroupRequest _req = null;
        Vector real_dests = dests != null ? (Vector)dests.clone() : (Vector)this.members.clone();
        _req = new GroupRequest(msg, this._corr, real_dests, mode, timeout, 0);
        _req.execute();
        return _req.getResults();
    }

    public Object sendMessage(Message msg, int mode, long timeout) throws TimeoutException, SuspectedException {
        Rsp rsp;
        Vector<Address> mbrs = new Vector<Address>();
        RspList rsp_list = null;
        Address dest = msg.getDest();
        GroupRequest _req = null;
        if (dest == null) {
            System.out.println("MessageProtocol.sendMessage(): the message's destination is null ! Cannot send message !");
            return null;
        }
        mbrs.addElement(dest);
        _req = new GroupRequest(msg, this._corr, mbrs, mode, timeout, 0);
        _req.execute();
        if (mode == 6) {
            return null;
        }
        rsp_list = _req.getResults();
        if (rsp_list.size() == 0) {
            if (this.log.isErrorEnabled()) {
                this.log.error(JGroupsStrings.MessageProtocol_RESPONSE_LIST_IS_EMPTY);
            }
            return null;
        }
        if (rsp_list.size() > 1 && this.log.isErrorEnabled()) {
            this.log.error("response list contains more that 1 response; returning first response");
        }
        if ((rsp = (Rsp)rsp_list.elementAt(0)).wasSuspected()) {
            throw new SuspectedException(dest);
        }
        if (!rsp.wasReceived()) {
            throw new TimeoutException();
        }
        return rsp.getValue();
    }

    @Override
    public Object handle(Message req) {
        System.out.println("MessageProtocol.handle(): this method should be overridden !");
        return null;
    }

    @Override
    public final void up(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.updateView((View)evt.getArg());
                break;
            }
            default: {
                Message msg;
                Object hdr;
                if (!this.handleUpEvent(evt)) {
                    return;
                }
                if (evt.getType() == 1 && !((hdr = (msg = (Message)evt.getArg()).getHeader(this.getName())) instanceof RequestCorrelator.Header)) break;
                if (this._corr != null) {
                    this._corr.receive(evt);
                    return;
                }
                if (!this.log.isWarnEnabled()) break;
                this.log.warn("Request correlator is null, evt=" + Util.printEvent(evt));
            }
        }
        this.passUp(evt);
    }

    @Override
    public final void down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.updateView((View)evt.getArg());
                if (this.handleDownEvent(evt)) break;
                return;
            }
            case 1: {
                if (this.handleDownEvent(evt)) break;
                return;
            }
            default: {
                if (this.handleDownEvent(evt)) break;
                return;
            }
        }
        this.passDown(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateView(View new_view) {
        Vector new_mbrs = new_view.getMembers();
        if (new_mbrs != null) {
            Vector vector = this.members;
            synchronized (vector) {
                this.members.removeAllElements();
                this.members.addAll(new_mbrs);
            }
        }
    }

    protected boolean handleUpEvent(Event evt) {
        return true;
    }

    protected boolean handleDownEvent(Event evt) {
        return true;
    }
}

