/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.org.jgroups.stack;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.distributed.internal.membership.MemberAttributes;
import com.gemstone.gemfire.internal.DataSerializableFixedID;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.org.jgroups.Address;
import com.gemstone.org.jgroups.util.GemFireTracer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class IpAddress
implements DataSerializableFixedID,
Address {
    private static final long serialVersionUID = -294637383250428305L;
    private InetAddress ip_addr;
    private int port;
    private byte[] additional_data;
    protected static final GemFireTracer log = GemFireTracer.getLog(IpAddress.class);
    private static final String MEMBER_WEIGHT_PREFIX = "zzzmbrwgt";
    public static boolean resolve_dns = true;
    transient int size;
    private boolean shouldNotBeCoordinator;
    private boolean splitBrainEnabled;
    private byte memberWeight;
    private transient short version;
    private int processId;
    private int vmKind;
    private int birthViewId;
    private int directPort;
    private String name;
    private Object durableClientAttributes;
    private transient boolean isMcastAddr;
    private transient boolean isMcastAddrCached;
    byte[] cachedAddress;

    @Override
    public boolean preferredForCoordinator() {
        return !this.shouldNotBeCoordinator;
    }

    @Override
    public boolean splitBrainEnabled() {
        return this.splitBrainEnabled;
    }

    public void setMemberWeight(int weight) {
        this.memberWeight = (byte)Math.min(weight, 255);
    }

    public int getMemberWeight() {
        return this.memberWeight;
    }

    public void setProcessId(int pid) {
        this.processId = pid;
    }

    public int getProcessId() {
        return this.processId;
    }

    public void shouldntBeCoordinator(boolean shouldNotBe) {
        this.shouldNotBeCoordinator = shouldNotBe;
    }

    public void splitBrainEnabled(boolean enabled) {
        this.splitBrainEnabled = enabled;
    }

    public int getUniqueID() {
        return this.directPort != 0 ? this.directPort : this.processId;
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public String[] getRoles() {
        if (this.additional_data != null) {
            try {
                DataInputStream di = new DataInputStream(new ByteArrayInputStream(this.additional_data));
                return DataSerializer.readStringArray(di);
            }
            catch (Exception e) {
                throw new InternalGemFireException("unable to read roles", e);
            }
        }
        return new String[0];
    }

    public void setDurableClientAttributes(Object d) {
        this.durableClientAttributes = d;
    }

    public Object getDurableClientAttributes() {
        return this.durableClientAttributes;
    }

    public void setRoles(String[] roles) {
        if (roles.length > 0) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dao = new DataOutputStream(baos);
                DataSerializer.writeStringArray(roles, dao);
                this.additional_data = baos.toByteArray();
            }
            catch (Exception e) {
                throw new InternalGemFireException("unable to serialize roles", e);
            }
        }
    }

    public void setGemFireAttributes(MemberAttributes attr) {
        this.processId = attr.getVmPid();
        this.vmKind = attr.getVmKind();
        this.directPort = attr.getPort();
        this.birthViewId = attr.getVmViewId();
        this.name = attr.getName();
        this.setRoles(attr.getGroups());
        this.durableClientAttributes = attr.getDurableClientAttributes();
        this.size = -1;
        this.size = this.size(this.version);
    }

    public IpAddress() {
        this.ip_addr = null;
        this.port = 0;
        this.additional_data = null;
        this.size = -1;
        this.version = Version.CURRENT_ORDINAL;
    }

    public IpAddress(String i, int p) {
        block3: {
            this.ip_addr = null;
            this.port = 0;
            this.additional_data = null;
            this.size = -1;
            this.version = Version.CURRENT_ORDINAL;
            this.port = p;
            try {
                this.ip_addr = InetAddress.getByName(i);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block3;
                log.warn("failed to get " + i + ": " + e);
            }
        }
        if (this.ip_addr == null) {
            this.setAddressToLocalHost();
        }
    }

    public IpAddress(InetAddress i, int p) {
        this.ip_addr = null;
        this.port = 0;
        this.additional_data = null;
        this.size = -1;
        this.version = Version.CURRENT_ORDINAL;
        this.ip_addr = i;
        this.port = p;
        if (this.ip_addr == null) {
            this.setAddressToLocalHost();
        }
        this.setGemFireAttributes(MemberAttributes.DEFAULT);
    }

    private void setAddressToLocalHost() {
        block2: {
            try {
                String bindAddress = System.getProperty("gemfire.jg-bind-address");
                this.ip_addr = bindAddress != null && bindAddress.length() > 0 ? InetAddress.getByName(bindAddress) : SocketCreator.getLocalHost();
                this.size = -1;
                this.size = this.size(this.version);
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn("caught unexpected exception", e);
            }
        }
    }

    public IpAddress(int port) {
        this(port, true);
    }

    public IpAddress(int port, boolean set_default_host) {
        this.ip_addr = null;
        this.port = 0;
        this.additional_data = null;
        this.size = -1;
        this.version = Version.CURRENT_ORDINAL;
        this.port = port;
        if (set_default_host) {
            this.setAddressToLocalHost();
        }
        this.setGemFireAttributes(MemberAttributes.DEFAULT);
    }

    public final InetAddress getIpAddress() {
        return this.ip_addr;
    }

    public final int getPort() {
        return this.port;
    }

    public final SocketAddress getSocketAddress() {
        return new InetSocketAddress(this.ip_addr, this.port);
    }

    @Override
    public final boolean isMulticastAddress() {
        if (!this.isMcastAddrCached) {
            this.isMcastAddr = this.ip_addr != null && this.ip_addr.isMulticastAddress();
            this.isMcastAddrCached = true;
        }
        return this.isMcastAddr;
    }

    public final byte[] getAdditionalData() {
        return this.additional_data;
    }

    public final void setAdditionalData(byte[] additional_data) {
        this.additional_data = additional_data;
        this.size = -1;
        this.size = this.size(this.version);
    }

    public int getVmKind() {
        return this.vmKind;
    }

    public void setVmKind(int vmKind) {
        this.vmKind = vmKind;
    }

    public int getDirectPort() {
        return this.directPort;
    }

    public void setDirectPort(int directPort) {
        this.directPort = directPort;
    }

    @Override
    public int getBirthViewId() {
        return this.birthViewId;
    }

    public void setBirthViewId(long vid) {
        this.birthViewId = (int)(vid & Integer.MAX_VALUE);
    }

    @Override
    public final short getVersionOrdinal() {
        return this.version;
    }

    public final void setVersionOrdinal(short version) {
        this.version = version;
    }

    @Override
    public final Version getVersionObject() {
        return Version.fromOrdinalNoThrow(this.version, false);
    }

    public void setName(String v) {
        this.name = this.name == null ? "" : v;
    }

    public final int compare(IpAddress other) {
        return this.compareTo(other);
    }

    public final int compareTo(Object o) {
        int comp;
        byte[] otherBytes;
        if (this == o) {
            return 0;
        }
        if (o == null || !(o instanceof IpAddress)) {
            throw new ClassCastException("comparison between different classes: the other object is " + (o != null ? o.getClass() : o));
        }
        IpAddress other = (IpAddress)((Object)o);
        if (this.ip_addr == null) {
            if (other.ip_addr == null) {
                return this.port < other.port ? -1 : (this.port > other.port ? 1 : 0);
            }
            return -1;
        }
        byte[] myBytes = this.ip_addr.getAddress();
        if (myBytes != (otherBytes = other.ip_addr.getAddress())) {
            for (int i = 0; i < myBytes.length; ++i) {
                if (i >= otherBytes.length) {
                    return -1;
                }
                if (myBytes[i] < otherBytes[i]) {
                    return -1;
                }
                if (myBytes[i] <= otherBytes[i]) continue;
                return 1;
            }
            if (myBytes.length > otherBytes.length) {
                return 1;
            }
        }
        int n = this.port < other.port ? -1 : (comp = this.port > other.port ? 1 : 0);
        if (comp == 0) {
            if (this.birthViewId >= 0 && other.birthViewId >= 0) {
                if (this.birthViewId < other.birthViewId) {
                    comp = -1;
                } else if (other.birthViewId < this.birthViewId) {
                    comp = 1;
                }
            } else if (this.processId != 0 && other.processId != 0) {
                if (this.processId < other.processId) {
                    comp = -1;
                } else if (other.processId < this.processId) {
                    comp = 1;
                }
            }
        }
        return comp;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpAddress)) {
            return false;
        }
        return this.compareTo(obj) == 0;
    }

    public final int hashCode() {
        return this.ip_addr != null ? this.ip_addr.hashCode() + this.port : this.port;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.ip_addr == null) {
            sb.append("<null>");
        } else if (this.ip_addr.isMulticastAddress()) {
            sb.append(this.ip_addr.getHostAddress());
        } else {
            String host_name = null;
            host_name = resolve_dns ? SocketCreator.getHostName(this.ip_addr) : this.ip_addr.getHostAddress();
            this.appendShortName(host_name, sb);
        }
        if (!"".equals(this.name) || this.processId > 0) {
            sb.append('(');
            if (!"".equals(this.name)) {
                sb.append(this.name);
                if (this.processId > 0) {
                    sb.append(':');
                }
            }
            if (this.processId > 0) {
                sb.append(this.processId);
            }
            String vmStr = "";
            switch (this.vmKind) {
                case 10: {
                    break;
                }
                case 11: {
                    vmStr = ":locator";
                    break;
                }
                case 12: {
                    vmStr = ":admin";
                    break;
                }
                case 13: {
                    vmStr = ":loner";
                    break;
                }
            }
            sb.append(vmStr);
            sb.append(')');
        }
        if (this.splitBrainEnabled && !this.shouldNotBeCoordinator) {
            sb.append("<ec>");
        }
        if (this.birthViewId >= 0) {
            sb.append("<v" + this.birthViewId + ">");
        }
        if (this.version != Version.CURRENT_ORDINAL) {
            sb.append("(version:").append(Version.toString(this.version)).append(')');
        }
        sb.append(":" + this.port);
        return sb.toString();
    }

    private void appendShortName(String hostname, StringBuffer sb) {
        if (hostname == null) {
            return;
        }
        int index2 = hostname.indexOf(46);
        if (index2 > 0 && !Character.isDigit(hostname.charAt(0))) {
            sb.append(hostname.substring(0, index2));
        } else {
            sb.append(hostname);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.ip_addr != null) {
            byte[] address = this.ip_addr.getAddress();
            out.writeByte(address.length);
            out.write(address, 0, address.length);
        } else {
            out.writeByte(0);
        }
        out.writeShort(this.port & 0xFFFF);
        out.writeInt(this.processId);
        out.writeInt(this.directPort);
        out.writeByte(this.vmKind);
        out.writeInt(this.birthViewId);
        out.writeUTF(this.getName());
        if (this.additional_data != null) {
            out.writeInt(this.additional_data.length);
            out.write(this.additional_data, 0, this.additional_data.length);
        } else {
            out.writeInt(0);
        }
        out.writeByte(this.getFlags());
        Version.writeOrdinal(out, this.version, true);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int len = in.readUnsignedByte();
        if (len > 0) {
            byte[] a = new byte[len];
            in.readFully(a);
            this.ip_addr = InetAddress.getByAddress(a);
        }
        this.port = in.readUnsignedShort();
        this.processId = in.readInt();
        this.directPort = in.readInt();
        this.vmKind = in.readByte();
        this.birthViewId = in.readInt();
        this.name = in.readUTF();
        len = in.readInt();
        if (len > 0) {
            this.additional_data = new byte[len];
            in.readFully(this.additional_data, 0, this.additional_data.length);
        }
        int flags = in.readUnsignedByte();
        this.setFlags(flags);
        this.readVersion(flags, in);
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        this.toData(out);
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException {
        this.fromData(in);
    }

    public byte getFlags() {
        int flags = 0;
        if (this.shouldNotBeCoordinator) {
            flags |= 1;
        }
        if (this.splitBrainEnabled) {
            flags |= 2;
        }
        return (byte)((flags |= 4) & 0xFF);
    }

    public void setFlags(int flags) {
        if ((flags & 1) == 1) {
            this.shouldNotBeCoordinator = true;
        }
        if ((flags & 2) == 2) {
            this.splitBrainEnabled = true;
        }
    }

    public void readVersion(int flags, DataInput in) throws IOException {
        if ((flags & 4) == 4) {
            this.version = Version.readOrdinal(in);
            if (this.version == 0) {
                this.version = Version.CURRENT_ORDINAL;
            }
        }
    }

    @Override
    public int getDSFID() {
        return 70;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        if (this.ip_addr != null) {
            byte[] address = this.ip_addr.getAddress();
            out.writeByte(address.length);
            out.write(address, 0, address.length);
        } else {
            out.writeByte(0);
        }
        out.writeShort(this.port);
        out.writeInt(this.processId);
        out.writeInt(this.directPort);
        out.writeByte(this.vmKind);
        out.writeInt(this.birthViewId);
        out.writeUTF(this.getName());
        if (this.memberWeight > 0) {
            String[] roles = this.getRoles();
            String[] forser = new String[roles.length + 1];
            if (roles.length > 0) {
                System.arraycopy(roles, 0, forser, 0, roles.length);
            }
            forser[forser.length - 1] = MEMBER_WEIGHT_PREFIX + this.memberWeight;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dao = new DataOutputStream(baos);
            DataSerializer.writeStringArray(forser, dao);
            byte[] payload = baos.toByteArray();
            out.writeInt(payload.length);
            out.write(payload, 0, payload.length);
        } else if (this.additional_data != null) {
            out.writeInt(this.additional_data.length);
            out.write(this.additional_data, 0, this.additional_data.length);
        } else {
            out.writeInt(0);
        }
        out.writeByte(this.getFlags());
        Version.writeOrdinal(out, this.version, true);
    }

    @Override
    public void fromData(DataInput in) throws IOException {
        int len = in.readUnsignedByte();
        if (len > 0) {
            byte[] a = new byte[len];
            in.readFully(a);
            this.ip_addr = InetAddress.getByAddress(a);
        }
        this.port = in.readUnsignedShort();
        this.processId = in.readInt();
        this.directPort = in.readInt();
        this.vmKind = in.readByte();
        this.birthViewId = in.readInt();
        this.name = in.readUTF();
        len = in.readInt();
        if (len > 0) {
            int lastIndex;
            this.additional_data = new byte[len];
            in.readFully(this.additional_data, 0, this.additional_data.length);
            String[] roles = this.getRoles();
            int numValidRoles = lastIndex = roles.length - 1;
            if (roles.length > 0 && roles[lastIndex].startsWith(MEMBER_WEIGHT_PREFIX)) {
                String weightString = roles[lastIndex].substring(MEMBER_WEIGHT_PREFIX.length());
                this.memberWeight = Byte.parseByte(weightString);
                String[] newroles = new String[numValidRoles];
                System.arraycopy(roles, 0, newroles, 0, numValidRoles);
                this.setRoles(newroles);
            }
        }
        int flags = in.readUnsignedByte();
        this.setFlags(flags);
        this.readVersion(flags, in);
    }

    public void toDataShort(DataOutput out) throws IOException {
        byte[] address;
        if (this.cachedAddress != null) {
            address = this.cachedAddress;
        } else {
            this.cachedAddress = address = this.ip_addr.getAddress();
        }
        out.writeByte(address.length);
        out.write(address, 0, address.length);
        out.writeShort(this.port);
    }

    public void fromDataShort(DataInput in) throws IOException {
        int len = in.readUnsignedByte();
        byte[] a = new byte[len];
        in.readFully(a);
        this.ip_addr = InetAddress.getByAddress(a);
        this.port = in.readUnsignedShort();
    }

    @Override
    public int size(short version) {
        if (this.size >= 0) {
            return this.size;
        }
        int tmp_size = 1;
        if (this.ip_addr != null) {
            tmp_size += this.ip_addr.getAddress().length;
        }
        tmp_size += 2;
        tmp_size += 4;
        tmp_size += 4;
        ++tmp_size;
        tmp_size += 4;
        tmp_size += 4;
        if (this.additional_data != null) {
            tmp_size += this.additional_data.length;
        }
        ++tmp_size;
        this.size = tmp_size += this.version < 256 ? 1 : 3;
        return tmp_size;
    }

    public Object clone() throws CloneNotSupportedException {
        IpAddress ret = new IpAddress(this.ip_addr, this.port);
        ret.processId = this.processId;
        ret.shouldNotBeCoordinator = this.shouldNotBeCoordinator;
        ret.splitBrainEnabled = this.splitBrainEnabled;
        ret.name = this.name;
        ret.version = this.version;
        ret.birthViewId = this.birthViewId;
        if (this.additional_data != null) {
            ret.additional_data = new byte[this.additional_data.length];
            System.arraycopy(this.additional_data, 0, ret.additional_data, 0, this.additional_data.length);
        }
        return ret;
    }

    @Override
    public Version[] getSerializationVersions() {
        return null;
    }
}

